/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.parsing;

import com.aptana.core.IMap;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.html.contentassist.HTMLIndexQueryHelper;
import com.aptana.editor.html.contentassist.model.EventElement;
import com.aptana.editor.html.parsing.lexer.HTMLTokenType;
import com.aptana.parsing.lexer.Lexeme;
import com.aptana.parsing.lexer.Range;
import com.pandora.core.CoreActivator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HTMLUtils {
    private static final String STYLE = "style";
    private static final String JAVASCRIPT = "javascript";
    private static Set<String> fgEventsMap;

    public static boolean isCSSAttribute(String name) {
        boolean result = false;
        if (name != null) {
            result = name.equalsIgnoreCase(STYLE);
        }
        return result;
    }

    public static boolean isJSAttribute(String elementName, String attributeName) {
        if (elementName == null || attributeName == null) {
            return false;
        }
        if (!CoreActivator.getDefault().isIdeStarted()) {
            return attributeName.toLowerCase().startsWith("on");
        }
        if (CollectionsUtil.isEmpty(fgEventsMap)) {
            List<EventElement> events = new HTMLIndexQueryHelper().getEvents();
            fgEventsMap = new HashSet<String>(CollectionsUtil.map(events, (IMap)new IMap<EventElement, String>(){

                public String map(EventElement item) {
                    return item.getName();
                }
            }));
        }
        return fgEventsMap.contains(attributeName.toLowerCase());
    }

    public static String stripTagEndings(String tag) {
        if (tag == null) {
            return null;
        }
        String trimmed = tag.trim();
        int length = trimmed.length();
        if (length > 0 && trimmed.charAt(0) == '<') {
            trimmed = length > 1 && trimmed.charAt(1) == '/' ? trimmed.substring(2).trim() : trimmed.substring(1).trim();
            length = trimmed.length();
        }
        if (length > 0 && trimmed.charAt(length - 1) == '>') {
            trimmed = trimmed.substring(0, length - 1).trim();
        }
        return trimmed;
    }

    public static boolean isTagSelfClosing(String tagContents) {
        return HTMLUtils.isTagComplete(tagContents) && tagContents.length() >= 2 && tagContents.charAt(tagContents.length() - 2) == '/';
    }

    public static boolean isTagComplete(String tagContents) {
        if (tagContents == null || tagContents.length() < 1) {
            return false;
        }
        return tagContents.charAt(tagContents.length() - 1) == '>';
    }

    public static boolean isJavaScriptTag(String tagContents) {
        if (!HTMLUtils.isTagComplete(tagContents)) {
            return false;
        }
        String type = HTMLUtils.getTagAttribute(tagContents, "type");
        if (type != null && (type.toLowerCase().contains(JAVASCRIPT) || type.toLowerCase().contains("babel") || type.toLowerCase().contains("ecmascript"))) {
            return true;
        }
        String language = HTMLUtils.getTagAttribute(tagContents, "language");
        if (language != null && (language.toLowerCase().contains(JAVASCRIPT) || language.toLowerCase().contains("babel") || language.toLowerCase().contains("ecmascript"))) {
            return true;
        }
        return type == null && language == null;
    }

    private static String getTagAttribute(String tagContents, String attributeName) {
        Matcher matcher = Pattern.compile(".*\\s+" + attributeName + "=\"([a-zA-Z_/0-9-]+)\".*").matcher(tagContents.toLowerCase());
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    public static Range getAttributeValueRange(Lexeme<HTMLTokenType> lexeme, int offset) {
        if (lexeme == null || lexeme.getType() == null) {
            return null;
        }
        switch ((HTMLTokenType)((Object)lexeme.getType())) {
            case DOUBLE_QUOTED_STRING: 
            case SINGLE_QUOTED_STRING: {
                if (offset <= lexeme.getStartingOffset() || offset > lexeme.getEndingOffset()) {
                    return null;
                }
                if (lexeme.getLength() < 2) break;
                int startingOffset = lexeme.getStartingOffset() + 1;
                String text = lexeme.getText().substring(1, lexeme.getLength() - 1);
                int start = StringUtil.findPreviousWhitespaceOffset((String)text, (int)(offset - startingOffset));
                int end = StringUtil.findNextWhitespaceOffset((String)text, (int)(offset - startingOffset));
                start = start < 0 ? 0 : ++start;
                if (end < 0) {
                    end = text.length();
                }
                int endOffset = end + startingOffset - 1;
                return new Range(start + startingOffset, endOffset);
            }
        }
        return new Range(lexeme.getStartingOffset(), lexeme.getEndingOffset());
    }
}

