/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.parsing;

import com.aptana.editor.common.text.rules.CollectingCharacterScanner;
import com.aptana.editor.common.text.rules.ExtendedToken;
import com.aptana.editor.common.text.rules.SequenceCharacterScanner;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.Token;

class HTMLParserTagRule
extends MultiLineRule {
    private static final IToken singleQuoteStringTOKEN = new Token((Object)"SQS");
    private static final IPredicateRule singleQuoteStringRule = new MultiLineRule("'", "'", singleQuoteStringTOKEN, '\\');
    private static final IPredicateRule singleQuoteStringEOLRule = new EndOfLineRule("'", singleQuoteStringTOKEN, '\\');
    private static final IToken doubleQuoteStringTOKEN = new Token((Object)"DQS");
    private static final IPredicateRule doubleQuoteStringRule = new MultiLineRule("\"", "\"", doubleQuoteStringTOKEN, '\\');
    private static final IPredicateRule doubleQuoteStringEOLRule = new EndOfLineRule("\"", doubleQuoteStringTOKEN, '\\');
    private boolean fIgnoreCase;
    private int fEmbeddedStart;

    HTMLParserTagRule(IToken token) {
        this("", token);
    }

    HTMLParserTagRule(String tag, IToken token) {
        this(tag, token, false);
    }

    HTMLParserTagRule(String tag, IToken token, boolean ignoreCase) {
        this("<" + tag, ">", token, ignoreCase);
    }

    protected HTMLParserTagRule(String startSequence, String endSequence, IToken token, boolean ignoreCase) {
        super(startSequence, endSequence, token);
        this.fIgnoreCase = ignoreCase;
    }

    protected boolean sequenceDetected(ICharacterScanner scanner, char[] sequence, boolean eofAllowed) {
        boolean detected = true;
        int i = 1;
        while (i < sequence.length) {
            int c = scanner.read();
            if (c == -1 && eofAllowed) break;
            if (this.fIgnoreCase && Character.toLowerCase(c) != Character.toLowerCase(sequence[i]) || !this.fIgnoreCase && c != sequence[i]) {
                scanner.unread();
                int j = i - 1;
                while (j > 0) {
                    scanner.unread();
                    --j;
                }
                detected = false;
                break;
            }
            ++i;
        }
        if (!detected) {
            return detected;
        }
        if (sequence.length == 1 && sequence[0] == '<' || sequence.length == 2 && sequence[0] == '<' && sequence[1] == '/') {
            int nextChar = scanner.read();
            if (nextChar == -1) {
                return false;
            }
            scanner.unread();
            return Character.isJavaIdentifierStart(nextChar);
        }
        return detected;
    }

    protected boolean endSequenceDetected(ICharacterScanner scanner) {
        int c;
        CollectingCharacterScanner collectingCharacterScanner = new CollectingCharacterScanner(scanner, String.valueOf(this.fStartSequence));
        int length = 0;
        while ((c = collectingCharacterScanner.read()) != -1) {
            IToken token;
            ++length;
            if (c == 39) {
                collectingCharacterScanner.unread();
                token = singleQuoteStringRule.evaluate((ICharacterScanner)collectingCharacterScanner);
                if (!token.isUndefined()) continue;
                token = singleQuoteStringEOLRule.evaluate((ICharacterScanner)collectingCharacterScanner);
                continue;
            }
            if (c == 34) {
                collectingCharacterScanner.unread();
                token = doubleQuoteStringRule.evaluate((ICharacterScanner)collectingCharacterScanner);
                if (!token.isUndefined()) continue;
                token = doubleQuoteStringEOLRule.evaluate((ICharacterScanner)collectingCharacterScanner);
                continue;
            }
            if (c == this.fStartSequence[0]) {
                ++this.fEmbeddedStart;
                continue;
            }
            if (c != this.fEndSequence[0]) continue;
            if (this.fEmbeddedStart == 0) {
                if (this.fToken instanceof ExtendedToken) {
                    ((ExtendedToken)this.fToken).setContents(collectingCharacterScanner.getContents());
                }
                return true;
            }
            --this.fEmbeddedStart;
        }
        if (scanner instanceof SequenceCharacterScanner && ((SequenceCharacterScanner)scanner).foundSequence()) {
            if (this.fToken instanceof ExtendedToken) {
                ((ExtendedToken)this.fToken).setContents(collectingCharacterScanner.getContents());
            }
            return true;
        }
        int i = 0;
        while (i < length) {
            collectingCharacterScanner.unread();
            ++i;
        }
        collectingCharacterScanner.unread();
        return false;
    }
}

