/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.internal.text.rules;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class BrokenStringRule
implements IRule {
    private final IToken singleQuoteToken;
    private final IToken doubleQuoteToken;

    public BrokenStringRule(IToken singleQuoteToken, IToken doubleQuoteToken) {
        this.singleQuoteToken = singleQuoteToken;
        this.doubleQuoteToken = doubleQuoteToken;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        int c;
        int readCount = 1;
        while ((c = scanner.read()) != -1) {
            if (c == 39) {
                return this.singleQuoteToken;
            }
            if (c == 34) {
                return this.doubleQuoteToken;
            }
            if (c == 61 || c == 60 && readCount == 1) break;
            ++readCount;
        }
        while (readCount-- > 0) {
            scanner.unread();
        }
        return Token.UNDEFINED;
    }
}

