/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.ext.inferrer;

import com.aptana.core.util.StringUtil;
import com.aptana.editor.html.ext.inferrer.HTMLNodeInferrer;
import com.aptana.editor.html.parsing.ast.HTMLElementNode;
import com.aptana.editor.html.parsing.ast.HTMLSpecialNode;
import java.util.HashSet;
import java.util.Set;

public class HTMLElementIDInferrer
extends HTMLNodeInferrer {
    private String id = null;
    private Set<String> tags = new HashSet<String>();

    public HTMLElementIDInferrer(String id) {
        this.id = id;
    }

    @Override
    public void visit(HTMLSpecialNode specialNode) {
        String idValue = specialNode.getID();
        if (StringUtil.isEmpty((String)idValue)) {
            return;
        }
        if (idValue.equals(this.id)) {
            this.tags.add(specialNode.getElementName());
        }
        super.visit(specialNode);
    }

    @Override
    public void visit(HTMLElementNode elementNode) {
        String idValue = elementNode.getID();
        if (StringUtil.isEmpty((String)idValue)) {
            return;
        }
        if (idValue.equals(this.id)) {
            this.tags.add(elementNode.getElementName());
        }
        super.visit(elementNode);
    }

    public Set<String> getTags() {
        return this.tags;
    }
}

