/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.ext.inferrer;

import com.aptana.core.util.StringUtil;
import com.aptana.editor.html.ext.inferrer.HTMLNodeInferrer;
import com.aptana.editor.html.parsing.ast.HTMLElementNode;
import com.aptana.editor.html.parsing.ast.HTMLSpecialNode;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class HTMLElementClassInferrer
extends HTMLNodeInferrer {
    private String cls = null;
    private Set<String> tags = new HashSet<String>();

    public HTMLElementClassInferrer(String cls) {
        this.cls = cls;
    }

    @Override
    public void visit(HTMLSpecialNode specialNode) {
        String clsValue = specialNode.getCSSClass();
        if (StringUtil.isEmpty((String)clsValue)) {
            return;
        }
        String[] classes = clsValue.split(" ");
        if (Arrays.asList(classes).contains(this.cls)) {
            this.tags.add(specialNode.getElementName());
        }
        super.visit(specialNode);
    }

    @Override
    public void visit(HTMLElementNode elementNode) {
        String clsValue = elementNode.getCSSClass();
        if (StringUtil.isEmpty((String)clsValue)) {
            return;
        }
        String[] classes = clsValue.split(" ");
        if (Arrays.asList(classes).contains(this.cls)) {
            this.tags.add(elementNode.getElementName());
        }
        super.visit(elementNode);
    }

    public Set<String> getTags() {
        return this.tags;
    }
}

