/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.ext;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.IOUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.ExtendedFastPartitioner;
import com.aptana.editor.common.IExtendedPartitioner;
import com.aptana.editor.common.IPartitionerSwitchStrategy;
import com.aptana.editor.common.IPartitioningConfiguration;
import com.aptana.editor.common.NullPartitionerSwitchStrategy;
import com.aptana.editor.common.contentassist.CompletionProposalType;
import com.aptana.editor.common.text.rules.CompositePartitionScanner;
import com.aptana.editor.common.text.rules.ISubPartitionScanner;
import com.aptana.editor.common.text.rules.NullSubPartitionScanner;
import com.aptana.editor.common.util.EditorUtil;
import com.aptana.editor.html.HTMLSourceConfiguration;
import com.aptana.editor.html.contentassist.HTMLAttributeValueProposal;
import com.aptana.editor.html.contentassist.HTMLContentAssistProcessor;
import com.aptana.editor.html.contentassist.HTMLIndexQueryHelper;
import com.aptana.editor.html.contentassist.model.ValueElement;
import com.aptana.editor.html.ext.FileSpecialListHandler;
import com.aptana.editor.js.JSSourceEditor;
import com.aptana.parsing.lexer.IRange;
import com.aptana.parsing.lexer.Range;
import com.pandora.core.utils.RegularUtils;
import com.pandora.core.utils.URIUtils;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.ui.IFileEditorInput;

public class URLSpecialListHandler
extends FileSpecialListHandler {
    private boolean needAddRelativePath = false;
    private boolean selfPrefix = false;
    private boolean needAddURL = false;

    @Override
    public void doComputeSpecialProposals(AbstractThemeableEditor editor, int offset, IRange repalceRange, Set<ICompletionProposal> result, boolean isHTML) {
        this._queryHelper = new HTMLIndexQueryHelper();
        this.editor = editor;
        this.repalceRange = repalceRange;
        this.init();
        if (this.project == null || this.iFile == null) {
            return;
        }
        this.setSelfPrefix(false);
        boolean isRelative = false;
        try {
            int replaceOffset = offset;
            String valuePrefix = this.editor.getDocument().get(repalceRange.getStartingOffset(), offset - repalceRange.getStartingOffset());
            if (valuePrefix.length() > 0 && (valuePrefix.charAt(0) == '\"' || valuePrefix.charAt(0) == '\'')) {
                valuePrefix = valuePrefix.substring(1);
                replaceOffset = repalceRange.getStartingOffset() + 1;
            }
            this.setNeedAddRelativePath(false);
            int pOffset = 0;
            if (this.isNeedAddURL()) {
                if (valuePrefix.startsWith("url(")) {
                    pOffset = 4;
                    valuePrefix = valuePrefix.replace("url(", "");
                } else if (valuePrefix.startsWith("url('")) {
                    pOffset = 5;
                    valuePrefix = valuePrefix.replace("url('", "");
                } else if (valuePrefix.startsWith("url(\"")) {
                    pOffset = 5;
                    valuePrefix = valuePrefix.replace("url(\"", "");
                } else {
                    this.setNeedAddRelativePath(true);
                }
            }
            URI editorStoreURI = this.getURI(editor);
            IFileStore editorStore = null;
            if (editorStoreURI != null) {
                editorStore = EFS.getStore((URI)editorStoreURI);
            }
            IFileStore baseStore = null;
            if (valuePrefix.length() > 0 && valuePrefix.charAt(0) == '/') {
                IFileStore publicDir;
                URI projectUri = this.getProjectAppSourceURI();
                if (projectUri != null && (publicDir = (baseStore = EFS.getStore((URI)projectUri)).getChild("public")).fetchInfo().exists()) {
                    baseStore = publicDir;
                }
            } else if (valuePrefix.contains(":/")) {
                if (valuePrefix.endsWith(":/")) {
                    return;
                }
                if ("file://".equals(valuePrefix)) {
                    baseStore = EFS.getLocalFileSystem().getStore((IPath)Path.ROOT);
                    replaceOffset += valuePrefix.length();
                    valuePrefix = "";
                } else {
                    try {
                        URI parsed = null;
                        int lastSlash = valuePrefix.lastIndexOf(47);
                        if (lastSlash != -1 && lastSlash < valuePrefix.length() - 1) {
                            parsed = URI.create(valuePrefix.substring(0, lastSlash));
                            replaceOffset += lastSlash + 1;
                            valuePrefix = valuePrefix.substring(lastSlash + 1);
                        } else {
                            parsed = URI.create(valuePrefix);
                            replaceOffset += valuePrefix.length();
                            valuePrefix = "";
                        }
                        baseStore = EFS.getStore((URI)parsed);
                    }
                    catch (Exception exception) {
                        return;
                    }
                }
            } else if (valuePrefix.startsWith("../")) {
                if (this.iFile != null) {
                    int index = valuePrefix.lastIndexOf("/");
                    String pPath = valuePrefix.substring(0, index + 1);
                    String path = URIUtils.resolveURI((String)this.iFile.getLocationURI().toString(), (String)pPath);
                    baseStore = EFS.getStore((URI)URI.create(path));
                    isRelative = true;
                }
            } else if (editorStore != null) {
                baseStore = editorStore.getParent();
            }
            String rvaluePrefix = valuePrefix;
            int lastSlash = valuePrefix.lastIndexOf(47);
            if (lastSlash != -1) {
                if (this.isNeedAddURL()) {
                    this.setSelfPrefix(true);
                }
                if (!isRelative) {
                    IFileStore possibleChild = baseStore.getChild(valuePrefix.substring(0, lastSlash));
                    if (possibleChild.fetchInfo().exists()) {
                        baseStore = possibleChild;
                    } else {
                        return;
                    }
                }
                replaceOffset = this.repalceRange.getStartingOffset() + lastSlash + 1 + pOffset;
                valuePrefix = valuePrefix.substring(lastSlash + 1);
            } else {
                replaceOffset = this.repalceRange.getStartingOffset();
            }
            Range range = null;
            range = this.isNeedAddURL() && this.getSelfPrefix() ? new Range(replaceOffset, replaceOffset + valuePrefix.length() - 1) : new Range(replaceOffset, this.repalceRange.getEndingOffset());
            this.addFileProposal(baseStore, result, valuePrefix, (IRange)range, isHTML);
            if (!this.isNeedAddURL()) {
                this.addAnchorProposals(result, offset, isHTML);
            }
            this.addRelativePath(result, (IRange)range, isHTML, rvaluePrefix);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (BadLocationException e1) {
            e1.printStackTrace();
        }
    }

    public boolean isNeedAddRelativePath() {
        return this.needAddRelativePath;
    }

    public void setNeedAddRelativePath(boolean needAddRelativePath) {
        this.needAddRelativePath = needAddRelativePath;
    }

    private void setSelfPrefix(boolean selfPrefix) {
        this.selfPrefix = selfPrefix;
    }

    private boolean getSelfPrefix() {
        return this.selfPrefix;
    }

    private void addRelativePath(Set<ICompletionProposal> result, IRange range, boolean isHTML, String valuePrefix) throws BadLocationException, CoreException {
        if (this.iFile == null) {
            return;
        }
        if (!this.isNeedAddURL()) {
            valuePrefix = this.editor.getDocument().get(this.repalceRange.getStartingOffset(), this.repalceRange.getLength());
        }
        if (StringUtil.isBlank((String)valuePrefix) && !this.getSelfPrefix() || this.isNeedAddRelativePath()) {
            String name = "/";
            if (this.isNeedAddURL()) {
                name = "url(" + name + ")";
            }
            ValueElement value = this.createValueElement(name);
            HTMLAttributeValueProposal proposal = new HTMLAttributeValueProposal(value, range, null);
            proposal.setApplyNeedReContentAssist(true);
            this.setCursorPosition(name, proposal);
            proposal.setCompletionProposalType(CompletionProposalType.FOLDER);
            proposal.setImage(HTMLContentAssistProcessor.FOLDER_ICON);
            proposal.setIsHTML(isHTML);
            proposal.setSelfPrefix(this.getSelfPrefix());
            result.add((ICompletionProposal)proposal);
        }
        String filePath = this.iFile.getProjectRelativePath().toString();
        String projectPath = "";
        String relativePath = URIUtils.relativeURI((String)filePath, (String)projectPath);
        String relativeStr = "../";
        char replaceChar = '\u4e96';
        String replaceStr = "\u4e96";
        relativePath = relativePath.replace(relativeStr, replaceStr);
        int count = StringUtil.characterInstanceCount((String)relativePath, (char)replaceChar);
        if (StringUtil.isNotBlank((String)relativePath)) {
            if (StringUtil.isBlank((String)valuePrefix)) {
                this.addRelativePathProposal(result, range, null, isHTML);
            } else {
                int rcount;
                String exString = (valuePrefix = valuePrefix.replace(relativeStr, replaceStr)).replace(replaceStr, "");
                if ((exString.length() <= 0 || this.isNeedAddRelativePath()) && count > (rcount = StringUtil.characterInstanceCount((String)valuePrefix, (char)replaceChar))) {
                    this.addRelativePathProposal(result, range, null, isHTML);
                }
            }
        }
    }

    private void addRelativePathProposal(Set<ICompletionProposal> proposals, IRange range, Map<String, String> userAgentIcons, boolean isHTML) {
        String name = "../";
        if (this.isNeedAddURL() && !this.getSelfPrefix()) {
            name = "url(" + name + ")";
        }
        ValueElement value = this.createValueElement(name);
        HTMLAttributeValueProposal proposal = new HTMLAttributeValueProposal(value, range, userAgentIcons);
        proposal.setApplyNeedReContentAssist(true);
        this.setCursorPosition(name, proposal);
        proposal.setCompletionProposalType(CompletionProposalType.FOLDER);
        proposal.setImage(HTMLContentAssistProcessor.FOLDER_ICON);
        proposal.setIsHTML(isHTML);
        proposal.setSelfPrefix(this.getSelfPrefix());
        proposals.add((ICompletionProposal)proposal);
    }

    private void setCursorPosition(String name, HTMLAttributeValueProposal proposal) {
        if (this.isNeedAddURL() && !this.getSelfPrefix()) {
            proposal.setCursorPosition(name.length() - 1);
        }
    }

    private void addAnchorProposals(Set<ICompletionProposal> result, int offset, boolean isHTML) throws BadLocationException, CoreException {
        String valuePrefix = this.editor.getDocument().get(this.repalceRange.getStartingOffset(), this.repalceRange.getLength());
        String filePath = "";
        if (StringUtil.isBlank((String)valuePrefix) || valuePrefix.startsWith("#")) {
            if (this.iFile != null) {
                filePath = this.iFile.getProjectRelativePath().toString();
            }
        } else {
            boolean isHtml = this.isHTML(valuePrefix);
            if (isHtml) {
                if (valuePrefix.startsWith("/")) {
                    filePath = valuePrefix.substring(1, valuePrefix.length());
                } else if (this.iFile != null) {
                    filePath = URIUtils.resolveURI((String)this.iFile.getProjectRelativePath().toString(), (String)valuePrefix);
                }
            }
        }
        if (StringUtil.isNotBlank((String)filePath)) {
            Range range = null;
            if (valuePrefix.lastIndexOf("#") > -1) {
                offset = this.repalceRange.getStartingOffset() + valuePrefix.lastIndexOf("#");
                range = new Range(offset, offset + valuePrefix.length() - valuePrefix.lastIndexOf("#") - 1);
            } else {
                offset = this.repalceRange.getEndingOffset() + 1;
                range = new Range(offset, offset - 1);
            }
            this.getActhorProposal(result, (IRange)range, filePath, isHTML);
            this.getNameActhorProposal(result, (IRange)range, filePath, isHTML);
        }
    }

    private void getNameActhorProposal(Set<ICompletionProposal> result, IRange range, String filePath, boolean isHTML) throws CoreException, BadLocationException {
        if (this.project == null) {
            return;
        }
        String pPath = this.project.getLocation().toString();
        String fPath = String.valueOf(pPath) + "/" + filePath;
        IPath iPath = Path.fromOSString((String)fPath);
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(iPath);
        IDocument document = this.getDocumentByIFile(file);
        int lineCount = document.getNumberOfLines();
        int i = 0;
        while (i < lineCount) {
            String content_;
            String REG;
            String nameValue;
            int lineOffset;
            ITypedRegion partition;
            String type;
            IRegion region = document.getLineInformation(i);
            String lineStr = document.get(region.getOffset(), region.getLength());
            int index = lineStr.indexOf("<a ");
            if (index > -1 && (type = (partition = document.getPartition(lineOffset = region.getOffset() + index + 1)).getType()).equals("__html_tag") && StringUtil.isNotBlank((String)(nameValue = RegularUtils.match((String)(REG = "name[\\s]*=[\\s]*[\"']([&\\=\\?\\s\\.:/_a-zA-Z0-9\u4e00-\u9fa5-\\\\]*)[\"']"), (String)(content_ = document.get(partition.getOffset(), partition.getLength())), (int)1)))) {
                ValueElement value = this.createValueElement("#" + nameValue);
                HTMLAttributeValueProposal proposal = new HTMLAttributeValueProposal(value, range, null);
                proposal.setCompletionProposalType(CompletionProposalType.ANCHOR);
                proposal.setIsHTML(isHTML);
                result.add((ICompletionProposal)proposal);
            }
            ++i;
        }
    }

    private IDocument getDocumentByIFile(IFile iFile) throws CoreException {
        InputStream inputStream = iFile.getContents();
        String content = IOUtil.read((InputStream)inputStream);
        Document document = new Document(content);
        document = this.formatHTMLPartitioner((IDocument)document);
        return document;
    }

    private IDocument formatHTMLPartitioner(IDocument document) {
        CompositePartitionScanner partitionScanner = new CompositePartitionScanner(HTMLSourceConfiguration.getDefault().createSubPartitionScanner(), (ISubPartitionScanner)new NullSubPartitionScanner(), (IPartitionerSwitchStrategy)new NullPartitionerSwitchStrategy());
        ExtendedFastPartitioner partitioner = new ExtendedFastPartitioner((IPartitionTokenScanner)partitionScanner, HTMLSourceConfiguration.getDefault().getContentTypes());
        partitionScanner.setPartitioner((IExtendedPartitioner)partitioner);
        partitioner.connect(document);
        document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        CommonEditorPlugin.getDefault().getDocumentScopeManager().registerConfiguration(document, (IPartitioningConfiguration)HTMLSourceConfiguration.getDefault());
        return document;
    }

    private void getActhorProposal(Set<ICompletionProposal> result, IRange range, String filePath, boolean isHTML) {
        HTMLIndexQueryHelper queryHelper = new HTMLIndexQueryHelper();
        Map<String, String> ids = queryHelper.getIDs(this.getIndex(this.editor));
        if (ids != null) {
            for (Map.Entry<String, String> entry : ids.entrySet()) {
                String location = entry.getValue();
                if (!filePath.equals(location)) continue;
                ValueElement value = this.createValueElement("#" + entry.getKey());
                HTMLAttributeValueProposal proposal = new HTMLAttributeValueProposal(value, range, null);
                proposal.setCompletionProposalType(CompletionProposalType.ANCHOR);
                proposal.setIsHTML(isHTML);
                result.add((ICompletionProposal)proposal);
            }
        }
    }

    private boolean isHTML(String valuePrefix) {
        boolean isHtml = false;
        if (StringUtil.isNotBlank((String)valuePrefix) && !(isHtml = this.checkHTMLExtend(valuePrefix)) && valuePrefix.lastIndexOf("#") > 0) {
            valuePrefix = valuePrefix.substring(0, valuePrefix.lastIndexOf("#"));
            isHtml = this.checkHTMLExtend(valuePrefix);
        }
        return isHtml;
    }

    private boolean checkHTMLExtend(String valuePrefix) {
        boolean isHtml = false;
        String[] stringArray = HTMLContentAssistProcessor.HTML_EXTENDTIONS;
        int n = HTMLContentAssistProcessor.HTML_EXTENDTIONS.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            if (valuePrefix.endsWith("." + key)) {
                isHtml = true;
                break;
            }
            ++n2;
        }
        return isHtml;
    }

    private URI getProjectAppSourceURI() {
        URI projectUri = this.getProjectURI(this.editor);
        if (projectUri != null) {
            String wpath = projectUri.toString();
            try {
                projectUri = new URI(wpath);
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return projectUri;
    }

    public void addFileProposal(IFileStore projectStore, Set<ICompletionProposal> list, String valuePrefix, IRange range, boolean isHTML) throws CoreException {
        IFileStore[] projectFileStores = projectStore.childStores(0, (IProgressMonitor)new NullProgressMonitor());
        if (projectFileStores == null || projectFileStores.length == 0) {
            return;
        }
        String pPath = this.project.getLocation().toString();
        int length = pPath.length() + 1;
        int i = 0;
        while (i < projectFileStores.length) {
            String fPath;
            String rePath;
            IFileStore fileStore = projectFileStores[i];
            File file = fileStore.toLocalFile(0, (IProgressMonitor)new NullProgressMonitor());
            String fname = file.getName();
            if (!(fname.charAt(0) == '.' || StringUtil.contains((String[])HTMLContentAssistProcessor.HTML_EXCLUDE_PROJECT_FILE, (String)fname) || fname.equals(valuePrefix) || (rePath = (fPath = file.getPath()).replace("\\", "/")).length() > length - 1 && ((rePath = rePath.substring(length)).startsWith(UNPACKAGE_DIR) || file.isDirectory() && rePath.equals("unpackage")))) {
                String extend = this.getExtention(fname);
                String pname = this.getFName(file);
                ValueElement value = this.createValueElement(pname);
                HTMLAttributeValueProposal proposal = new HTMLAttributeValueProposal(value, range, null);
                proposal.setFileInfo(file, !this.isNeedAddURL() || this.getSelfPrefix());
                if (StringUtil.isNotBlank((String)extend) && StringUtil.contains((String[])this._queryHelper.getImageExtendValueList(), (String)extend.toLowerCase()) && file.exists()) {
                    proposal.setShowImage(true);
                    proposal.setShowImagePath(fPath);
                }
                if (file.isDirectory() || StringUtil.contains((String[])HTMLContentAssistProcessor.HTML_EXTENDTIONS, (String)extend) && !this.isNeedAddURL()) {
                    proposal.setApplyNeedReContentAssist(true);
                }
                this.setCursorPosition(pname, proposal);
                if (file.isFile()) {
                    proposal.setCompletionProposalType(CompletionProposalType.FILE);
                    proposal = this.setImageIcon(proposal, extend);
                } else {
                    proposal.setCompletionProposalType(CompletionProposalType.FOLDER);
                    proposal.setImage(HTMLContentAssistProcessor.FOLDER_ICON);
                }
                proposal.setSelfPrefix(this.getSelfPrefix());
                proposal.setIsHTML(isHTML);
                list.add((ICompletionProposal)proposal);
            }
            ++i;
        }
    }

    private String getFName(File file) {
        String name = file.getName();
        if (this.isNeedAddURL() && !this.getSelfPrefix()) {
            name = file.isDirectory() ? "url(" + name + "/)" : "url(" + name + ")";
        }
        return name;
    }

    private HTMLAttributeValueProposal setImageIcon(HTMLAttributeValueProposal proposal, String extend) {
        if (StringUtil.isNotBlank((String)(extend = extend.toLowerCase()))) {
            if (StringUtil.contains((String[])this._queryHelper.getCSSUriExtendValueList(), (String)extend)) {
                proposal.setImage(HTMLContentAssistProcessor.CSS_ICON);
            } else if (StringUtil.contains((String[])this._queryHelper.getJSUriExtendValueList(), (String)extend)) {
                proposal.setImage(HTMLContentAssistProcessor.JS_ICON);
            } else if (StringUtil.contains((String[])HTMLContentAssistProcessor.HTML_EXTENDTIONS, (String)extend)) {
                proposal.setImage(HTMLContentAssistProcessor.HTML_ICON);
            } else if (StringUtil.contains((String[])this._queryHelper.getImageExtendValueList(), (String)extend)) {
                proposal.setImage(HTMLContentAssistProcessor.IMG_ICON);
            } else if (StringUtil.contains((String[])HTMLContentAssistProcessor.ZIP_EXTENDTIONS, (String)extend)) {
                proposal.setImage(HTMLContentAssistProcessor.ZIP_ICON);
            } else if (StringUtil.contains((String[])HTMLContentAssistProcessor.XML_EXTENDTIONS, (String)extend)) {
                proposal.setImage(HTMLContentAssistProcessor.XML_ICON);
            } else if (StringUtil.contains((String[])HTMLContentAssistProcessor.XSL_EXTENDTIONS, (String)extend)) {
                proposal.setImage(HTMLContentAssistProcessor.XSL_ICON);
            } else if (StringUtil.contains((String[])HTMLContentAssistProcessor.JSON_EXTENDTIONS, (String)extend)) {
                proposal.setImage(HTMLContentAssistProcessor.JSON_ICON);
            } else {
                proposal.setImage(HTMLContentAssistProcessor.TEXT_ICON);
            }
        } else {
            proposal.setImage(HTMLContentAssistProcessor.TEXT_ICON);
        }
        return proposal;
    }

    @Override
    protected URI getURI(AbstractThemeableEditor editor) {
        URI uri;
        if (editor instanceof JSSourceEditor && (uri = this.getReferenceHtmlURI(editor)) != null) {
            return uri;
        }
        return super.getURI(editor);
    }

    protected URI getReferenceHtmlURI(AbstractThemeableEditor editor) {
        try {
            Map<String, Set<String>> refs = this._queryHelper.getJSReferences(EditorUtil.getIndex((AbstractThemeableEditor)editor));
            if (!CollectionsUtil.isEmpty(refs) && editor.getEditorInput() instanceof IFileEditorInput) {
                IFileEditorInput fileInput = (IFileEditorInput)editor.getEditorInput();
                Set<String> htmlFiles = refs.get(fileInput.getFile().getLocationURI().toString());
                if (htmlFiles != null && htmlFiles.size() == 1) {
                    String htmlLocation = htmlFiles.iterator().next();
                    return fileInput.getFile().getProject().getLocation().append(htmlLocation).toFile().toURI();
                }
                return fileInput.getFile().getProject().getLocation().append(".project").toFile().toURI();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public void setNeedAddURL(boolean needAddURL) {
        this.needAddURL = needAddURL;
    }

    public boolean isNeedAddURL() {
        return this.needAddURL;
    }
}

