/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.ext;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.text.hyperlink.IURLHyperlinkResolver;
import com.aptana.editor.common.util.EditorUtil;
import com.aptana.editor.html.contentassist.HTMLIndexQueryHelper;
import com.aptana.editor.js.JSSourceEditor;
import java.net.URI;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;

public class JSURLHyperlinkResolver
implements IURLHyperlinkResolver {
    private HTMLIndexQueryHelper _queryHelper = new HTMLIndexQueryHelper();

    public URI resolveURI(AbstractThemeableEditor editor, int offset, String value) {
        IEditorInput input;
        if (editor instanceof JSSourceEditor && (input = editor.getEditorInput()) instanceof IFileEditorInput) {
            Set<String> htmls;
            IFileEditorInput fileInput = (IFileEditorInput)input;
            IFile ifile = fileInput.getFile();
            String key = ifile.getLocationURI().toString();
            Map<String, Set<String>> jsReferences = this._queryHelper.getJSReferences(EditorUtil.getIndex((AbstractThemeableEditor)editor));
            if (!CollectionsUtil.isEmpty(jsReferences) && !CollectionsUtil.isEmpty(htmls = jsReferences.get(key))) {
                if (htmls.size() == 1) {
                    String htmlLocation = htmls.iterator().next();
                    IPath htmlFilePath = ifile.getProject().getLocation().append(htmlLocation);
                    return htmlFilePath.toFile().toURI().resolve(value);
                }
                if (htmls.size() > 1) {
                    Iterator<String> htmlLocations = htmls.iterator();
                    String temp = null;
                    boolean inSameDir = true;
                    while (htmlLocations.hasNext()) {
                        String htmlLocation = htmlLocations.next();
                        IPath htmlFilePath = ifile.getProject().getLocation().append(htmlLocation);
                        if (temp == null) {
                            temp = htmlFilePath.toFile().getParent();
                            continue;
                        }
                        if (temp.equals(htmlFilePath.toFile().getParent())) continue;
                        inSameDir = false;
                        break;
                    }
                    if (inSameDir) {
                        IPath htmlFilePath = ifile.getProject().getLocation().append(htmls.iterator().next());
                        return htmlFilePath.toFile().toURI().resolve(value);
                    }
                }
            }
        }
        return null;
    }
}

