/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.ext;

import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.contentassist.CompletionProposalType;
import com.aptana.editor.css.CSSSourceEditor;
import com.aptana.editor.html.HTMLEditor;
import com.aptana.editor.html.contentassist.HTMLIndexQueryHelper;
import com.aptana.editor.html.ext.CommonSpecialListHandler;
import com.aptana.editor.js.JSSourceEditor;
import com.aptana.index.core.Index;
import com.aptana.parsing.lexer.IRange;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

public class IDSpecialListHandler
extends CommonSpecialListHandler {
    IFile iFile;
    Index index;
    HTMLIndexQueryHelper queryHelper;

    public void doComputeSpecialProposals(AbstractThemeableEditor editor, int offset, IRange repalceRange, Set<ICompletionProposal> result, boolean isHTML) {
        IFile file = this.getFileByEditor(editor);
        if (file == null) {
            return;
        }
        this.iFile = file;
        this.index = this.getIndex(editor);
        HashMap<String, String> resultIds = new HashMap<String, String>();
        HashMap<String, String> unReferenceIds = new HashMap<String, String>();
        this.queryHelper = new HTMLIndexQueryHelper();
        Map<String, Set<String>> idMaps = this.queryHelper.getIDList(this.index);
        if (idMaps == null || idMaps.isEmpty()) {
            return;
        }
        if (editor instanceof HTMLEditor) {
            offset = this.getRealOffset(editor, offset);
            IDocument document = editor.getDocument();
            String contentType = "";
            try {
                contentType = document.getContentType(offset);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            if (contentType.startsWith("__html_")) {
                this.addHTMLResultIds(resultIds, file, offset, idMaps);
            } else {
                String location = file.getProjectRelativePath().toString();
                this.addResultIds(resultIds, idMaps, location);
            }
        } else {
            String location = file.getLocationURI().toString();
            Map<String, Set<String>> references = null;
            if (editor instanceof JSSourceEditor) {
                references = this.queryHelper.getJSReferences(this.index);
            } else if (editor instanceof CSSSourceEditor) {
                references = this.queryHelper.getCSSReferences(this.index);
            }
            if (references != null && references.containsKey(location)) {
                Set<String> htmlFile = references.get(location);
                for (String string : htmlFile) {
                    this.addResultIds(resultIds, idMaps, string);
                }
            } else {
                for (Map.Entry<String, Set<String>> entry : idMaps.entrySet()) {
                    HashSet<String> htmlValues;
                    Set<String> values = entry.getValue();
                    boolean findHTMLFile = this.computeHTMLIds(values, htmlValues = new HashSet<String>());
                    if (!findHTMLFile) continue;
                    resultIds.put(entry.getKey(), StringUtil.join((String)" <br /> ", htmlValues));
                }
            }
        }
        this.addProposals(repalceRange, result, resultIds, CompletionProposalType.ID, 90, isHTML);
        for (String idKey : idMaps.keySet()) {
            if (resultIds.containsKey(idKey)) continue;
            HashSet<String> htmlValues = new HashSet<String>();
            boolean bl = this.computeHTMLIds(idMaps.get(idKey), htmlValues);
            if (!bl) continue;
            unReferenceIds.put(idKey, StringUtil.join((String)" <br /> ", htmlValues));
        }
        this.addProposals(repalceRange, result, unReferenceIds, CompletionProposalType.ID, 10, isHTML);
    }

    private void addHTMLResultIds(Map<String, String> resultIds, IFile iFile, int offset, Map<String, Set<String>> idMaps) {
        List<String> list = this.getCSSFileRefrences();
        if (idMaps != null) {
            for (Map.Entry<String, Set<String>> entry : idMaps.entrySet()) {
                boolean hasCheck = this.checkLocation(list, entry.getValue());
                if (!hasCheck) continue;
                HashSet<String> htmlValues = new HashSet<String>();
                boolean findHTMLFile = this.computeHTMLIds(entry.getValue(), htmlValues);
                if (!findHTMLFile) continue;
                resultIds.put(entry.getKey(), StringUtil.join((String)" <br /> ", htmlValues));
            }
        }
    }

    private boolean checkLocation(List<String> list, Set<String> flocations) {
        boolean hasCheck = false;
        if (this.iFile == null) {
            return hasCheck;
        }
        for (String flocation : flocations) {
            if (!this.checkLocation(flocation, list, this.iFile)) continue;
            hasCheck = true;
        }
        return hasCheck;
    }

    private List<String> getCSSFileRefrences() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.iFile == null) {
            return list;
        }
        Map<String, Set<String>> map = this.queryHelper.getCSSReferences(this.index);
        if (map == null || map.isEmpty()) {
            return list;
        }
        Set<Map.Entry<String, Set<String>>> resourceEntrySet = map.entrySet();
        String fPath = this.iFile.getProjectRelativePath().toString();
        for (Map.Entry<String, Set<String>> entry : resourceEntrySet) {
            String path;
            Set<String> set = entry.getValue();
            if (!set.contains(fPath) || !(path = entry.getKey()).startsWith(this.iFile.getProject().getLocationURI().toString())) continue;
            path = path.substring(this.iFile.getProject().getLocationURI().toString().length() + 1);
            list.add(path);
        }
        return list;
    }

    private boolean checkLocation(String flocation, List<String> list, IFile file) {
        if (StringUtil.isBlank((String)flocation)) {
            return false;
        }
        String fPath = file.getProjectRelativePath().toString();
        return flocation.equals(fPath) || list.contains(flocation);
    }

    protected boolean computeHTMLIds(Set<String> values, Set<String> htmlValues) {
        boolean findHTMLFile = false;
        for (String value : values) {
            if (value.endsWith(".css")) continue;
            findHTMLFile = true;
            htmlValues.add(value);
        }
        return findHTMLFile;
    }

    protected void addResultIds(Map<String, String> resultIds, Map<String, Set<String>> idMaps, String location) {
        for (Map.Entry<String, Set<String>> entry : idMaps.entrySet()) {
            if (!entry.getValue().contains(location)) continue;
            resultIds.put(entry.getKey(), location);
        }
    }
}

