/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.ext;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonContentAssistProcessor;
import com.aptana.editor.common.contentassist.CompletionProposalType;
import com.aptana.editor.css.contentassist.CSSIndexQueryHelper;
import com.aptana.editor.css.contentassist.model.PropertyElement;
import com.aptana.editor.css.contentassist.model.ValueElement;
import com.aptana.editor.html.ext.CommonSpecialListHandler;
import com.aptana.editor.js.contentassist.ParseUtil;
import com.aptana.editor.js.htmlext.IJSActivationCharAware;
import com.aptana.editor.js.htmlext.IJSCurrentNodeAware;
import com.aptana.editor.js.parsing.ast.JSGetPropertyNode;
import com.aptana.editor.js.parsing.ast.JSNode;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.lexer.IRange;
import com.pandora.core.utils.RegularUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

public class HTMLStyleObjectSpecialListHandler
extends CommonSpecialListHandler
implements IJSCurrentNodeAware,
IJSActivationCharAware {
    private JSNode currentNode = null;
    private char activationChar;
    private boolean autoActivated;
    private CompletionProposalType completionProposalType = CompletionProposalType.DEFALUT;

    public CompletionProposalType getCompletionProposalType() {
        return this.completionProposalType;
    }

    public void setCompletionProposalType(CompletionProposalType completionProposalType) {
        this.completionProposalType = completionProposalType;
    }

    public void doComputeSpecialProposals(AbstractThemeableEditor editor, int offset, IRange repalceRange, Set<ICompletionProposal> result, boolean isHTML) {
        if (this.currentNode != null) {
            JSGetPropertyNode getNode = ParseUtil.getGetPropertyNode((IParseNode)this.currentNode, (IParseNode)this.currentNode.getContainingStatementNode());
            if (getNode == null) {
                getNode = ParseUtil.getGetPropertyNodeByVisitAst((IParseNode)this.currentNode, (IParseNode)this.currentNode.getContainingStatementNode());
            }
            IParseNode parseNode = getNode.getRightHandSide();
            String jsCssProp = parseNode.getText();
            if (this.autoActivated && !this.checkNeedReContentAssist(jsCssProp, this.activationChar)) {
                return;
            }
            CSSIndexQueryHelper queryHelper = new CSSIndexQueryHelper();
            String cssProp = RegularUtils.matchHumpName((String)jsCssProp);
            PropertyElement prop = queryHelper.getProperty(cssProp);
            if (prop == null) {
                prop = queryHelper.getProperty("-" + cssProp);
            }
            if (prop != null) {
                List subPropertys;
                if (CommonContentAssistProcessor.checkTypesContainsNumber((List)prop.getTypes())) {
                    this.setCompletionProposalType(CompletionProposalType.NUMBER);
                } else {
                    this.setCompletionProposalType(CompletionProposalType.DEFALUT);
                }
                this.addAllProposals(repalceRange, result, prop, isHTML);
                if (!CollectionsUtil.isEmpty((Collection)prop.getSubs()) && !CollectionsUtil.isEmpty((Collection)(subPropertys = queryHelper.getSubProperties(prop)))) {
                    for (PropertyElement subProperty : subPropertys) {
                        if (subProperty == null) continue;
                        this.addAllProposals(repalceRange, result, subProperty, isHTML);
                    }
                }
            }
        }
    }

    private void addAllProposals(IRange repalceRange, Set<ICompletionProposal> result, PropertyElement subProperty, boolean isHTML) {
        List subsValues = subProperty.getValues();
        HashMap<String, String> subsValueResults = new HashMap<String, String>();
        if (subsValues != null && !subsValues.isEmpty()) {
            for (ValueElement val : subsValues) {
                if (StringUtil.isEmpty((String)val.getName())) continue;
                subsValueResults.put(val.getName().replace("\"", ""), val.getDescription());
            }
        }
        this.addProposals(repalceRange, result, subsValueResults, this.getCompletionProposalType(), 90, isHTML);
    }

    public void setCurrentNode(JSNode jsnode) {
        this.currentNode = jsnode;
    }

    public void setActivationChar(char activationChar) {
        this.activationChar = activationChar;
    }

    public void setAutoActivated(boolean autoActivated) {
        this.autoActivated = autoActivated;
    }
}

