/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.ext;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.html.HTMLPlugin;
import com.aptana.editor.html.ext.ScriptRange;
import com.aptana.editor.js.htmlext.IScriptRange;
import com.aptana.parsing.lexer.IRange;
import com.aptana.parsing.lexer.Range;
import com.pandora.core.utils.RegularUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;

public class HTMLScriptRange
implements IScriptRange {
    private String startTag = "<script";
    private String endTag = "</script>";
    private static final String SCRIPT_TAG = "__html_script";
    private static final String SCRIPT_TAG_CLOSE = "__html_tag_close";
    private static final String TAG = "__html_nest_tag";
    private static final String JS_TYPE = "text/javascript";
    private static final String TAG_DELIM = "<";
    protected List<IRange> scriptsRange = null;
    private boolean hasFinishCompute = false;

    public IRange getActiveRange(IDocument doc, int offset) {
        List<IRange> scriptsRange = this.computeAllScriptsRange(doc, offset);
        for (IRange range : scriptsRange) {
            if (range.getStartingOffset() > offset || range.getEndingOffset() < offset) continue;
            return range;
        }
        return null;
    }

    public List<IRange> computeAllScriptsRange(IDocument doc, int offset) {
        Stack<IRange> scripts = new Stack<IRange>();
        if (this.scriptsRange != null && this.hasFinishCompute) {
            return this.scriptsRange;
        }
        this.scriptsRange = new ArrayList<IRange>();
        int lineNum = doc.getNumberOfLines();
        String lineStr = null;
        try {
            int i = 0;
            while (i < lineNum) {
                IRegion region = doc.getLineInformation(i);
                lineStr = doc.get(region.getOffset(), region.getLength());
                if (!(StringUtil.isEmpty((String)lineStr) || lineStr.toLowerCase().indexOf(this.startTag) < 0 && lineStr.toLowerCase().indexOf(this.endTag) < 0)) {
                    StringTokenizer tokenizer = new StringTokenizer(lineStr);
                    int tokenOffset = 0;
                    while (tokenizer.hasMoreTokens()) {
                        String token = TAG_DELIM + tokenizer.nextToken(TAG_DELIM);
                        int tokenLength = token.length();
                        Region tokenRegion = new Region(tokenOffset + region.getOffset(), tokenLength);
                        this.handleStartTag(doc, scripts, token, (IRegion)tokenRegion);
                        this.handleEndTag(doc, scripts, token, (IRegion)tokenRegion);
                        tokenOffset += tokenLength;
                    }
                }
                ++i;
            }
            this.hasFinishCompute = true;
        }
        catch (BadLocationException e) {
            IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (Throwable)e);
        }
        return this.scriptsRange;
    }

    private int handleEndTag(IDocument doc, Stack<IRange> scripts, String lineStr, IRegion region) throws BadLocationException {
        int tagIndexOfLine;
        block5: {
            int tagOffset;
            ITypedRegion partition;
            tagIndexOfLine = lineStr.toLowerCase().indexOf(this.endTag);
            if (tagIndexOfLine >= 0 && (SCRIPT_TAG_CLOSE.equals((partition = doc.getPartition(tagOffset = region.getOffset() + tagIndexOfLine)).getType()) || TAG.equals(partition.getType()))) {
                if (scripts.isEmpty()) {
                    return -1;
                }
                IRange r = scripts.pop();
                ScriptRange scriptRange = new ScriptRange(r.getEndingOffset(), partition.getOffset() - 1);
                scriptRange.setWholeTag(doc.get(r.getStartingOffset(), r.getLength() - 1));
                try {
                    Document scriptDoc = DocumentHelper.parseText((String)(String.valueOf(scriptRange.getWholeTag()) + this.endTag));
                    Element root = scriptDoc.getRootElement();
                    String scriptType = root.attributeValue("type");
                    if (StringUtil.isEmpty((String)scriptType) || JS_TYPE.equalsIgnoreCase(scriptType)) {
                        this.scriptsRange.add((IRange)scriptRange);
                    }
                }
                catch (DocumentException documentException) {
                    String scriptType = RegularUtils.match((String)"type[\\s]*=[\\s]*[\"']([\\s/_a-zA-Z0-9]*)[\"']", (String)scriptRange.getWholeTag(), (int)1);
                    if (!StringUtil.isEmpty((String)scriptType) && !JS_TYPE.equalsIgnoreCase(scriptType)) break block5;
                    this.scriptsRange.add((IRange)scriptRange);
                }
            }
        }
        return tagIndexOfLine;
    }

    private int handleStartTag(IDocument doc, Stack<IRange> scripts, String lineStr, IRegion region) throws BadLocationException {
        int tagIndexOfLine = lineStr.toLowerCase().indexOf(this.startTag);
        if (tagIndexOfLine >= 0) {
            int tagOffset = region.getOffset() + tagIndexOfLine;
            ITypedRegion partition = doc.getPartition(tagOffset);
            String wholeTag = doc.get(partition.getOffset(), partition.getLength());
            if ((SCRIPT_TAG.equals(partition.getType()) || TAG.equals(partition.getType())) && !wholeTag.endsWith("/>")) {
                scripts.push((IRange)new Range(partition.getOffset(), partition.getOffset() + partition.getLength()));
            }
        }
        return tagIndexOfLine;
    }
}

