/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.ext;

import com.aptana.build.util.AssistHelper;
import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.html.HTMLPlugin;
import com.aptana.editor.html.contentassist.HTMLIndexQueryHelper;
import com.aptana.editor.html.ext.HTMLScript;
import com.aptana.editor.html.ext.HTMLScriptFilePathListProposal;
import com.aptana.editor.html.ext.HTMLScriptFunctionElementProposal;
import com.aptana.editor.html.ext.HTMLScriptIDProposal;
import com.aptana.editor.html.ext.HTMLScriptPropertyElementProposal;
import com.aptana.editor.js.contentassist.JSContentAssistProcessor;
import com.aptana.editor.js.contentassist.JSLocationIdentifier;
import com.aptana.editor.js.contentassist.LocationType;
import com.aptana.editor.js.contentassist.PropertyElementProposal;
import com.aptana.editor.js.contentassist.model.FunctionElement;
import com.aptana.editor.js.contentassist.model.PropertyElement;
import com.aptana.editor.js.contentassist.rule.JSContentAssistRules;
import com.aptana.editor.js.htmlext.IURIProposalRule;
import com.aptana.editor.js.parsing.JSParseState;
import com.aptana.editor.js.parsing.ast.JSErrorNode;
import com.aptana.editor.js.parsing.ast.JSStringNode;
import com.aptana.parsing.IParseState;
import com.aptana.parsing.ParserPoolFactory;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.parsing.lexer.IRange;
import com.aptana.parsing.lexer.Range;
import com.pandora.core.utils.ProjectUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IFileEditorInput;

public class HTMLScriptContentAssistProcessor
extends JSContentAssistProcessor {
    private HTMLScript htmlScript = null;
    private HTMLIndexQueryHelper _queryHelper = new HTMLIndexQueryHelper();
    private int _offset;
    static final Image ATTRIBUTE_ICON = HTMLPlugin.getImage("/icons/attribute.png");

    public HTMLScriptContentAssistProcessor(AbstractThemeableEditor editor) {
        super(editor);
    }

    protected ICompletionProposal[] doComputeCompletionProposals(ITextViewer viewer, int offset, char activationChar, boolean autoActivated) {
        try {
            AssistHelper.checkState();
            this._offset = offset;
            ICompletionProposal[] proposals = null;
            IDocument doc = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
            if (this.editor.getEditorInput() instanceof IFileEditorInput) {
                IFileEditorInput fileEditorInput = (IFileEditorInput)this.editor.getEditorInput();
                this.htmlScript = new HTMLScript(doc, offset, fileEditorInput.getFile());
                proposals = super.doComputeCompletionProposals(viewer, this.htmlScript.getOffset(), activationChar, autoActivated);
            } else {
                proposals = super.doComputeCompletionProposals(viewer, offset, activationChar, autoActivated);
            }
            return proposals;
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (Throwable)e);
            return null;
        }
    }

    public int getOffset() {
        return this._offset;
    }

    protected void addUriListProposals(Set<ICompletionProposal> result, int offset, IParseNode targetNode) {
        if (!(targetNode instanceof JSStringNode)) {
            return;
        }
        JSStringNode strNode = (JSStringNode)targetNode;
        IURIProposalRule[] iURIProposalRuleArray = JSContentAssistRules.uriRules;
        int n = JSContentAssistRules.uriRules.length;
        int n2 = 0;
        while (n2 < n) {
            IURIProposalRule uriRule = iURIProposalRuleArray[n2];
            if (uriRule.match(this.getIndex(), this.getURI(), strNode, offset)) {
                IPath path = ProjectUtils.getSourceRoot((IProject)this.getProject());
                List filePathList = ProjectUtils.getFilePathList((IPath)path, (IPath)path);
                for (String filePath : filePathList) {
                    String prefix;
                    if (!filePath.startsWith(prefix = strNode.getText().replace("\"", "")) || filePath.equals(prefix)) continue;
                    HTMLScriptFilePathListProposal props = new HTMLScriptFilePathListProposal(filePath, this.htmlScript.findActualFileRange(offset).getStartingOffset() - prefix.length(), prefix.length(), this.htmlScript);
                    result.add((ICompletionProposal)props);
                }
                break;
            }
            ++n2;
        }
    }

    protected List<ICompletionProposal> addIDProposals(IRange replaceRange, int offset) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        Map<String, String> ids = this._queryHelper.getIDs(this.getIndex());
        if (ids != null) {
            for (Map.Entry<String, String> entry : ids.entrySet()) {
                HTMLScriptIDProposal proposal = new HTMLScriptIDProposal(entry.getKey(), replaceRange, offset, null);
                proposals.add((ICompletionProposal)proposal);
            }
        }
        return proposals;
    }

    protected IParseNode getActiveASTNode(int offset) {
        IParseNode result = null;
        try {
            int startingOffset = 0;
            String source = this.htmlScript == null ? "" : this.htmlScript.getSource();
            JSParseState parseState = new JSParseState(source, startingOffset, true, true);
            IParseRootNode ast = ParserPoolFactory.parse((String)"com.aptana.contenttype.js", (IParseState)parseState).getRootNode();
            if (ast != null && (result = ast.getNodeAtOffset(offset)) == null) {
                if (offset < ast.getStartingOffset()) {
                    result = ast.getNodeAtOffset(ast.getStartingOffset());
                } else if (ast.getEndingOffset() < offset) {
                    result = ast.getNodeAtOffset(ast.getEndingOffset());
                }
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (Throwable)e);
        }
        return result;
    }

    protected LocationType getLocationType(IDocument document, int offset) {
        try {
            JSLocationIdentifier identifier = new JSLocationIdentifier(offset, this.getActiveASTNode(offset - 1));
            LocationType result = identifier.getType();
            this.targetNode = identifier.getTargetNode();
            this.statementNode = identifier.getStatementNode();
            this.replaceRange = identifier.getReplaceRange();
            if (this.replaceRange != null && this.htmlScript != null) {
                this.replaceRange = this.htmlScript.computeReplaceRange(this.replaceRange);
            }
            if (result == LocationType.UNKNOWN || this.targetNode instanceof JSErrorNode) {
                result = this.getLocationByLexeme((IDocument)new Document(this.htmlScript == null ? "" : this.htmlScript.getSource()), offset, result);
            }
            return result;
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (Throwable)e);
            return LocationType.UNKNOWN;
        }
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        try {
            IContextInformation[] contextInformations = null;
            IDocument doc = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
            if (this.editor.getEditorInput() instanceof IFileEditorInput) {
                IFileEditorInput fileEditorInput = (IFileEditorInput)this.editor.getEditorInput();
                this.htmlScript = new HTMLScript(doc, offset, fileEditorInput.getFile());
                contextInformations = super.computeContextInformation(viewer, this.htmlScript.getOffset());
            } else {
                contextInformations = super.computeContextInformation(viewer, offset);
            }
            return contextInformations;
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (Throwable)e);
            return null;
        }
    }

    protected PropertyElementProposal createPropertyElementProposal(PropertyElement property, int offset, int replaceLength, URI projectURI, Image image) {
        HTMLScriptPropertyElementProposal proposal = null;
        proposal = property instanceof FunctionElement ? new HTMLScriptFunctionElementProposal(this.editor, property, offset, replaceLength, projectURI, this.htmlScript == null ? null : this.htmlScript.getScriptsInHTML(), this.htmlScript == null ? null : this.htmlScript.getActiveScriptRange()) : new HTMLScriptPropertyElementProposal(this.editor, property, offset, replaceLength, projectURI, this.htmlScript == null ? null : this.htmlScript.getScriptsInHTML(), this.htmlScript == null ? null : this.htmlScript.getActiveScriptRange());
        return proposal;
    }

    public int getContextNodeOffset(int offset) {
        int actualOffset = this.htmlScript.findActualFileRange(offset).getStartingOffset();
        return actualOffset;
    }

    protected int computeRealOffset(IRange range, int offset) {
        int actualOffset = this.htmlScript.findActualFileRange(offset).getStartingOffset();
        return actualOffset - range.getStartingOffset();
    }

    protected IRange computeRealRange(IParseNode node) {
        int startOffset = this.htmlScript.findActualFileRange(node.getStartingOffset()).getStartingOffset();
        int endOffset = this.htmlScript.findActualFileRange(node.getEndingOffset()).getStartingOffset();
        return new Range(startOffset + 1, endOffset - 1);
    }

    public void dispose() {
        super.dispose();
        this.htmlScript = null;
        this._queryHelper = null;
        this.editor = null;
    }
}

