/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.ext;

import com.aptana.editor.html.ext.EventRange;
import com.aptana.editor.html.ext.HTMLScript;
import com.aptana.editor.html.ext.HTMLScriptFullRange;
import com.aptana.editor.js.htmlext.IScriptRange;
import com.aptana.parsing.lexer.IRange;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class HTMLFullScript
extends HTMLScript {
    public HTMLFullScript(IDocument doc, int offset, IFile currentFile, boolean isParseRefJS) {
        super(doc, offset, currentFile, isParseRefJS);
    }

    @Override
    protected IScriptRange getHTMLScriptActiveRange() {
        return new HTMLScriptFullRange();
    }

    @Override
    protected int handleOtherScriptRange(IDocument doc, int offset, int inScriptOffset, StringBuffer sb, IRange[] scritpsArr) {
        IRange[] iRangeArray = scritpsArr;
        int n = scritpsArr.length;
        int n2 = 0;
        while (n2 < n) {
            IRange range = iRangeArray[n2];
            if (range.getClass() == EventRange.class) {
                EventRange eventRange = (EventRange)range;
                eventRange.setAllSourceStartOffset(sb.length());
                inScriptOffset = this.handleEventScript(doc, offset, inScriptOffset, sb, eventRange);
                eventRange.setAllSourceEndOffset(sb.length());
            }
            ++n2;
        }
        return inScriptOffset;
    }

    protected int handleEventScript(IDocument doc, int offset, int inScriptOffset, StringBuffer sb, EventRange eventRange) {
        if (eventRange.contain(offset)) {
            inScriptOffset += offset - eventRange.getStartingOffset();
            this.activeScriptRange = eventRange;
        } else if (eventRange.getEndingOffset() < offset) {
            inScriptOffset += eventRange.getLength();
        }
        try {
            int start = eventRange.getStartingOffset();
            int end = eventRange.getEndingOffset();
            String source = doc.get(start, end - start);
            sb.append(source);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return inScriptOffset;
    }
}

