/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.ext;

import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.contentassist.CommonCompletionProposal;
import com.aptana.editor.common.contentassist.CompletionProposalType;
import com.aptana.editor.common.contentassist.UserAgentManager;
import com.aptana.editor.common.util.EditorUtil;
import com.aptana.editor.css.CSSColors;
import com.aptana.editor.css.CSSPlugin;
import com.aptana.editor.css.contentassist.CSSIndexQueryHelper;
import com.aptana.editor.html.contentassist.HTMLIndexQueryHelper;
import com.aptana.editor.html.ext.CommonSpecialListHandler;
import com.aptana.parsing.lexer.IRange;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ColorSpecialListHandler
extends CommonSpecialListHandler {
    IRange _replaceRange;
    AbstractThemeableEditor editor;

    public void doComputeSpecialProposals(AbstractThemeableEditor editor, int offset, IRange repalceRange, Set<ICompletionProposal> result, boolean isHTML) {
        CommonCompletionProposal proposal;
        Image img;
        ImageRegistry reg;
        this._replaceRange = repalceRange;
        this.editor = editor;
        HTMLIndexQueryHelper queryHelper = new HTMLIndexQueryHelper();
        String[] colorValues = this.getHTMLColorValues(queryHelper);
        String[] stringArray = colorValues;
        int n = colorValues.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            reg = CSSPlugin.getDefault().getImageRegistry();
            img = reg.get(value);
            if (img == null || img.isDisposed()) {
                String rgbValue = CSSColors.getRGBByName((String)value);
                if (StringUtil.isNotBlank((String)rgbValue)) {
                    String[] rgbs = rgbValue.split(",");
                    if (rgbs.length == 3) {
                        int r = Integer.parseInt(rgbs[0]);
                        int g = Integer.parseInt(rgbs[1]);
                        int b = Integer.parseInt(rgbs[2]);
                        RGB rgb = new RGB(r, g, b);
                        PaletteData pd = new PaletteData(new RGB[]{rgb});
                        ImageData data = new ImageData(16, 16, 1, pd);
                        img = new Image((Device)Display.getCurrent(), data);
                        reg.put(value, img);
                    } else {
                        img = CommonSpecialListHandler.ATTRIBUTE_ICON;
                    }
                } else {
                    img = CommonSpecialListHandler.ATTRIBUTE_ICON;
                }
            }
            if ((proposal = this.addProposal(CompletionProposalType.COLOR, value, value, img, null, null, "", null, offset, false, isHTML)) != null) {
                result.add((ICompletionProposal)proposal);
            }
            ++n2;
        }
        CSSIndexQueryHelper CSSIndexQueryHelper2 = new CSSIndexQueryHelper();
        Set<String> colors = this.getCSSColorValues(editor, CSSIndexQueryHelper2);
        if (colors != null && !colors.isEmpty()) {
            for (String color : colors) {
                reg = CSSPlugin.getDefault().getImageRegistry();
                img = reg.get(color);
                if (img == null) {
                    String s = color.substring(1, 3);
                    int r = Integer.parseInt(s, 16);
                    s = color.substring(3, 5);
                    int g = Integer.parseInt(s, 16);
                    s = color.substring(5, 7);
                    int b = Integer.parseInt(s, 16);
                    RGB rgb = new RGB(r, g, b);
                    PaletteData pd = new PaletteData(new RGB[]{rgb});
                    ImageData data = new ImageData(16, 16, 1, pd);
                    img = new Image((Device)Display.getCurrent(), data);
                    reg.put(color, img);
                }
                if ((proposal = this.addProposal(CompletionProposalType.COLOR, color, color, img, null, null, "", null, offset, false, isHTML)) == null) continue;
                result.add((ICompletionProposal)proposal);
            }
        }
    }

    protected Set<String> getCSSColorValues(AbstractThemeableEditor editor, CSSIndexQueryHelper CSSIndexQueryHelper2) {
        return CSSIndexQueryHelper2.getColors(EditorUtil.getIndex((AbstractThemeableEditor)editor));
    }

    protected String[] getHTMLColorValues(HTMLIndexQueryHelper queryHelper) {
        return queryHelper.getColorAttributeValueList();
    }

    protected CommonCompletionProposal addProposal(CompletionProposalType type, String displayName, String name, Image image, String description, Map<String, String> userAgentIds, String fileLocation, Point selectPoint, int offset, boolean isApplyNeedReContentAssist, boolean isHTML) {
        if (userAgentIds == null || this.isActiveByUserAgent(userAgentIds.keySet().toArray(new String[userAgentIds.size()]), this.editor)) {
            CommonCompletionProposal proposal = this.createProposal(type, displayName, name, image, description, userAgentIds, fileLocation, selectPoint, offset, isApplyNeedReContentAssist, isHTML);
            return proposal;
        }
        return null;
    }

    protected CommonCompletionProposal createProposal(CompletionProposalType type, String displayName, String name, Image image, String description, Map<String, String> userAgentIds, String fileLocation, Point selectPoint, int offset, boolean isApplyNeedReContentAssist, boolean isHTML) {
        int length = name.length();
        IContextInformation contextInfo = null;
        int replaceLength = 0;
        if (this._replaceRange != null) {
            offset = this._replaceRange.getStartingOffset();
            replaceLength = this._replaceRange.getLength();
        }
        Map userAgents = UserAgentManager.getInstance().getUserAgentPath(this.getProject(this.editor), userAgentIds);
        CommonCompletionProposal proposal = new CommonCompletionProposal(name, offset, replaceLength, length, image, displayName, contextInfo, description);
        proposal.setCompletionProposalType(type);
        proposal.setApplyNeedReContentAssist(isApplyNeedReContentAssist);
        proposal.setFileLocation(fileLocation);
        proposal.setUserAgentImages(userAgents);
        proposal.setSelection(selectPoint);
        proposal.setIsHTML(isHTML);
        return proposal;
    }
}

