/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.ext;

import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.contentassist.CompletionProposalType;
import com.aptana.editor.common.util.EditorUtil;
import com.aptana.editor.css.CSSSourceEditor;
import com.aptana.editor.html.HTMLEditor;
import com.aptana.editor.html.contentassist.HTMLIndexQueryHelper;
import com.aptana.editor.html.ext.CommonSpecialListHandler;
import com.aptana.editor.js.JSSourceEditor;
import com.aptana.index.core.Index;
import com.aptana.parsing.lexer.IRange;
import com.aptana.parsing.lexer.Range;
import com.aptana.ui.util.DisplayUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

public class ClassSpecialListHandler
extends CommonSpecialListHandler {
    private IRange _replaceRange = null;

    public void doComputeSpecialProposals(final AbstractThemeableEditor editor, int offset, IRange replaceRange, Set<ICompletionProposal> result, boolean isHTML) {
        IFile file = this.getFileByEditor(editor);
        if (file == null) {
            return;
        }
        boolean isJSPart = (Boolean)DisplayUtils.syncExec(Boolean.class, (DisplayUtils.Valueable)new DisplayUtils.Valueable<Boolean>(){

            public Boolean getValue() {
                return EditorUtil.isJSPartition((AbstractThemeableEditor)editor, (int)-1);
            }
        });
        if (isJSPart) {
            try {
                String[] tokens;
                int startOffset = replaceRange.getStartingOffset();
                String content = editor.getDocument().get(replaceRange.getStartingOffset(), replaceRange.getLength());
                String[] stringArray = tokens = content.split(" ");
                int n = tokens.length;
                int n2 = 0;
                while (n2 < n) {
                    String nextToken = stringArray[n2];
                    int length = nextToken.length();
                    if (offset >= startOffset && offset <= startOffset + length) {
                        replaceRange = new Range(startOffset, startOffset + length - 1);
                        break;
                    }
                    replaceRange = new Range(startOffset + nextToken.length() + 1, startOffset + nextToken.length());
                    startOffset += nextToken.length() + 1;
                    ++n2;
                }
                this._replaceRange = replaceRange;
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
        HTMLIndexQueryHelper queryHelper = new HTMLIndexQueryHelper();
        Index index = EditorUtil.getIndex((AbstractThemeableEditor)editor);
        Map<String, Set<String>> classes = queryHelper.getClassList(index);
        Map<String, Set<String>> cssRefs = queryHelper.getCSSReferences(index);
        if (classes == null || classes.isEmpty()) {
            return;
        }
        HashMap<String, String> classResults = new HashMap<String, String>();
        String location = file.getLocationURI().toString();
        if (editor instanceof HTMLEditor) {
            this.addClassResults(file, classes, cssRefs, classResults);
        } else if (editor instanceof JSSourceEditor) {
            Map<String, Set<String>> jsRefs = queryHelper.getJSReferences(index);
            if (jsRefs != null && jsRefs.containsKey(location)) {
                Set<String> htmlFiles = jsRefs.get(location);
                for (String htmlFile : htmlFiles) {
                    IFile htmlIFile = file.getProject().getFile(htmlFile);
                    this.addClassResults(htmlIFile, classes, cssRefs, classResults);
                }
            }
        } else if (editor instanceof CSSSourceEditor) {
            this.addCSSResultClasses(classResults, file, classes);
        }
        this.addProposals(replaceRange, result, classResults, CompletionProposalType.CLASS, 90, isHTML);
        HashMap<String, String> unReferenceClasses = new HashMap<String, String>();
        for (String classKey : classes.keySet()) {
            if (classResults.containsKey(classKey)) continue;
            HashSet<String> cssValues = new HashSet<String>();
            boolean findCSSFile = this.computeHTMLClassesLocation(classes.get(classKey), cssValues);
            if (!findCSSFile) continue;
            unReferenceClasses.put(classKey, StringUtil.join((String)" <br /> ", cssValues));
        }
        this.addProposals(replaceRange, result, unReferenceClasses, CompletionProposalType.CLASS, 10, isHTML);
    }

    private void addCSSResultClasses(Map<String, String> classResults, IFile file, Map<String, Set<String>> classes) {
        String relativePath = file.getProjectRelativePath().toString();
        for (Map.Entry<String, Set<String>> entry : classes.entrySet()) {
            if (!entry.getValue().contains(relativePath)) continue;
            classResults.put(entry.getKey(), StringUtil.join((String)" <br /> ", (String[])new String[]{relativePath}));
        }
    }

    @Override
    public IRange getReplaceRange() {
        return this._replaceRange;
    }

    private Set<String> getCSSReferences(Map<String, Set<String>> cssRefs, String htmlFile, IProject project) {
        HashSet<String> result = new HashSet<String>();
        if (cssRefs == null) {
            return result;
        }
        String projectPath = project.getLocationURI().toString();
        for (Map.Entry<String, Set<String>> entry : cssRefs.entrySet()) {
            String location;
            if (!entry.getValue().contains(htmlFile) || (location = entry.getKey()) == null || !location.startsWith(projectPath)) continue;
            result.add(location.substring(projectPath.length() + 1));
        }
        return result;
    }

    protected void addClassResults(IFile file, Map<String, Set<String>> classes, Map<String, Set<String>> cssRefs, Map<String, String> classResults) {
        String relativePath = file.getProjectRelativePath().toString();
        Set<String> classFiles = this.getCSSReferences(cssRefs, relativePath, file.getProject());
        classFiles.add(relativePath);
        for (Map.Entry<String, Set<String>> entry : classes.entrySet()) {
            HashSet<String> set = new HashSet<String>();
            for (String classFile : classFiles) {
                if (!entry.getValue().contains(classFile)) continue;
                set.add(classFile);
            }
            HashSet<String> htmlValues = new HashSet<String>();
            boolean findHTMLFile = this.computeHTMLClassesLocation(set, htmlValues);
            if (!findHTMLFile) continue;
            classResults.put(entry.getKey(), StringUtil.join((String)" <br /> ", htmlValues));
        }
    }

    private boolean computeHTMLClassesLocation(Set<String> set, Set<String> htmlValues) {
        boolean findCSSFile = false;
        for (String value : set) {
            findCSSFile = true;
            htmlValues.add(value);
        }
        return findCSSFile;
    }
}

