/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.ext;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.extensions.ISpecialListHandler;
import com.aptana.editor.common.util.EditorUtil;
import com.aptana.editor.css.contentassist.CSSIndexQueryHelper;
import com.aptana.editor.css.contentassist.model.PropertyElement;
import com.aptana.editor.css.contentassist.model.ValueElement;
import com.aptana.editor.html.ext.CommonSpecialListHandler;
import com.aptana.editor.js.contentassist.ParseUtil;
import com.aptana.editor.js.contentassist.inferencing.JSAssistNodeTypeInferrer;
import com.aptana.editor.js.contentassist.model.FunctionElement;
import com.aptana.editor.js.contentassist.model.FunctionTypeElement;
import com.aptana.editor.js.contentassist.model.ParameterElement;
import com.aptana.editor.js.contentassist.model.TypeElement;
import com.aptana.editor.js.htmlext.IPropNameAware;
import com.aptana.editor.js.inferencing.JSScope;
import com.aptana.editor.js.parsing.ast.JSArgumentsNode;
import com.aptana.editor.js.parsing.ast.JSInvokeNode;
import com.aptana.editor.js.parsing.ast.JSNode;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.lexer.IRange;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.ui.IEditorPart;

public class CSSPropertyValueSpecialListHandler
extends CommonSpecialListHandler
implements ISpecialListHandler,
IPropNameAware {
    private static Map<String, String> allPropValues = new HashMap<String, String>();
    private String propName = null;
    private CSSIndexQueryHelper queryHelper = new CSSIndexQueryHelper();

    public void doComputeSpecialProposals(AbstractThemeableEditor editor, int offset, IRange repalceRange, Set<ICompletionProposal> result, boolean isHTML) {
        HashMap<String, String> resultMap = new HashMap();
        if (StringUtil.isEmpty((String)this.propName)) {
            List props;
            if (allPropValues.isEmpty() && !CollectionsUtil.isEmpty((Collection)(props = this.queryHelper.getProperties()))) {
                for (PropertyElement prop : props) {
                    List values = prop.getValues();
                    if (CollectionsUtil.isEmpty((Collection)values)) continue;
                    for (ValueElement value : values) {
                        allPropValues.put(value.getName(), value.getDescription());
                    }
                }
            }
            resultMap = allPropValues;
        } else {
            List values;
            PropertyElement prop = this.queryHelper.getProperty(this.propName);
            if (prop != null && !CollectionsUtil.isEmpty((Collection)(values = prop.getValues()))) {
                for (ValueElement value : values) {
                    resultMap.put(value.getName(), value.getDescription());
                }
            }
        }
        this.addProposals(repalceRange, result, resultMap, isHTML);
        this.setPropName(null);
    }

    public void setPropName(String propName) {
        this.propName = propName;
    }

    public String inferrerPropName(JSNode equalsNode, AbstractThemeableEditor editor) {
        JSArgumentsNode argsNode;
        if (equalsNode == null) {
            return "";
        }
        if (equalsNode instanceof JSInvokeNode) {
            JSInvokeNode ivkNode = (JSInvokeNode)equalsNode;
            JSArgumentsNode argsNode2 = (JSArgumentsNode)ivkNode.getArguments();
            return ParseUtil.inferrerArgValue((JSArgumentsNode)argsNode2, (int)0);
        }
        if (equalsNode.getParent() instanceof JSArgumentsNode && (argsNode = (JSArgumentsNode)equalsNode.getParent()).getParent() instanceof JSInvokeNode) {
            JSInvokeNode ivkNode = (JSInvokeNode)argsNode.getParent();
            JSScope scope = ParseUtil.getScopeAtOffset((IParseNode)ivkNode, (int)ivkNode.getStartingOffset());
            JSAssistNodeTypeInferrer inferrer = new JSAssistNodeTypeInferrer(scope, EditorUtil.getIndex((AbstractThemeableEditor)editor), EditorUtil.getURI((IEditorPart)editor));
            inferrer.visit((JSNode)ivkNode.getExpression());
            List types = inferrer.getTypes();
            for (TypeElement type : types) {
                FunctionTypeElement funcType;
                FunctionElement func;
                if (!(type instanceof FunctionTypeElement) || (func = (funcType = (FunctionTypeElement)type).toFunction()) == null) continue;
                int index = 0;
                for (ParameterElement param : func.getParameters()) {
                    if (param.getTypes().contains("cssPropertyString")) {
                        return ParseUtil.inferrerArgValue((JSArgumentsNode)argsNode, (int)index);
                    }
                    ++index;
                }
            }
        }
        return "";
    }

    public List<String> getPropNameTypes(String propName) {
        PropertyElement propEl;
        if (StringUtil.isNotEmpty((String)propName) && (propEl = this.queryHelper.getProperty(propName)) != null) {
            return propEl.getTypes();
        }
        return null;
    }
}

