/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.ext;

import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.util.EditorUtil;
import com.aptana.editor.html.HTMLEditor;
import com.aptana.editor.html.contentassist.HTMLIndexQueryHelper;
import com.aptana.editor.html.contentassist.model.ElementElement;
import com.aptana.editor.html.ext.inferrer.HTMLElementClassInferrer;
import com.aptana.editor.html.ext.inferrer.HTMLElementIDInferrer;
import com.aptana.editor.html.parsing.HTMLParseRootNode;
import com.aptana.editor.html.parsing.HTMLParseState;
import com.aptana.editor.js.JSSourceEditor;
import com.aptana.editor.js.contentassist.ParseUtil;
import com.aptana.editor.js.htmlext.DomProperties;
import com.aptana.editor.js.htmlext.IHTMLDomAssist;
import com.aptana.editor.js.parsing.ast.JSInvokeNode;
import com.aptana.editor.js.parsing.ast.JSNode;
import com.aptana.parsing.IParseState;
import com.aptana.parsing.ParserPoolFactory;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;

public class BaseHTMLDomAssist
implements IHTMLDomAssist {
    private AbstractThemeableEditor editor = null;

    public boolean matches(List<String> types) {
        String[] stringArray = DOM_TYPES;
        int n = DOM_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            String domType = stringArray[n2];
            if (types.contains(domType)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public List<String> getDOMTypes(AbstractThemeableEditor editor, JSInvokeNode ivkNode, JSNode currentNode) {
        List<String> resultTags = this.getTagsByCurrentNode(editor, ivkNode, currentNode);
        return this.getDOMTypesByTags(resultTags);
    }

    public List<String> getDOMTypesByTags(List<String> tags) {
        ArrayList<String> domTypes = new ArrayList<String>();
        HTMLIndexQueryHelper queryHelper = new HTMLIndexQueryHelper();
        for (String tag : tags) {
            ElementElement ee = queryHelper.getElement(tag);
            if (ee == null) continue;
            domTypes.add(ee.getRelatedClass());
        }
        return domTypes;
    }

    protected List<String> getTagsByCurrentNode(AbstractThemeableEditor editor, JSInvokeNode ivkNode, JSNode currentNode) {
        ArrayList<String> resultTags = new ArrayList<String>();
        this.editor = editor;
        if (ivkNode != null) {
            DomProperties domProperties = ParseUtil.inferrerDomProperties((IParseNode)ivkNode, (JSNode)currentNode);
            resultTags.addAll(domProperties.getTags());
            resultTags.addAll(this.getTagsByIdList(domProperties.getIds()));
            resultTags.addAll(this.getTagsByClassList(domProperties.getClasses()));
            return resultTags;
        }
        return resultTags;
    }

    protected Set<String> getTagsByClassList(List<String> classes) {
        IEditorInput input;
        HashSet<String> resultTags = new HashSet<String>();
        if (classes.isEmpty()) {
            return resultTags;
        }
        ArrayList<HTMLParseRootNode> htmlRootNodes = new ArrayList<HTMLParseRootNode>();
        if (this.editor instanceof HTMLEditor) {
            IDocument document = this.editor.getDocument();
            HTMLParseState htmlParseState = new HTMLParseState(document.get());
            try {
                htmlParseState.setParseNestedLanguage(false);
                IParseRootNode rootNode = ParserPoolFactory.parse((String)"com.aptana.contenttype.html", (IParseState)htmlParseState).getRootNode();
                if (rootNode instanceof HTMLParseRootNode) {
                    htmlRootNodes.add((HTMLParseRootNode)rootNode);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (this.editor instanceof JSSourceEditor && (input = this.editor.getEditorInput()) instanceof IFileEditorInput) {
            Set<String> htmlFiles;
            IFileEditorInput fileInput = (IFileEditorInput)input;
            IFile jsFile = fileInput.getFile();
            HTMLIndexQueryHelper htmlQueryHelper = new HTMLIndexQueryHelper();
            Map<String, Set<String>> jsReferences = htmlQueryHelper.getJSReferences(EditorUtil.getIndex((AbstractThemeableEditor)this.editor));
            String key = jsFile.getLocationURI().toString();
            if (jsReferences != null && jsReferences.containsKey(key) && (htmlFiles = jsReferences.get(key)) != null) {
                for (String htmlFile : htmlFiles) {
                    File html = jsFile.getProject().getLocation().append(htmlFile).makeAbsolute().toFile();
                    if (!html.exists()) continue;
                    try {
                        HTMLParseState htmlParseState = new HTMLParseState(FileUtils.readFileToString((File)html));
                        htmlParseState.setParseNestedLanguage(false);
                        IParseRootNode rootNode = ParserPoolFactory.parse((String)"com.aptana.contenttype.html", (IParseState)htmlParseState).getRootNode();
                        if (!(rootNode instanceof HTMLParseRootNode)) continue;
                        htmlRootNodes.add((HTMLParseRootNode)rootNode);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        for (HTMLParseRootNode htmlParseRootNode : htmlRootNodes) {
            for (String cls : classes) {
                HTMLElementClassInferrer idInferrer = new HTMLElementClassInferrer(cls);
                idInferrer.visit((IParseNode)htmlParseRootNode);
                Set<String> tags = idInferrer.getTags();
                resultTags.addAll(tags);
            }
        }
        return resultTags;
    }

    protected Set<String> getTagsByIdList(List<String> domIdList) {
        IEditorInput input;
        HashSet<String> resultTags = new HashSet<String>();
        if (domIdList.isEmpty()) {
            return resultTags;
        }
        ArrayList<HTMLParseRootNode> htmlRootNodes = new ArrayList<HTMLParseRootNode>();
        if (this.editor instanceof HTMLEditor) {
            IDocument document = this.editor.getDocument();
            HTMLParseState htmlParseState = new HTMLParseState(document.get());
            try {
                htmlParseState.setParseNestedLanguage(false);
                IParseRootNode rootNode = ParserPoolFactory.parse((String)"com.aptana.contenttype.html", (IParseState)htmlParseState).getRootNode();
                if (rootNode instanceof HTMLParseRootNode) {
                    htmlRootNodes.add((HTMLParseRootNode)rootNode);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (this.editor instanceof JSSourceEditor && (input = this.editor.getEditorInput()) instanceof IFileEditorInput) {
            Set<String> htmlFiles;
            IFileEditorInput fileInput = (IFileEditorInput)input;
            IFile jsFile = fileInput.getFile();
            HTMLIndexQueryHelper htmlQueryHelper = new HTMLIndexQueryHelper();
            Map<String, Set<String>> jsReferences = htmlQueryHelper.getJSReferences(EditorUtil.getIndex((AbstractThemeableEditor)this.editor));
            String key = jsFile.getLocationURI().toString();
            if (jsReferences != null && jsReferences.containsKey(key) && (htmlFiles = jsReferences.get(key)) != null) {
                for (String htmlFile : htmlFiles) {
                    File html = jsFile.getProject().getLocation().append(htmlFile).makeAbsolute().toFile();
                    if (!html.exists()) continue;
                    try {
                        HTMLParseState htmlParseState = new HTMLParseState(FileUtils.readFileToString((File)html));
                        htmlParseState.setParseNestedLanguage(false);
                        IParseRootNode rootNode = ParserPoolFactory.parse((String)"com.aptana.contenttype.html", (IParseState)htmlParseState).getRootNode();
                        if (!(rootNode instanceof HTMLParseRootNode)) continue;
                        htmlRootNodes.add((HTMLParseRootNode)rootNode);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        for (HTMLParseRootNode htmlParseRootNode : htmlRootNodes) {
            for (String domId : domIdList) {
                HTMLElementIDInferrer idInferrer = new HTMLElementIDInferrer(domId);
                idInferrer.visit((IParseNode)htmlParseRootNode);
                Set<String> tags = idInferrer.getTags();
                resultTags.addAll(tags);
            }
        }
        return resultTags;
    }
}

