/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.ext;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonContentAssistProcessor;
import com.aptana.editor.common.extensions.ISpecialListHandler;
import com.aptana.editor.common.extensions.ISpecialValueListLocationType;
import com.aptana.editor.common.extensions.SpecialValueLocationType;
import com.aptana.editor.common.util.EditorUtil;
import com.aptana.editor.css.htmlext.IAttrName;
import com.aptana.editor.html.HTMLEditor;
import com.aptana.editor.html.contentassist.HTMLIndexQueryHelper;
import com.aptana.editor.html.contentassist.model.AttributeElement;
import com.aptana.editor.html.contentassist.model.ElementElement;
import com.aptana.editor.html.contentassist.model.ValueElement;
import com.aptana.editor.html.ext.AttrSpecialListHandler;
import com.aptana.editor.html.parsing.ast.HTMLElementNode;
import com.aptana.editor.js.contentassist.ParseUtil;
import com.aptana.editor.js.contentassist.inferencing.JSAssistNodeTypeInferrer;
import com.aptana.editor.js.contentassist.model.FunctionElement;
import com.aptana.editor.js.contentassist.model.FunctionTypeElement;
import com.aptana.editor.js.contentassist.model.ParameterElement;
import com.aptana.editor.js.contentassist.model.TypeElement;
import com.aptana.editor.js.htmlext.IAttrNameAware;
import com.aptana.editor.js.inferencing.JSScope;
import com.aptana.editor.js.parsing.ast.JSArgumentsNode;
import com.aptana.editor.js.parsing.ast.JSInvokeNode;
import com.aptana.editor.js.parsing.ast.JSNode;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.lexer.IRange;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.ui.IEditorPart;

public class AttrValueSpecialListHandler
extends AttrSpecialListHandler
implements IAttrNameAware,
IAttrName {
    private String attrName = null;
    private HTMLIndexQueryHelper queryHelper = new HTMLIndexQueryHelper();

    public String inferrerAttrName(JSNode equalsNode, AbstractThemeableEditor editor) {
        JSArgumentsNode argsNode;
        if (equalsNode == null) {
            return "";
        }
        if (equalsNode instanceof JSInvokeNode) {
            JSInvokeNode ivkNode = (JSInvokeNode)equalsNode;
            JSArgumentsNode argsNode2 = (JSArgumentsNode)ivkNode.getArguments();
            return ParseUtil.inferrerArgValue((JSArgumentsNode)argsNode2, (int)0);
        }
        if (equalsNode.getParent() instanceof JSArgumentsNode && (argsNode = (JSArgumentsNode)equalsNode.getParent()).getParent() instanceof JSInvokeNode) {
            JSInvokeNode ivkNode = (JSInvokeNode)argsNode.getParent();
            JSScope scope = ParseUtil.getScopeAtOffset((IParseNode)ivkNode, (int)ivkNode.getStartingOffset());
            JSAssistNodeTypeInferrer inferrer = new JSAssistNodeTypeInferrer(scope, EditorUtil.getIndex((AbstractThemeableEditor)editor), EditorUtil.getURI((IEditorPart)editor));
            inferrer.visit((JSNode)ivkNode.getExpression());
            List types = inferrer.getTypes();
            for (TypeElement type : types) {
                FunctionTypeElement funcType;
                FunctionElement func;
                if (!(type instanceof FunctionTypeElement) || (func = (funcType = (FunctionTypeElement)type).toFunction()) == null) continue;
                int index = 0;
                for (ParameterElement param : func.getParameters()) {
                    if (param.getTypes().contains("AttrString")) {
                        return ParseUtil.inferrerArgValue((JSArgumentsNode)argsNode, (int)index);
                    }
                    ++index;
                }
            }
        }
        return "";
    }

    public String getAttrType(String attrName, JSNode equalsExpressNode, AbstractThemeableEditor editor) {
        String attrType = "String";
        if ("id".equals(attrName)) {
            attrType = "IDString";
        } else if ("class".equals(attrName)) {
            attrType = "ClassString";
        } else if ("color".equals(attrName)) {
            attrType = "ColorString";
        } else if ("face".equals(attrName)) {
            attrType = "FontString";
        } else if ("action".equals(attrName)) {
            attrType = "URIString";
        } else if ("src".equals(attrName) || "href".equals(attrName)) {
            attrType = "URIString";
            this.domProperties = ParseUtil.inferrerDomProperties((IParseNode)equalsExpressNode, null);
            if (this.domProperties != null) {
                HashSet<HTMLElementNode> elements = new HashSet<HTMLElementNode>();
                if (editor instanceof HTMLEditor) {
                    this.processScriptAttrResults((HTMLEditor)editor, elements);
                } else {
                    this.processScriptAttrResults(editor, this.queryHelper, elements);
                }
                for (HTMLElementNode element : elements) {
                    this.domProperties.addTag(element.getElementName());
                }
                block1: for (String tag : this.domProperties.getTags()) {
                    AttributeElement attr = this.queryHelper.getAttribute(tag, attrName);
                    for (String type : attr.getTypes()) {
                        if ("String".equals(type)) continue;
                        attrType = type;
                        continue block1;
                    }
                }
            }
        }
        return attrType;
    }

    @Override
    public void doComputeSpecialProposals(AbstractThemeableEditor editor, int offset, IRange replaceRange, Set<ICompletionProposal> result, boolean isHTML) {
        if (StringUtil.isNotEmpty((String)this.attrName)) {
            List<AttributeElement> attrs;
            HashMap<String, String> resultMap = new HashMap<String, String>();
            HashSet<String> tags = new HashSet<String>();
            if (this.domProperties != null) {
                HashSet<HTMLElementNode> elements = new HashSet<HTMLElementNode>();
                if (editor instanceof HTMLEditor) {
                    this.processScriptAttrResults((HTMLEditor)editor, elements);
                } else {
                    this.processScriptAttrResults(editor, this.queryHelper, elements);
                }
                tags.addAll(this.domProperties.getTags());
                for (HTMLElementNode elNode : elements) {
                    String tag = elNode.getName();
                    if (!StringUtil.isNotEmpty((String)tag)) continue;
                    tags.add(tag);
                }
                for (String tag : tags) {
                    AttributeElement attrElement;
                    ElementElement el = this.queryHelper.getElement(tag);
                    if (el == null || !el.getAttributes().contains(this.attrName) || (attrElement = this.queryHelper.getAttribute(tag, this.attrName)) == null) continue;
                    List<String> types = attrElement.getTypes();
                    for (String type : types) {
                        ISpecialListHandler handler = (ISpecialListHandler)CommonContentAssistProcessor.SPEC_MAPS.get(type);
                        if (handler == null) continue;
                        if (handler instanceof ISpecialValueListLocationType) {
                            ((ISpecialValueListLocationType)handler).setLocationType(SpecialValueLocationType.IN_HTML);
                        }
                        handler.doComputeSpecialProposals(editor, offset, replaceRange, result, isHTML);
                    }
                    List<ValueElement> values = attrElement.getValues();
                    for (ValueElement value : values) {
                        resultMap.put(value.getName(), value.getDescription());
                    }
                }
            }
            if (resultMap.isEmpty() && (this.domProperties == null || CollectionsUtil.isEmpty((Collection)this.domProperties.getTags())) && !CollectionsUtil.isEmpty(attrs = this.queryHelper.getAttribute(this.attrName))) {
                for (AttributeElement attrElement : attrs) {
                    if (attrElement == null) continue;
                    List<ValueElement> values = attrElement.getValues();
                    for (ValueElement value : values) {
                        String ownTag = StringUtil.isNotEmpty((String)attrElement.getElement()) ? String.valueOf(StringUtil.toBolder((String)("&lt;" + attrElement.getElement() + "&gt;"))) + "<br />" : "";
                        resultMap.put(value.getName(), String.valueOf(ownTag) + value.getDescription());
                    }
                }
            }
            this.addProposals(replaceRange, result, resultMap, isHTML);
        }
        this.setAttrName(null);
    }

    public void setAttrName(String attrName) {
        this.attrName = attrName;
    }
}

