/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.contentassist.model;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.editor.css.CSSPlugin;
import com.aptana.editor.html.contentassist.HTMLIndexQueryHelper;
import com.aptana.editor.html.contentassist.model.BaseElement;
import com.aptana.editor.html.contentassist.model.JSReference;
import com.aptana.editor.html.contentassist.model.Messages;
import com.aptana.index.core.Index;
import com.aptana.index.core.ui.views.IPropertyInformation;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;

public class JSReferencesGroup
extends BaseElement<Property> {
    private Index index;
    private List<JSReference> references;

    public JSReferencesGroup(Index index) {
        this.index = index;
        this.setName(Messages.JSReferencesGroup_JSReferencesElementName);
    }

    public Index getIndex() {
        return this.index;
    }

    @Override
    protected Set<Property> getPropertyInfoSet() {
        return EnumSet.allOf(Property.class);
    }

    public List<JSReference> getReferences() {
        if (this.references == null) {
            HTMLIndexQueryHelper queryHelper = new HTMLIndexQueryHelper();
            Map<String, Set<String>> resourceMap = queryHelper.getJSReferences(this.index);
            if (!CollectionsUtil.isEmpty(resourceMap)) {
                this.references = new ArrayList<JSReference>();
                for (Map.Entry<String, Set<String>> entry : resourceMap.entrySet()) {
                    try {
                        String path = entry.getKey();
                        URI uri = new URI(path);
                        File file = new File(uri);
                        JSReference reference = new JSReference(file.getName(), path);
                        this.references.add(reference);
                    }
                    catch (URISyntaxException e) {
                        String message = "An error occurred while converting a JS reference to a URI: " + e.getMessage();
                        IdeLog.logError((Plugin)CSSPlugin.getDefault(), (String)message);
                    }
                }
            } else {
                this.references = Collections.emptyList();
            }
        }
        return this.references;
    }

    static enum Property implements IPropertyInformation<JSReferencesGroup>
    {
        NAME(Messages.JSReferencesGroup_NameLabel){

            public Object getPropertyValue(JSReferencesGroup node) {
                return node.getName();
            }
        }
        ,
        COUNT(Messages.JSReferencesGroup_CountLabel){

            public Object getPropertyValue(JSReferencesGroup node) {
                return node.getReferences().size();
            }
        };

        private String header;
        private String category;

        private Property(String header) {
            this.header = header;
        }

        private Property(String header, String category) {
            this.category = category;
        }

        public String getCategory() {
            return this.category;
        }

        public String getHeader() {
            return this.header;
        }
    }
}

