/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.contentassist.model;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.html.contentassist.model.BaseElement;
import com.aptana.editor.html.contentassist.model.Messages;
import com.aptana.editor.html.contentassist.model.SpecificationElement;
import com.aptana.editor.html.contentassist.model.UserAgentElement;
import com.aptana.index.core.IndexUtil;
import com.aptana.index.core.ui.views.IPropertyInformation;
import com.aptana.jetty.util.epl.ajax.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EventElement
extends BaseElement<Property> {
    private static final String USER_AGENTS_PROPERTY = "userAgents";
    private static final String SPECIFICATIONS_PROPERTY = "specifications";
    private static final String REMARK_PROPERTY = "remark";
    private static final String TYPE_PROPERTY = "type";
    private static final String ELEMENT_PROPERTY = "element";
    private String _type;
    private List<SpecificationElement> _specifications;
    private List<UserAgentElement> _userAgents;
    private String _remark;
    private String _element;

    public String getElement() {
        return this._element;
    }

    public void setElement(String _element) {
        this._element = _element;
    }

    public void addSpecification(SpecificationElement specification) {
        if (specification != null) {
            if (this._specifications == null) {
                this._specifications = new ArrayList<SpecificationElement>();
            }
            this._specifications.add(specification);
        }
    }

    public void addUserAgent(UserAgentElement userAgent) {
        if (userAgent != null) {
            if (this._userAgents == null) {
                this._userAgents = new ArrayList<UserAgentElement>();
            }
            this._userAgents.add(userAgent);
        }
    }

    @Override
    public void fromJSON(Map object) {
        super.fromJSON(object);
        this.setType(StringUtil.getStringValue(object.get(TYPE_PROPERTY)));
        this.setRemark(StringUtil.getStringValue(object.get(REMARK_PROPERTY)));
        this.setElement(StringUtil.getStringValue(object.get(ELEMENT_PROPERTY)));
        this._specifications = IndexUtil.createList(object.get(SPECIFICATIONS_PROPERTY), SpecificationElement.class);
        this._userAgents = IndexUtil.createList(object.get(USER_AGENTS_PROPERTY), UserAgentElement.class);
    }

    public String getRemark() {
        return StringUtil.getStringValue((Object)this._remark);
    }

    public List<SpecificationElement> getSpecifications() {
        return CollectionsUtil.getListValue(this._specifications);
    }

    public String getType() {
        return StringUtil.getStringValue((Object)this._type);
    }

    public List<UserAgentElement> getUserAgents() {
        return CollectionsUtil.getListValue(this._userAgents);
    }

    public Map<String, String> getUserAgentsNameWithVersion() {
        HashMap<String, String> userAgents = new HashMap<String, String>();
        for (UserAgentElement userAgent : this.getUserAgents()) {
            userAgents.put(userAgent.getPlatform(), userAgent.getVersion());
        }
        return userAgents;
    }

    public void setRemark(String remark) {
        this._remark = remark;
    }

    public void setType(String type) {
        this._type = type;
    }

    @Override
    public void toJSON(JSON.Output out) {
        super.toJSON(out);
        out.add(TYPE_PROPERTY, (Object)this.getType());
        out.add(REMARK_PROPERTY, (Object)this.getRemark());
        out.add(ELEMENT_PROPERTY, (Object)this.getElement());
        out.add(SPECIFICATIONS_PROPERTY, this.getSpecifications());
        out.add(USER_AGENTS_PROPERTY, this.getUserAgents());
    }

    static enum Property implements IPropertyInformation<EventElement>
    {
        NAME(Messages.EventElement_NameLabel){

            public Object getPropertyValue(EventElement node) {
                return node.getName();
            }
        };

        private String header;
        private String category;

        private Property(String header) {
            this.header = header;
        }

        private Property(String header, String category) {
            this.category = category;
        }

        public String getCategory() {
            return this.category;
        }

        public String getHeader() {
            return this.header;
        }
    }
}

