/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.contentassist.model;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.editor.css.CSSPlugin;
import com.aptana.editor.html.contentassist.HTMLIndexQueryHelper;
import com.aptana.editor.html.contentassist.model.BaseElement;
import com.aptana.editor.html.contentassist.model.CSSReference;
import com.aptana.editor.html.contentassist.model.Messages;
import com.aptana.index.core.Index;
import com.aptana.index.core.ui.views.IPropertyInformation;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;

public class CSSReferencesGroup
extends BaseElement<Property> {
    private Index index;
    private List<CSSReference> references;

    public CSSReferencesGroup(Index index) {
        this.index = index;
        this.setName(Messages.CSSReferencesGroup_CSSReferencesElementName);
    }

    public Index getIndex() {
        return this.index;
    }

    @Override
    protected Set<Property> getPropertyInfoSet() {
        return EnumSet.allOf(Property.class);
    }

    public List<CSSReference> getReferences() {
        if (this.references == null) {
            HTMLIndexQueryHelper queryHelper = new HTMLIndexQueryHelper();
            Map<String, Set<String>> resourceMap = queryHelper.getCSSReferences(this.index);
            if (!CollectionsUtil.isEmpty(resourceMap)) {
                this.references = new ArrayList<CSSReference>();
                for (Map.Entry<String, Set<String>> entry : resourceMap.entrySet()) {
                    try {
                        String path = entry.getKey();
                        URI uri = new URI(path);
                        File file = new File(uri);
                        CSSReference reference = new CSSReference(file.getName(), path);
                        this.references.add(reference);
                    }
                    catch (URISyntaxException e) {
                        String message = "An error occurred while converting a CSS reference to a URI: " + e.getMessage();
                        IdeLog.logError((Plugin)CSSPlugin.getDefault(), (String)message);
                    }
                }
            } else {
                this.references = Collections.emptyList();
            }
        }
        return this.references;
    }

    static enum Property implements IPropertyInformation<CSSReferencesGroup>
    {
        NAME(Messages.CSSReferencesGroup_NameLabel){

            public Object getPropertyValue(CSSReferencesGroup node) {
                return node.getName();
            }
        }
        ,
        COUNT(Messages.CSSReferencesGroup_CountLabel){

            public Object getPropertyValue(CSSReferencesGroup node) {
                return node.getReferences().size();
            }
        };

        private String header;
        private String category;

        private Property(String header) {
            this.header = header;
        }

        private Property(String header, String category) {
            this.category = category;
        }

        public String getCategory() {
            return this.category;
        }

        public String getHeader() {
            return this.header;
        }
    }
}

