/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.contentassist.index;

import com.aptana.build.util.BuildHelper;
import com.aptana.buildpath.core.BuildPathCorePlugin;
import com.aptana.buildpath.core.BuildPathEntry;
import com.aptana.buildpath.core.BuildPathManager;
import com.aptana.core.CorePlugin;
import com.aptana.core.IFilter;
import com.aptana.core.build.BuildFileManager;
import com.aptana.core.build.SDocMLFileIndexingFilter;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.resolver.URIResolver;
import com.aptana.editor.css.contentassist.index.CSSFileIndexingParticipant;
import com.aptana.editor.html.HTMLPlugin;
import com.aptana.editor.html.HTMLTemplatePartitionUtils;
import com.aptana.editor.html.parsing.HTMLParseState;
import com.aptana.editor.html.parsing.ast.HTMLElementNode;
import com.aptana.editor.html.parsing.ast.HTMLSpecialNode;
import com.aptana.editor.js.contentassist.index.JSFileIndexingParticipant;
import com.aptana.editor.js.contentassist.index.JSIndexCacher;
import com.aptana.editor.js.contentassist.index.SDocMLFileIndexingParticipant;
import com.aptana.index.core.AbstractRemoteFileIndexingParticipant;
import com.aptana.index.core.BuildContextType;
import com.aptana.index.core.FileStoreBuildContext;
import com.aptana.index.core.IFileStoreIndexingContextType;
import com.aptana.index.core.Index;
import com.aptana.index.core.IndexUrisJob;
import com.aptana.index.core.build.BuildContext;
import com.aptana.parsing.IParseState;
import com.aptana.parsing.ParserPoolFactory;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.parsing.util.ParseUtil;
import com.pandora.core.stats.Stats;
import com.pandora.core.utils.RegularUtils;
import com.pandora.index.service.IndexRequest;
import com.pandora.index.service.IndexServicePlugin;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IDocument;

public class HTMLFileIndexingParticipant
extends AbstractRemoteFileIndexingParticipant
implements IFileStoreIndexingContextType {
    private static final String ELEMENT_LINK = "link";
    private static final String ELEMENT_SCRIPT = "script";
    private static final String ATTRIBUTE_HREF = "href";
    private static final String ATTRIBUTE_SRC = "src";
    private JSFileIndexingParticipant jsIndex;
    private SDocMLFileIndexingParticipant sdocmlIndex;
    private BuildContextType buildContextType = BuildContextType.ALL;

    public void requestIndex(IndexRequest request, IProgressMonitor monitor) {
        String content;
        IParseRootNode ast;
        SubMonitor sub;
        block13: {
            sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            sub.subTask(this.getIndexingMessage(request.getProjectURI(), request.getIndexURI()));
            this.jsIndex = null;
            ast = null;
            HTMLParseState parseState = null;
            content = request.readContents();
            try {
                try {
                    parseState = new HTMLParseState(content);
                    if (request.isNeedSleep()) {
                        parseState.setNeedSleep(true);
                    }
                    ast = ParserPoolFactory.parse((String)"com.aptana.contenttype.html", (IParseState)parseState).getRootNode();
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (Throwable)e);
                    Stats.addExceptionInfo((Throwable)e);
                    if (parseState != null) {
                        parseState.clearEditState();
                    }
                    break block13;
                }
            }
            catch (Throwable throwable) {
                if (parseState != null) {
                    parseState.clearEditState();
                }
                throw throwable;
            }
            if (parseState != null) {
                parseState.clearEditState();
            }
        }
        if (ast != null) {
            this.walkAST(request, (IParseNode)ast, monitor);
        }
        this.indexTemplateStrings(request, content);
        if (request.isReconcile()) {
            try {
                this.ensureReferencesIndex(request);
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)CorePlugin.getDefault(), (Throwable)e);
            }
        }
        sub.done();
    }

    public void ensureReferencesIndex(IndexRequest request) {
        Index index = this.getIndex(request);
        HashSet refs = new HashSet();
        if (this.indexResult.containsKey("html.resource.js")) {
            refs.addAll((Collection)this.indexResult.get("html.resource.js"));
        }
        if (this.indexResult.containsKey("html.resource.css")) {
            refs.addAll((Collection)this.indexResult.get("html.resource.css"));
        }
        URI projectURI = request.getProjectURI();
        HashSet<URI> refFiles = new HashSet<URI>();
        for (String ref : refs) {
            JSIndexCacher cacher;
            Map projectIndex;
            URI uri;
            block12: {
                uri = URI.create(ref);
                if (request.isHBuilder()) {
                    try {
                        if (CollectionsUtil.isNotEmpty((Collection)index.queryDocumentNames(uri.toString()))) {
                            continue;
                        }
                        break block12;
                    }
                    catch (IOException e) {
                        IdeLog.logError((Plugin)CorePlugin.getDefault(), (Throwable)e);
                        break block12;
                    }
                }
                try {
                    if (CollectionsUtil.isNotEmpty((Collection)HTMLFileIndexingParticipant.getLocalIndexService().queryDocumentNames(request.getProjectURI(), uri))) {
                        continue;
                    }
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)CorePlugin.getDefault(), (Throwable)e);
                }
            }
            if ((projectIndex = (Map)(cacher = JSIndexCacher.getInstance()).getCacher().get(index.getRoot().toString())) != null && projectIndex.containsKey(uri.toString())) continue;
            URI refURI = index.getRelativeDocumentPath(uri);
            String filePath = refURI.toString();
            URI fileURI = URI.create(String.valueOf(projectURI.toString()) + "/" + filePath);
            if (request.isHBuilder()) {
                refFiles.add(fileURI);
                continue;
            }
            IndexRequest r = new IndexRequest();
            r.setCharset(request.getCharset());
            r.setHBuilder(request.isHBuilder());
            r.setHighPriority(request.isHighPriority());
            r.setIndexURI(fileURI);
            r.setNeedSleep(request.isNeedSleep());
            r.setProjectURI(projectURI);
            r.setReconcile(request.isReconcile());
            r.setRequestTime(System.currentTimeMillis());
            IndexServicePlugin.getDefault().getLinkedBlockingQueueService().insert(r);
        }
        if (request.isHBuilder()) {
            IndexUrisJob refsIndexJob = new IndexUrisJob(request.getProjectURI(), refFiles);
            EclipseUtil.setSystemForJob((Job)refsIndexJob);
            refsIndexJob.schedule();
        }
    }

    private void indexTemplateStrings(IndexRequest request, String content) {
        try {
            IDocument document = HTMLTemplatePartitionUtils.getDocument(content);
            HashSet<String> tpls = new HashSet<String>();
            HTMLTemplatePartitionUtils.getTemplateStrings(document, tpls, "");
            for (String tpl : tpls) {
                this.addIndex("html.string.tpl", tpl);
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)CorePlugin.getDefault(), (Throwable)e);
        }
    }

    private void processHTMLElementNode(IndexRequest request, URI uri, HTMLElementNode element) {
        URIResolver resolver;
        URI resolved;
        String cssLink;
        String id;
        String reg;
        String cssClass = element.getCSSClass();
        if (!StringUtil.isEmpty((String)cssClass) && RegularUtils.isMatch((String)(reg = "^[\\w-\\s\u4e00-\u9fa5]+$"), (String)cssClass)) {
            StringTokenizer tokenizer = new StringTokenizer(cssClass);
            while (tokenizer.hasMoreTokens()) {
                this.addIndex("css.class", tokenizer.nextToken());
            }
        }
        if (!StringUtil.isEmpty((String)(id = element.getID()))) {
            this.addIndex("css.identifier", id);
        }
        if (element.getName().equalsIgnoreCase(ELEMENT_LINK) && !StringUtil.isEmpty((String)(cssLink = element.getAttributeValue(ATTRIBUTE_HREF))) && (resolved = (resolver = new URIResolver(uri)).resolveURI(cssLink)) != null) {
            this.addIndex("html.resource.css", resolved.toString());
            if (request.isHBuilder()) {
                BuildFileManager.getInstance().addJSReferencesHighPriorityIFile(resolved);
            } else if (!request.isReconcile()) {
                IndexRequest r = new IndexRequest();
                r.setCharset(request.getCharset());
                r.setHBuilder(request.isHBuilder());
                r.setHighPriority(request.isHighPriority());
                r.setIndexURI(resolved);
                r.setNeedSleep(request.isNeedSleep());
                r.setProjectURI(request.getProjectURI());
                r.setReconcile(request.isReconcile());
                r.setRequestTime(System.currentTimeMillis());
                IndexServicePlugin.getDefault().getLinkedBlockingQueueService().insert(r);
            }
        }
    }

    private void processHTMLSpecialNode(IndexRequest request, HTMLSpecialNode htmlSpecialNode) {
        String language;
        IParseNode child = htmlSpecialNode.getChild(0);
        if (child != null && "com.aptana.contenttype.css".equals(language = child.getLanguage()) && (BuildContextType.CSS == this.buildContextType || BuildContextType.ALL == this.buildContextType)) {
            CSSFileIndexingParticipant cssIndex = this.createCSSIndexer();
            int[] counts = new int[]{0};
            cssIndex.walkNode(child, request.isNeedSleep(), counts);
            if (request.isHBuilder()) {
                cssIndex.saveIndex(request, this.getIndex(request));
            } else {
                cssIndex.submitIndex(request);
            }
        }
        if (htmlSpecialNode.getName().equalsIgnoreCase(ELEMENT_SCRIPT)) {
            String jsSource = htmlSpecialNode.getAttributeValue(ATTRIBUTE_SRC);
            URI uri = null;
            if (StringUtil.isNotEmpty((String)jsSource) && !jsSource.trim().startsWith("<") && !jsSource.trim().startsWith("{") && request.getProjectURI() != null) {
                try {
                    URIResolver resolver = null;
                    File file = new File(request.getProjectURI());
                    if (!file.exists()) {
                        return;
                    }
                    URI appsource = file.toURI();
                    if (jsSource.startsWith("//")) {
                        jsSource = "http:" + jsSource;
                    }
                    URI resolved = null;
                    URI jsSourceUri = new URI(jsSource);
                    if (jsSourceUri.getScheme() == null) {
                        if (jsSource.startsWith("/")) {
                            try {
                                uri = new URI(String.valueOf(appsource.toString()) + "/config.xml");
                                resolver = new URIResolver(uri);
                            }
                            catch (URISyntaxException e) {
                                e.printStackTrace();
                            }
                            jsSource = jsSource.substring(1, jsSource.length());
                        } else {
                            uri = request.getIndexURI();
                            resolver = new URIResolver(request.getIndexURI());
                        }
                        resolved = resolver.resolveURI(jsSource);
                    } else if (request.isHBuilder()) {
                        this.autoCheckAndBuildSDOCML(jsSource, request);
                    } else {
                        HTMLFileIndexingParticipant.getLocalIndexService().autoCheckAndBuildSDOCML(request, jsSource);
                    }
                    if (resolved != null) {
                        this.addIndex("html.resource.js", resolved.toString());
                        if (request.isHBuilder()) {
                            BuildFileManager.getInstance().addJSReferencesHighPriorityIFile(resolved);
                        } else if (!request.isReconcile()) {
                            IndexRequest r = new IndexRequest();
                            r.setCharset(request.getCharset());
                            r.setHBuilder(request.isHBuilder());
                            r.setHighPriority(request.isHighPriority());
                            r.setIndexURI(resolved);
                            r.setNeedSleep(request.isNeedSleep());
                            r.setProjectURI(request.getProjectURI());
                            r.setReconcile(request.isReconcile());
                            r.setRequestTime(System.currentTimeMillis());
                            IndexServicePlugin.getDefault().getLinkedBlockingQueueService().insert(r);
                        }
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (Throwable)e);
                }
            } else if (child != null && "com.aptana.contenttype.js".equals(child.getLanguage()) && (BuildContextType.JS == this.buildContextType || BuildContextType.ALL == this.buildContextType)) {
                this.jsIndex = this.createJSIndexer(this.getIndex(request), request.getIndexURI());
                this.jsIndex.processParseResults(request, child, (IProgressMonitor)new NullProgressMonitor());
            }
        }
    }

    public void autoCheckAndBuildSDOCML(String jsSource, IndexRequest request) throws CoreException {
        if (StringUtil.isBlank((String)jsSource) || request == null) {
            return;
        }
        int sIndex = jsSource.lastIndexOf("/");
        String fname = "";
        String tmpVersion = "";
        if (sIndex > -1) {
            fname = jsSource.substring(sIndex + 1);
            tmpVersion = jsSource.substring(0, sIndex);
            if ((sIndex = tmpVersion.lastIndexOf("/")) > -1) {
                tmpVersion = tmpVersion.substring(sIndex + 1);
            }
        }
        if (StringUtil.isBlank((String)fname)) {
            return;
        }
        String disPlayName = "";
        BuildPathManager buildPathManager = BuildPathManager.getInstance();
        String reg = "\\d+\\.?(\\d*\\.?)\\d*";
        String jqKey = "jquery";
        String tmpKey = "";
        if (SDocMLFileIndexingFilter.buildPathEntrys == null || SDocMLFileIndexingFilter.buildPathEntrys.isEmpty()) {
            SDocMLFileIndexingFilter.init();
        }
        Set keySet = SDocMLFileIndexingFilter.displayNames.keySet();
        for (String[] nv : keySet) {
            String key = nv[0];
            if (!fname.contains(key = key.toLowerCase())) continue;
            tmpKey = key;
            boolean isJQKey = jqKey.equals(key);
            if (!isJQKey) {
                if (!SDocMLFileIndexingFilter.checkIsZeptoJS((String)fname) && !SDocMLFileIndexingFilter.checkIsMuiJS((String)fname) && !SDocMLFileIndexingFilter.checkIsWXJS((String)fname) && !SDocMLFileIndexingFilter.checkSpecJS((String)fname)) break;
                disPlayName = (String)SDocMLFileIndexingFilter.displayNames.get(nv);
                break;
            }
            if (!SDocMLFileIndexingFilter.checkIsJQ((String)fname)) break;
            disPlayName = "jquery 2.0";
            Object v = RegularUtils.match((String)reg, (String)fname, (int)0);
            if (StringUtil.isBlank((String)v) && StringUtil.isBlank((String)(v = RegularUtils.match((String)reg, (String)tmpVersion, (int)0)))) break;
            String[] vs = ((String)v).split("\\.");
            String lv = vs[0];
            if (nv[1].startsWith(lv)) {
                disPlayName = (String)SDocMLFileIndexingFilter.displayNames.get(nv);
                break;
            }
            boolean isexist = false;
            for (String[] nvs : keySet) {
                if (!nvs[0].equals(key) || !nvs[1].startsWith(lv)) continue;
                disPlayName = (String)SDocMLFileIndexingFilter.displayNames.get(nvs);
                isexist = true;
                break;
            }
            if (isexist) break;
        }
        if (StringUtil.isNotBlank((String)disPlayName)) {
            BuildPathEntry buildPathEntry = (BuildPathEntry)SDocMLFileIndexingFilter.buildPathEntryMap.get(disPlayName);
            Set buildPathEntrySet = buildPathManager.getBuildPaths(request.getProjectURI());
            if (!buildPathEntrySet.contains(buildPathEntry)) {
                boolean isAdded = false;
                if (StringUtil.isNotBlank((String)tmpKey)) {
                    for (BuildPathEntry bpe : buildPathEntrySet) {
                        if (!bpe.getDisplayName().toLowerCase().contains(tmpKey)) continue;
                        isAdded = true;
                        break;
                    }
                }
                if (!isAdded) {
                    this.buildSDOCmlFile(buildPathEntry, request);
                    buildPathEntrySet.add(buildPathEntry);
                    Object[] bea = new BuildPathEntry[buildPathEntrySet.size()];
                    ArrayList list = new ArrayList();
                    buildPathEntrySet.toArray(bea);
                    CollectionsUtil.addToList(list, (Object[])bea);
                    buildPathManager.setBuildPaths(request.getProjectURI(), list);
                }
            }
        }
    }

    private void buildSDOCmlFile(BuildPathEntry buildPathEntry, IndexRequest request) throws CoreException {
        if (buildPathEntry == null || request == null) {
            return;
        }
        if (this.sdocmlIndex == null) {
            this.sdocmlIndex = new SDocMLFileIndexingParticipant();
        }
        Index index = this.getIndex(request);
        IFileStore fileStore = EFS.getStore((URI)buildPathEntry.getPath());
        File file = new File(request.getProjectURI());
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(file.getName());
        FileStoreBuildContext context = new FileStoreBuildContext(project, fileStore);
        context.setHighPriority(true);
        this.sdocmlIndex.index((BuildContext)context, index, (IProgressMonitor)new NullProgressMonitor());
    }

    protected URI getURI(IProject project) {
        if (project == null) {
            return null;
        }
        URI uri = project.getLocationURI();
        if (uri != null) {
            return uri;
        }
        IdeLog.logError((Plugin)BuildPathCorePlugin.getDefault(), (String)MessageFormat.format("Project's location URI is null. raw location: {0}, path: {1}", project.getRawLocationURI(), project.getFullPath()));
        return project.getRawLocationURI();
    }

    protected JSFileIndexingParticipant createJSIndexer(Index index, URI location) {
        if (this.jsIndex == null) {
            this.jsIndex = new JSFileIndexingParticipant();
            this.jsIndex.removeIndex(index, location.toString());
        }
        this.jsIndex.setNeedReflush(false);
        return this.jsIndex;
    }

    protected CSSFileIndexingParticipant createCSSIndexer() {
        return new CSSFileIndexingParticipant();
    }

    protected void processNode(IndexRequest request, URI uri, IParseNode current, int[] counts) {
        if (current instanceof HTMLSpecialNode) {
            if (request.isNeedSleep()) {
                BuildHelper.sleep((String)"HTML_INDEX_TYPE");
            }
            this.processHTMLSpecialNode(request, (HTMLSpecialNode)current);
        }
        if (current instanceof HTMLElementNode && BuildContextType.ALL == this.buildContextType) {
            this.processHTMLElementNode(request, uri, (HTMLElementNode)current);
        }
    }

    public void walkAST(BuildContext context, Index index, IParseNode parent, IProgressMonitor monitor) {
        try {
            IndexRequest request = new IndexRequest();
            request.setCharset(context.getCharset());
            request.setIndexURI(context.getURI());
            request.setNeedSleep(context.isNeedSleep());
            request.setReconcile(context.isReconcile());
            if (context.isReconcile()) {
                request.setContents(context.getContents());
            }
            if (context.getProject() != null) {
                request.setProjectURI(context.getProject().getLocationURI());
            }
            this.walkAST(request, parent, monitor);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void walkAST(final IndexRequest request, IParseNode parent, IProgressMonitor monitor) {
        if (request == null || parent == null) {
            return;
        }
        final URI uri = request.getIndexURI();
        final int[] counts = new int[]{0};
        ParseUtil.treeApply((IParseNode)parent, (IFilter)new IFilter<IParseNode>(){

            public boolean include(IParseNode item) {
                HTMLFileIndexingParticipant.this.processNode(request, uri, item, counts);
                return true;
            }
        }, (boolean)request.isNeedSleep());
    }

    public void setBuildContextType(BuildContextType contextType) {
        this.buildContextType = contextType;
    }

    public BuildContextType getBuildContextType() {
        return this.buildContextType;
    }

    public boolean isEnableType(BuildContextType contextType) {
        return true;
    }

    public void submitIndex(IndexRequest request) {
        super.submitIndex(request);
        if (this.jsIndex != null) {
            this.jsIndex.flushJSIndexCacher(this.getIndex(request), request.getIndexURI(), request.isNeedSleep());
            this.jsIndex.submitIndex(request);
        }
    }

    public void saveIndex(IndexRequest request, Index index) {
        super.saveIndex(request, index);
        if (this.jsIndex != null) {
            this.jsIndex.flushJSIndexCacher(this.getIndex(request), request.getIndexURI(), request.isNeedSleep());
            this.jsIndex.saveIndex(request, index);
        }
    }
}

