/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.contentassist;

import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.contentassist.CommonCompletionProposal;
import com.aptana.editor.html.HTMLEditor;
import com.aptana.editor.xml.TagUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.texteditor.ITextEditor;

public class HTMLElementProposal
extends CommonCompletionProposal {
    public void replace(ITextViewer viewer, int offset, IDocument document, int length, String toReplace) throws BadLocationException {
        Collection<Position> positions;
        boolean existOffset;
        HTMLEditor htmlEditor;
        Map<Annotation, Position> fTagPairOccurrences;
        ITypedRegion region = document.getPartition(offset);
        if (region == null || !region.getType().startsWith("__html")) {
            document.replace(offset, length, toReplace);
            return;
        }
        ITextEditor editor = (ITextEditor)((IAdaptable)viewer).getAdapter(ITextEditor.class);
        if (editor instanceof HTMLEditor && (fTagPairOccurrences = (htmlEditor = (HTMLEditor)editor).getfTagPairOccurrences()) != null && (existOffset = this.checkOffset(offset, positions = fTagPairOccurrences.values()))) {
            Position[] positionArray = positions.toArray(new Position[positions.size()]);
            Arrays.sort(positionArray, new Comparator<Position>(){

                @Override
                public int compare(Position o1, Position o2) {
                    return o2.getOffset() - o1.getOffset();
                }
            });
            String replaceTagName = TagUtil.getTagName((String)this._replacementString);
            String tag = "";
            Position[] positionArray2 = positionArray;
            int n = positionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Position pos = positionArray2[n2];
                try {
                    tag = document.get(pos.getOffset(), pos.getLength());
                    String tagName = TagUtil.getTagName((String)tag);
                    int startPrefixOffset = 1;
                    int closePrefixOffset = 2;
                    int replaceLength = 0;
                    if (StringUtil.isNotBlank((String)tagName)) {
                        replaceLength = tagName.length();
                    }
                    if (TagUtil.isEndTag((String)tag)) {
                        document.replace(pos.getOffset() + closePrefixOffset, replaceLength, replaceTagName);
                    } else if (TagUtil.isStartTag((String)tag)) {
                        document.replace(pos.getOffset() + startPrefixOffset, replaceLength, replaceTagName);
                    }
                }
                catch (BadLocationException badLocationException) {}
                ++n2;
            }
            return;
        }
        document.replace(offset, length, toReplace);
    }

    private boolean checkOffset(int offset, Collection<Position> positions) {
        boolean existOffset = false;
        if (positions.size() > 0) {
            for (Position pos : positions) {
                if (!pos.includes(offset) || offset == pos.getOffset()) continue;
                existOffset = true;
            }
        }
        return existOffset;
    }

    public HTMLElementProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo) {
        super(replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo);
        this.setIsHTML(true);
    }
}

