/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.contentassist;

import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.contentassist.CommonCompletionProposal;
import com.aptana.editor.common.viewer.CommonProjectionViewer;
import com.pandora.core.auth.UserAuth;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class HTMLCommentProposal
extends CommonCompletionProposal {
    public static final String CURSOR_PLACE_HOLDER = "$cursor$";
    int selectOffset = 0;
    private String template = null;

    public HTMLCommentProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo, String template) {
        super(replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo);
        this.setIsHTML(true);
        this.template = template;
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        String commentTemplate = this.template;
        String input = this.computeInput(viewer, offset);
        boolean needNewLine = this.isHasOtherWord(viewer, offset - input.length());
        String prefix = this.computePrefixWhite(viewer, offset - input.length());
        StringBuffer sb = new StringBuffer();
        if (needNewLine) {
            sb.append("\r\n");
            sb.append(prefix);
        }
        String autor = UserAuth.getUsername() == null ? Platform.getPlatformAdmin().toString() : UserAuth.getUsername();
        String createDate = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
        String comment = MessageFormat.format(commentTemplate, prefix, autor, createDate);
        this.selectOffset = comment.indexOf(CURSOR_PLACE_HOLDER);
        if (this.selectOffset >= 0) {
            comment = comment.replace(CURSOR_PLACE_HOLDER, "");
        }
        sb.append(comment);
        this._replacementLength = input.length();
        this._replacementString = sb.toString();
        if (needNewLine) {
            offset -= input.length();
            this.selectOffset = this.selectOffset + prefix.length() + 2;
        }
        super.apply(viewer, trigger, stateMask, offset);
    }

    private String computeInput(ITextViewer viewer, int offset) {
        try {
            int line = viewer.getDocument().getLineOfOffset(offset);
            int lineOffset = viewer.getDocument().getLineOffset(line);
            String prefix = viewer.getDocument().get(lineOffset, offset - lineOffset);
            return prefix.substring(prefix.lastIndexOf("<"));
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return "<";
        }
    }

    private String computePrefixWhite(ITextViewer viewer, int offset) {
        try {
            int line = viewer.getDocument().getLineOfOffset(offset);
            int lineOffset = viewer.getDocument().getLineOffset(line);
            String prefix = viewer.getDocument().get(lineOffset, offset - lineOffset);
            char[] charArr = prefix.toCharArray();
            StringBuffer sb = new StringBuffer();
            char[] cArray = charArr;
            int n = charArr.length;
            int n2 = 0;
            while (n2 < n) {
                char word = cArray[n2];
                if (word == '\t') {
                    sb.append(this.getTabSpace(viewer));
                } else {
                    sb.append(" ");
                }
                ++n2;
            }
            return sb.toString();
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return "";
        }
    }

    private String getTabSpace(ITextViewer viewer) {
        if (viewer instanceof CommonProjectionViewer) {
            CommonProjectionViewer projectionViewer = (CommonProjectionViewer)viewer;
            AbstractThemeableEditor editor = (AbstractThemeableEditor)projectionViewer.getAdapter(AbstractThemeableEditor.class);
            try {
                IPreferenceStore store = (IPreferenceStore)editor.getClass().getMethod("getChainedPreferenceStore", new Class[0]).invoke((Object)editor, new Object[0]);
                int size = store.getDefaultInt("tabWidth");
                StringBuffer tabStr = new StringBuffer();
                int i = 0;
                while (i < size) {
                    tabStr.append(" ");
                    ++i;
                }
                return tabStr.toString();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return "    ";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isHasOtherWord(ITextViewer viewer, int offset) {
        try {
            char[] charArr;
            int line = viewer.getDocument().getLineOfOffset(offset);
            int lineOffset = viewer.getDocument().getLineOffset(line);
            String prefix = viewer.getDocument().get(lineOffset, offset - lineOffset);
            char[] cArray = charArr = prefix.toCharArray();
            int n = charArr.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                char word = cArray[n2];
                if (word != ' ' && word != '\t') {
                    return true;
                }
                ++n2;
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return false;
    }

    public Point getSelection(IDocument document) {
        return new Point(this._replacementOffset + this.selectOffset, 0);
    }
}

