/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.actions;

import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.css.CSSSourceEditor;
import com.aptana.editor.html.HTMLEditor;
import com.aptana.editor.js.JSSourceEditor;
import com.aptana.ui.util.UIUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;

public class JSMultiCommentCommandHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        AbstractThemeableEditor editor;
        ISelection selection;
        IEditorPart activeEditor = UIUtils.getActiveEditor();
        if (activeEditor instanceof AbstractThemeableEditor && (selection = (editor = (AbstractThemeableEditor)activeEditor).getSelectionProvider().getSelection()) instanceof ITextSelection) {
            String type_;
            ITypedRegion typeRegion_;
            ITypedRegion typeRegion;
            IDocument document;
            ITextSelection textSelection;
            block21: {
                textSelection = (ITextSelection)selection;
                document = editor.getDocument();
                int offset = textSelection.getOffset();
                typeRegion = document.getPartition(offset);
                typeRegion_ = null;
                type_ = "";
                if (offset > 0 && (typeRegion_ = document.getPartition(offset - 1)) != null) {
                    type_ = typeRegion_.getType();
                }
                if (typeRegion != null) break block21;
                return null;
            }
            try {
                String type = typeRegion.getType();
                int startOffset = textSelection.getOffset();
                int length = textSelection.getLength();
                String content = textSelection.getText();
                String multiCommentStart = "/*";
                String multiCommentend = "*/";
                String cType = type;
                if (StringUtil.isNotBlank((String)type_) && !type_.startsWith("__html_")) {
                    cType = type_;
                }
                if (StringUtil.isNotBlank((String)type) && !type.startsWith("__html_")) {
                    cType = type;
                }
                String commentType = "";
                if (cType.startsWith("__html_")) {
                    multiCommentStart = "<!--";
                    multiCommentend = "-->";
                    commentType = "__html_comment";
                } else if (cType.startsWith("__svg_")) {
                    multiCommentStart = "<!--";
                    multiCommentend = "-->";
                    commentType = "__svg_comment";
                } else if (cType.startsWith("__js_")) {
                    commentType = "__js_multiline_comment";
                } else if (cType.startsWith("__css_")) {
                    commentType = "__css_multiline_comment";
                } else if (cType.startsWith("__php_")) {
                    commentType = "__php_multiline_comment";
                }
                boolean isComment = false;
                if (StringUtil.isNotBlank((String)type) && type.equals(commentType)) {
                    startOffset = typeRegion.getOffset();
                    length = typeRegion.getLength();
                    content = document.get(startOffset, length);
                    content = content.replace(multiCommentStart, "");
                    content = content.replace(multiCommentend, "");
                    isComment = true;
                } else if (StringUtil.isNotBlank((String)type_) && type_.equals(commentType)) {
                    startOffset = typeRegion_.getOffset();
                    length = typeRegion_.getLength();
                    content = document.get(startOffset, length);
                    content = content.replace(multiCommentStart, "");
                    content = content.replace(multiCommentend, "");
                    isComment = true;
                } else {
                    content = String.valueOf(multiCommentStart) + content + multiCommentend;
                }
                document.replace(startOffset, length, content);
                int slength = startOffset + content.length();
                if (!isComment && textSelection.getLength() == 0) {
                    slength = startOffset + multiCommentStart.length();
                }
                TextSelection s = new TextSelection(document, slength, 0);
                editor.getSelectionProvider().setSelection((ISelection)s);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public boolean isEnabled() {
        IEditorPart activeEditor = UIUtils.getActiveEditor();
        if (activeEditor instanceof JSSourceEditor || activeEditor instanceof HTMLEditor || activeEditor instanceof CSSSourceEditor) {
            this.setEnabled(true);
            return true;
        }
        this.setEnabled(false);
        return false;
    }
}

