/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html;

import com.aptana.core.CorePlugin;
import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.ExtendedFastPartitioner;
import com.aptana.editor.common.IExtendedPartitioner;
import com.aptana.editor.common.IPartitionerSwitchStrategy;
import com.aptana.editor.common.NullPartitionerSwitchStrategy;
import com.aptana.editor.common.TextUtils;
import com.aptana.editor.common.scripting.snippets.SnippetType;
import com.aptana.editor.common.text.rules.CompositePartitionScanner;
import com.aptana.editor.common.text.rules.ExtendedToken;
import com.aptana.editor.common.text.rules.ISubPartitionScanner;
import com.aptana.editor.common.text.rules.NullSubPartitionScanner;
import com.aptana.editor.common.text.rules.PartitionerSwitchingIgnoreRule;
import com.aptana.editor.common.text.rules.TagRule;
import com.aptana.editor.common.text.rules.ThemeingDamagerRepairer;
import com.aptana.editor.css.CSSSourceConfiguration;
import com.aptana.editor.html.HTMLSourceConfiguration;
import com.aptana.editor.html.HTMLSubPartitionScanner;
import com.aptana.editor.html.contentassist.HTMLContentAssistProcessor;
import com.aptana.editor.js.JSCodeScanner;
import com.aptana.editor.js.JSSourceConfiguration;
import com.aptana.editor.js.contentassist.JSContentAssistProcessor;
import com.aptana.editor.js.contentassist.JSXLocationTypeException;
import com.aptana.editor.js.contentassist.LocationType;
import com.aptana.editor.js.parsing.ast.JSErrorNode;
import com.aptana.editor.js.parsing.ast.JSXAttributeNode;
import com.aptana.editor.svg.SVGSourceConfiguration;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.lexer.IRange;
import com.aptana.parsing.lexer.Range;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.source.ISourceViewer;

public class NViewSourceConfiguration
extends HTMLSourceConfiguration {
    public static final String HTML_NVIEW_TEMPLATE = "__html_nview_template";
    protected static final String[] CONTENT_TYPES = new String[]{"__html__dftl_partition_content_type", "__html_comment", "__html_cdata", "__html_script", "__html_style", "__html_tag", "__html_tag_close", "__html_nview_template"};
    private static NViewSourceConfiguration instance;
    private IPredicateRule[] partitioningRules = new IPredicateRule[]{new MultiLineRule("<template>", "</template>", NViewSourceConfiguration.getToken("__html_nview_template")), new PartitionerSwitchingIgnoreRule((IPredicateRule)new MultiLineRule("<!--", "-->", NViewSourceConfiguration.getToken("__html_comment"), '\u0000', true)), new TagRule("script", (IToken)new ExtendedToken(NViewSourceConfiguration.getToken("__html_script")), true), new TagRule("/", NViewSourceConfiguration.getToken("__html_tag_close")), new TagRule((IToken)new ExtendedToken(NViewSourceConfiguration.getToken("__html_tag")))};

    public static synchronized NViewSourceConfiguration getDefault() {
        if (instance == null) {
            instance = new NViewSourceConfiguration();
        }
        return instance;
    }

    @Override
    public ISubPartitionScanner createSubPartitionScanner() {
        return new HTMLSubPartitionScanner(this, CONTENT_TYPES);
    }

    @Override
    public IContentAssistProcessor getContentAssistProcessor(AbstractThemeableEditor editor, String contentType) {
        if (HTML_NVIEW_TEMPLATE.equals(contentType)) {
            return new HTMLContentAssistProcessor(editor){

                @Override
                protected ICompletionProposal[] doComputeCompletionProposals(ITextViewer viewer, int offset, char activationChar, boolean autoActivated) {
                    block3: {
                        IDocument document = viewer.getDocument();
                        try {
                            ITypedRegion region = document.getPartition(offset);
                            JSContentAssistProcessor processor = new JSContentAssistProcessor(this.editor){

                                protected boolean isSupportjsx() {
                                    return false;
                                }

                                protected LocationType getLocationType(IDocument document, int offset) {
                                    LocationType location = super.getLocationType(document, offset);
                                    if (location == LocationType.JSX || location == LocationType.UNKNOWN) {
                                        throw new JSXLocationTypeException();
                                    }
                                    return location;
                                }

                                protected IParseNode getActiveASTNode(int offset) {
                                    IParseNode result = super.getActiveASTNode(offset);
                                    if (result == null || result instanceof JSErrorNode || result.getParent() instanceof JSXAttributeNode) {
                                        throw new JSXLocationTypeException();
                                    }
                                    return result;
                                }
                            };
                            processor.setActiveRange((IRange)new Range(region.getOffset(), region.getOffset() + region.getLength() - 1));
                            ICompletionProposal[] proposals = processor.computeCompletionProposals(viewer, offset, activationChar, autoActivated);
                            if (proposals != null && proposals.length > 0) {
                                return proposals;
                            }
                        }
                        catch (Exception e) {
                            if (!(e instanceof JSXLocationTypeException)) break block3;
                            return super.doComputeCompletionProposals(viewer, offset, activationChar, autoActivated);
                        }
                    }
                    return null;
                }

                @Override
                protected IDocument getDocument(ITextViewer viewer) {
                    IDocument nview = super.getDocument(viewer);
                    try {
                        Document html = new Document(nview.get());
                        CompositePartitionScanner partitionScanner = new CompositePartitionScanner(NViewSourceConfiguration.super.createSubPartitionScanner(), (ISubPartitionScanner)new NullSubPartitionScanner(), (IPartitionerSwitchStrategy)new NullPartitionerSwitchStrategy());
                        ExtendedFastPartitioner partitioner = new ExtendedFastPartitioner((IPartitionTokenScanner)partitionScanner, NViewSourceConfiguration.super.getContentTypes());
                        partitionScanner.setPartitioner((IExtendedPartitioner)partitioner);
                        partitioner.connect((IDocument)html);
                        html.setDocumentPartitioner((IDocumentPartitioner)partitioner);
                        return html;
                    }
                    catch (Exception e) {
                        IdeLog.logError((Plugin)CorePlugin.getDefault(), (Throwable)e);
                        return nview;
                    }
                }

                @Override
                public SnippetType getSnippetType() {
                    return new SnippetType(SnippetType.Type.NO_TYPE);
                }
            };
        }
        return super.getContentAssistProcessor(editor, contentType);
    }

    @Override
    public IPredicateRule[] getPartitioningRules() {
        return this.partitioningRules;
    }

    @Override
    public String[] getContentTypes() {
        return TextUtils.combine((String[][])new String[][]{CONTENT_TYPES, JSSourceConfiguration.CONTENT_TYPES, CSSSourceConfiguration.CONTENT_TYPES, SVGSourceConfiguration.CONTENT_TYPES});
    }

    @Override
    public void setupPresentationReconciler(PresentationReconciler reconciler, ISourceViewer sourceViewer) {
        super.setupPresentationReconciler(reconciler, sourceViewer);
        ThemeingDamagerRepairer dr = new ThemeingDamagerRepairer(this.getJSXScanner()){

            public IRegion getDamageRegion(ITypedRegion partition, DocumentEvent e, boolean documentPartitioningChanged) {
                int start = Math.max(0, partition.getOffset());
                int end = Math.min(this.fDocument.getLength(), partition.getOffset() + partition.getLength());
                return new Region(start, end - start);
            }
        };
        reconciler.setDamager((IPresentationDamager)dr, HTML_NVIEW_TEMPLATE);
        reconciler.setRepairer((IPresentationRepairer)dr, HTML_NVIEW_TEMPLATE);
    }

    private ITokenScanner getJSXScanner() {
        return new JSCodeScanner();
    }

    public static /* bridge */ /* synthetic */ HTMLSourceConfiguration getDefault() {
        return NViewSourceConfiguration.getDefault();
    }
}

