/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html;

import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.CommonUtil;
import com.aptana.editor.common.contentassist.CompletionProposalType;
import com.aptana.editor.common.contentassist.StringValueCompletionProposal;
import com.aptana.editor.html.HTMLPlugin;
import com.aptana.editor.html.contentassist.HTMLIndexQueryHelper;
import com.aptana.index.core.Index;
import com.aptana.parsing.lexer.IRange;
import com.aptana.parsing.lexer.Range;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.swt.graphics.Image;

public class HTMLTemplatePartitionUtils {
    public static Image JS_PROPERTY = null;

    public static IDocument getDocument(String contents) {
        Document doc = new Document(contents);
        RuleBasedPartitionScanner ruleScanner = new RuleBasedPartitionScanner();
        ruleScanner.setPredicateRules(new IPredicateRule[]{new SingleLineRule("{{", "}}", CommonUtil.getToken((String)"__html_template"))});
        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)ruleScanner, new String[]{"__html_template"});
        partitioner.connect((IDocument)doc);
        doc.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        return doc;
    }

    protected static StringBuilder getPrefix(int offset, IDocument document) {
        StringBuilder prefix = new StringBuilder();
        int currentOffset = offset - 1;
        while (currentOffset >= 0) {
            try {
                char c = document.getChar(currentOffset);
                if (!Character.isJavaIdentifierPart(c)) break;
                prefix.append(c);
            }
            catch (BadLocationException badLocationException) {
                break;
            }
            --currentOffset;
        }
        return prefix;
    }

    private static void processWordText(String text, Set<String> results, String prefixStr) {
        int index = 0;
        StringBuilder sBuilder = new StringBuilder();
        do {
            char c;
            if (Character.isJavaIdentifierPart(c = text.charAt(index))) {
                sBuilder.append(c);
                continue;
            }
            String string = sBuilder.toString();
            if (StringUtil.isNotEmpty((String)string) && Character.isJavaIdentifierStart(string.charAt(0)) && sBuilder.toString().startsWith(prefixStr) && !sBuilder.toString().equals(prefixStr)) {
                results.add(sBuilder.toString());
            }
            sBuilder.delete(0, sBuilder.length());
        } while (++index < text.length());
    }

    public static ICompletionProposal[] doComputeCompletionProposals(Index index, IDocument document, int offset, char activationChar, boolean autoActivated) {
        HashSet<String> resultStr = new HashSet<String>();
        HashSet<StringValueCompletionProposal> results = new HashSet<StringValueCompletionProposal>();
        StringBuilder prefix = HTMLTemplatePartitionUtils.getPrefix(offset, document);
        String prefixStr = prefix.reverse().toString();
        HTMLTemplatePartitionUtils.getTemplateStrings(document, resultStr, prefixStr);
        Map<String, String> tpls = new HTMLIndexQueryHelper().getTplStrs(index);
        for (String tpl : tpls.keySet()) {
            if (!tpl.startsWith(prefixStr) || tpl.equals(prefixStr)) continue;
            resultStr.add(tpl);
        }
        Range replaceRange = new Range(offset - prefixStr.length(), offset - 1);
        for (String str : resultStr) {
            StringValueCompletionProposal proposal = new StringValueCompletionProposal(str, (IRange)replaceRange, HTMLTemplatePartitionUtils.getTemplateImage(), null);
            proposal.setIsItalics(true);
            proposal.setCompletionProposalType(CompletionProposalType.NUMBER);
            results.add(proposal);
        }
        return results.toArray(new ICompletionProposal[results.size()]);
    }

    private static Image getTemplateImage() {
        if (JS_PROPERTY == null) {
            JS_PROPERTY = HTMLPlugin.imageDescriptorFromPlugin((String)"com.aptana.editor.js", (String)"/icons/assistant/js_property.png").createImage();
        }
        return JS_PROPERTY;
    }

    public static void getTemplateStrings(IDocument document, Set<String> resultStr, String prefixStr) {
        try {
            ITypedRegion region = document.getPartition(0);
            while (region != null) {
                String type = region.getType();
                if ("__html_template".equals(type)) {
                    String text = document.get(region.getOffset(), region.getLength());
                    HTMLTemplatePartitionUtils.processWordText(text, resultStr, prefixStr);
                }
                region = document.getPartition(region.getOffset() + region.getLength() + 1);
            }
        }
        catch (BadLocationException badLocationException) {}
    }
}

