/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html;

import com.aptana.editor.common.text.rules.BreakingMultiLineRule;
import com.aptana.editor.common.text.rules.CharacterMapRule;
import com.aptana.editor.common.text.rules.ExtendedWordRule;
import com.aptana.editor.common.text.rules.MultiCharacterRule;
import com.aptana.editor.common.text.rules.QueuedRuleBasedScanner;
import com.aptana.editor.common.text.rules.WhitespaceDetector;
import com.aptana.editor.css.CSSCodeScannerFlex;
import com.aptana.editor.html.internal.text.rules.AttributeNameWordDetector;
import com.aptana.editor.html.internal.text.rules.BrokenStringRule;
import com.aptana.editor.html.internal.text.rules.TagNameWordDetector;
import com.aptana.editor.html.internal.text.rules.TagWordRule;
import com.aptana.editor.html.parsing.HTMLUtils;
import com.aptana.editor.html.parsing.lexer.HTMLTokenType;
import com.aptana.editor.js.JSCodeScanner;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;

public class HTMLTagScanner
extends QueuedRuleBasedScanner {
    private static final String[] STRUCTURE_DOT_ANY;
    private static final String[] BLOCK_DOT_ANY;
    private static final String[] TAG_INLINE_ANY;
    private static final String[] NEW_H5_TAG;
    private static Set<String> HTML5Tags;
    private static final String[] QUOTED_STRING_BREAKS;
    private static final IToken doubleQuotedStringToken;
    private static final IToken singleQuotedStringToken;
    private static final IToken attributeStyleToken;
    private static final IToken attributeScriptToken;
    private static final IToken equalToken;
    private static final IToken undefinedToken;
    private ITokenScanner cssTokenScanner = new CSSCodeScannerFlex(true);
    private ITokenScanner jsTokenScanner = new JSCodeScanner();
    private Stack<IToken> tokenHistory = new Stack();
    private String tagName;
    private boolean hasTokens;
    private boolean rescanNestedLanguages;

    static {
        String tag;
        STRUCTURE_DOT_ANY = new String[]{"html", "head", "body", "header", "address", "nav", "section", "article", "footer", "aside", "hgroup", "h1", "h2", "h3", "h4", "h5", "h6", "template"};
        BLOCK_DOT_ANY = new String[]{"blockquote", "dd", "div", "dl", "dt", "fieldset", "form", "frame", "frameset", "iframe", "noframes", "object", "ol", "p", "ul", "applet", "center", "dir", "hr", "menu", "pre"};
        TAG_INLINE_ANY = new String[]{"a", "abbr", "acronym", "area", "b", "base", "basefont", "bdo", "big", "br", "button", "caption", "cite", "code", "col", "colgroup", "del", "dfn", "em", "font", "i", "img", "input", "ins", "isindex", "kbd", "label", "legend", "li", "link", "map", "meta", "noscript", "optgroup", "option", "param", "q", "s", "samp", "script", "select", "small", "span", "strike", "strong", "style", "sub", "sup", "table", "tbody", "td", "textarea", "tfoot", "th", "thead", "title", "tr", "tt", "u", "var", "canvas", "audio", "video", "picture"};
        NEW_H5_TAG = new String[]{"embed", "bdi", "bgsound", "blink", "clipPath", "command", "comment", "datalist", "details", "dialog", "figcaption", "figure", "ilayer", "keygen", "layer", "mark", "marquee", "math", "meter", "nobr", "noembed", "output", "progress", "rp", "rt", "ruby", "source", "summary", "svg", "time", "track", "wbr", "xml", "xmp"};
        HTML5Tags = new HashSet<String>();
        String[] stringArray = STRUCTURE_DOT_ANY;
        int n = STRUCTURE_DOT_ANY.length;
        int n2 = 0;
        while (n2 < n) {
            tag = stringArray[n2];
            HTML5Tags.add(tag);
            ++n2;
        }
        stringArray = BLOCK_DOT_ANY;
        n = BLOCK_DOT_ANY.length;
        n2 = 0;
        while (n2 < n) {
            tag = stringArray[n2];
            HTML5Tags.add(tag);
            ++n2;
        }
        stringArray = TAG_INLINE_ANY;
        n = TAG_INLINE_ANY.length;
        n2 = 0;
        while (n2 < n) {
            tag = stringArray[n2];
            HTML5Tags.add(tag);
            ++n2;
        }
        stringArray = NEW_H5_TAG;
        n = NEW_H5_TAG.length;
        n2 = 0;
        while (n2 < n) {
            tag = stringArray[n2];
            HTML5Tags.add(tag);
            ++n2;
        }
        QUOTED_STRING_BREAKS = new String[]{"/>", ">"};
        doubleQuotedStringToken = new Token((Object)HTMLTokenType.DOUBLE_QUOTED_STRING.getScope());
        singleQuotedStringToken = new Token((Object)HTMLTokenType.SINGLE_QUOTED_STRING.getScope());
        attributeStyleToken = new Token((Object)HTMLTokenType.ATTR_STYLE.getScope());
        attributeScriptToken = new Token((Object)HTMLTokenType.ATTR_SCRIPT.getScope());
        equalToken = new Token((Object)HTMLTokenType.EQUAL.getScope());
        undefinedToken = new Token((Object)HTMLTokenType.UNDEFINED.getScope());
    }

    public HTMLTagScanner() {
        this(true);
    }

    public HTMLTagScanner(boolean rescanNestedLanguges) {
        this.rescanNestedLanguages = rescanNestedLanguges;
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new MultiLineRule("\"", "\"", doubleQuotedStringToken, '\\'));
        rules.add(new BreakingMultiLineRule("\"", "\"", QUOTED_STRING_BREAKS, doubleQuotedStringToken, '\\'));
        rules.add(new MultiLineRule("'", "'", singleQuotedStringToken, '\\'));
        rules.add(new BreakingMultiLineRule("'", "'", QUOTED_STRING_BREAKS, singleQuotedStringToken, '\\'));
        rules.add(new WhitespaceRule((IWhitespaceDetector)new WhitespaceDetector()));
        final IToken newH5Token = this.createToken(HTMLTokenType.NEW_H5_TAG);
        TagWordRule tagWordRule = new TagWordRule(new TagNameWordDetector(), this.createToken(HTMLTokenType.META), true){

            protected IToken getWordToken(String word) {
                HTMLTagScanner.this.tagName = word;
                if (HTML5Tags.contains(word)) {
                    return null;
                }
                return newH5Token;
            }
        };
        tagWordRule.addWord("script", this.createToken(HTMLTokenType.SCRIPT));
        tagWordRule.addWord("style", this.createToken(HTMLTokenType.STYLE));
        IToken structureDotAnyToken = this.createToken(HTMLTokenType.STRUCTURE_TAG);
        String[] stringArray = STRUCTURE_DOT_ANY;
        int n = STRUCTURE_DOT_ANY.length;
        int n2 = 0;
        while (n2 < n) {
            String tag = stringArray[n2];
            tagWordRule.addWord(tag, structureDotAnyToken);
            ++n2;
        }
        IToken blockDotAnyToken = this.createToken(HTMLTokenType.BLOCK_TAG);
        String[] stringArray2 = BLOCK_DOT_ANY;
        int n3 = BLOCK_DOT_ANY.length;
        n = 0;
        while (n < n3) {
            String tag = stringArray2[n];
            tagWordRule.addWord(tag, blockDotAnyToken);
            ++n;
        }
        IToken inlineAnyToken = this.createToken(HTMLTokenType.INLINE_TAG);
        String[] stringArray3 = TAG_INLINE_ANY;
        int n4 = TAG_INLINE_ANY.length;
        n3 = 0;
        while (n3 < n4) {
            String tag = stringArray3[n3];
            tagWordRule.addWord(tag, inlineAnyToken);
            ++n3;
        }
        stringArray3 = NEW_H5_TAG;
        n4 = NEW_H5_TAG.length;
        n3 = 0;
        while (n3 < n4) {
            String tag = stringArray3[n3];
            tagWordRule.addWord(tag, newH5Token);
            ++n3;
        }
        rules.add((Object)tagWordRule);
        ExtendedWordRule attributeWordRule = new ExtendedWordRule(new AttributeNameWordDetector(), this.createToken(HTMLTokenType.ATTRIBUTE), true){

            protected IToken getWordToken(String word) {
                return HTMLUtils.isJSAttribute(HTMLTagScanner.this.tagName, word) ? attributeScriptToken : null;
            }
        };
        attributeWordRule.addWord("id", this.createToken(HTMLTokenType.ATTR_ID));
        attributeWordRule.addWord("class", this.createToken(HTMLTokenType.ATTR_CLASS));
        attributeWordRule.addWord("style", attributeStyleToken);
        rules.add(attributeWordRule);
        rules.add(new MultiCharacterRule("</", this.createToken(HTMLTokenType.TAG_START)));
        rules.add(new MultiCharacterRule("/>", this.createToken(HTMLTokenType.TAG_SELF_CLOSE)));
        CharacterMapRule charsRule = new CharacterMapRule();
        charsRule.add('<', this.createToken(HTMLTokenType.TAG_START));
        charsRule.add('>', this.createToken(HTMLTokenType.TAG_END));
        charsRule.add('=', equalToken);
        rules.add(charsRule);
        this.setRules(rules.toArray(new IRule[rules.size()]));
        this.setDefaultReturnToken(this.createToken(HTMLTokenType.TEXT));
    }

    public void setRange(IDocument document, int offset, int length) {
        super.setRange(document, offset, length);
        this.tokenHistory.clear();
        this.tagName = null;
        this.hasTokens = false;
    }

    public IToken nextToken() {
        IToken token;
        if (!this.hasTokens) {
            this.hasTokens = true;
            token = this.findBrokenToken();
            if (!token.isUndefined()) {
                return token;
            }
        }
        token = super.nextToken();
        if (this.rescanNestedLanguages && (doubleQuotedStringToken == token || singleQuotedStringToken == token)) {
            IToken attributeToken = this.getAttributeToken();
            ITokenScanner tokenScanner = null;
            if (attributeScriptToken == attributeToken) {
                tokenScanner = this.jsTokenScanner;
            } else if (attributeStyleToken == attributeToken) {
                tokenScanner = this.cssTokenScanner;
            }
            this.tokenHistory.clear();
            int offset = this.getTokenOffset();
            int length = this.getTokenLength() - 2;
            if (tokenScanner != null && length > 0) {
                this.queueToken(token, offset, 1);
                this.queueDelegate(tokenScanner, offset + 1, length);
                this.queueToken(token, offset + length + 1, 1);
                return super.nextToken();
            }
        }
        if (!token.isWhitespace()) {
            this.tokenHistory.push(token);
        }
        return token;
    }

    private IToken findBrokenToken() {
        this.fTokenOffset = this.fOffset;
        this.fColumn = -1;
        return new BrokenStringRule(singleQuotedStringToken, doubleQuotedStringToken).evaluate((ICharacterScanner)this);
    }

    private IToken getAttributeToken() {
        if (this.tokenHistory.size() < 2 || equalToken != this.tokenHistory.pop()) {
            return null;
        }
        return this.tokenHistory.pop();
    }

    protected IToken createToken(HTMLTokenType type) {
        return this.createToken(type.getScope());
    }

    protected IToken createToken(String string) {
        return new Token((Object)string);
    }
}

