/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html;

import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.ISourceViewerConfiguration;
import com.aptana.editor.common.SimpleSourceViewerConfiguration;
import com.aptana.editor.common.TextUtils;
import com.aptana.editor.css.CSSPlugin;
import com.aptana.editor.css.CSSSourceConfiguration;
import com.aptana.editor.css.text.CSSAutoIndentStrategy;
import com.aptana.editor.html.HTMLDoubleClickStrategy;
import com.aptana.editor.html.HTMLPlugin;
import com.aptana.editor.html.HTMLSourceConfiguration;
import com.aptana.editor.html.ext.HTMLScriptQuickAssistProcessor;
import com.aptana.editor.html.text.HTMLAutoIndentStrategy;
import com.aptana.editor.html.text.HTMLScriptRootNodeAware;
import com.aptana.editor.js.JSPlugin;
import com.aptana.editor.js.JSSourceConfiguration;
import com.aptana.editor.js.text.IJSRootNodeAware;
import com.aptana.editor.js.text.JSAutoIndentStrategy;
import com.aptana.editor.svg.SVGSourceConfiguration;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.quickassist.IQuickAssistAssistant;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.quickassist.QuickAssistAssistant;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.widgets.Shell;

public class HTMLSourceViewerConfiguration
extends SimpleSourceViewerConfiguration {
    private HTMLDoubleClickStrategy fDoubleClickStrategy;

    public HTMLSourceViewerConfiguration(IPreferenceStore preferences, AbstractThemeableEditor editor) {
        super(preferences, editor);
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return TextUtils.combine((String[][])new String[][]{{"__dftl_partition_content_type"}, HTMLSourceConfiguration.CONTENT_TYPES, JSSourceConfiguration.CONTENT_TYPES, CSSSourceConfiguration.CONTENT_TYPES, SVGSourceConfiguration.CONTENT_TYPES});
    }

    protected Map getHyperlinkDetectorTargets(ISourceViewer sourceViewer) {
        Map targets = super.getHyperlinkDetectorTargets(sourceViewer);
        targets.put("com.aptana.editor.html", this.getEditor());
        return targets;
    }

    public ISourceViewerConfiguration getSourceViewerConfiguration() {
        return HTMLSourceConfiguration.getDefault();
    }

    public IQuickAssistAssistant getQuickAssistAssistant(ISourceViewer sourceViewer) {
        QuickAssistAssistant assistant = new QuickAssistAssistant();
        assistant.setInformationControlCreator(new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                DefaultInformationControl control = new DefaultInformationControl(parent);
                return control;
            }
        });
        HTMLScriptQuickAssistProcessor processor = new HTMLScriptQuickAssistProcessor();
        assistant.setQuickAssistProcessor((IQuickAssistProcessor)processor);
        return assistant;
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        if (contentType.startsWith("__js_")) {
            JSAutoIndentStrategy autoIntent = new JSAutoIndentStrategy(contentType, (SourceViewerConfiguration)this, sourceViewer, JSPlugin.getDefault().getPreferenceStore());
            autoIntent.setRootNodeAware((IJSRootNodeAware)new HTMLScriptRootNodeAware());
            return new IAutoEditStrategy[]{autoIntent};
        }
        if (contentType.startsWith("__css_")) {
            return new IAutoEditStrategy[]{new CSSAutoIndentStrategy(contentType, (SourceViewerConfiguration)this, sourceViewer, CSSPlugin.getDefault().getPreferenceStore())};
        }
        contentType.startsWith("__svg_");
        return new IAutoEditStrategy[]{new HTMLAutoIndentStrategy(contentType, (SourceViewerConfiguration)this, sourceViewer, HTMLPlugin.getDefault().getPreferenceStore())};
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (this.fDoubleClickStrategy == null) {
            this.fDoubleClickStrategy = new HTMLDoubleClickStrategy();
        }
        return this.fDoubleClickStrategy;
    }
}

