/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html;

import com.aptana.buildpath.core.BuildPathEntry;
import com.aptana.buildpath.core.BuildPathManager;
import com.aptana.buildpath.core.IBuildPathListener;
import com.aptana.core.logging.IdeLog;
import com.aptana.editor.html.HTMLDocumentProvider;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.osgi.framework.BundleContext;

public class HTMLPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.aptana.editor.html";
    private static HTMLPlugin plugin;
    private IDocumentProvider htmlDocumentProvider;
    IBuildPathListener fBuildPathListener = new IBuildPathListener(){

        public void buildPathChanged(IProject project, Collection<BuildPathEntry> newEntries, Collection<BuildPathEntry> oldEntries) {
            if (project == null || newEntries == null) {
                return;
            }
            boolean addVuejsCapability = false;
            for (BuildPathEntry entry : newEntries) {
                if (entry.getDisplayName().indexOf("vue") == -1) continue;
                addVuejsCapability = true;
                break;
            }
            try {
                project.setPersistentProperty(new QualifiedName(HTMLPlugin.PLUGIN_ID, "vue"), String.valueOf(addVuejsCapability));
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (Throwable)e);
            }
        }
    };

    public static HTMLPlugin getDefault() {
        return plugin;
    }

    public static Image getImage(String path) {
        ImageDescriptor id;
        ImageRegistry registry = plugin.getImageRegistry();
        Image image = registry.get(path);
        if (image == null && (id = HTMLPlugin.getImageDescriptor(path)) != null) {
            registry.put(path, id);
            image = registry.get(path);
        }
        return image;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        BuildPathManager.getInstance().addBuildPathListener(this.fBuildPathListener);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public synchronized IDocumentProvider getHTMLDocumentProvider() {
        if (this.htmlDocumentProvider == null) {
            this.htmlDocumentProvider = new HTMLDocumentProvider();
        }
        return this.htmlDocumentProvider;
    }
}

