/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.contentassist.MetadataLoader;
import com.aptana.editor.html.HTMLPlugin;
import com.aptana.editor.html.Messages;
import com.aptana.editor.html.contentassist.index.HTMLIndexWriter;
import com.aptana.editor.html.contentassist.index.HTMLMetadataReader;
import com.aptana.editor.html.contentassist.model.AttributeElement;
import com.aptana.editor.html.contentassist.model.ElementElement;
import com.aptana.editor.html.contentassist.model.EntityElement;
import com.aptana.editor.html.contentassist.model.EventElement;
import com.aptana.index.core.Index;
import com.aptana.index.core.IndexManager;
import com.aptana.index.core.IndexPlugin;
import java.io.IOException;
import java.net.URI;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.Bundle;

public class HTMLMetadataLoader
extends MetadataLoader<HTMLMetadataReader> {
    public HTMLMetadataLoader() {
        super(Messages.HTMLMetadataLoader_Loading_Metadata);
    }

    protected HTMLMetadataReader createMetadataReader() {
        return new HTMLMetadataReader();
    }

    protected Bundle getBundle() {
        return HTMLPlugin.getDefault().getBundle();
    }

    protected String getIndexVersionKey() {
        return "HTML_INDEX_VERSION";
    }

    protected String[] getMetadataFiles() {
        return new String[]{"/metadata/html_metadata.xml"};
    }

    protected String getPluginId() {
        return "com.aptana.editor.html";
    }

    protected void writeIndex(HTMLMetadataReader reader) {
        this.getIndexManager().removeIndex(this.getIndexLocation());
        HTMLIndexWriter indexer = new HTMLIndexWriter();
        Index index = this.getIndex();
        for (ElementElement element : reader.getElements()) {
            indexer.writeElement(index, element);
        }
        for (AttributeElement attribute : reader.getAttributes()) {
            indexer.writeAttribute(index, attribute);
        }
        for (EventElement event : reader.getEvents()) {
            indexer.writeEvent(index, event);
        }
        for (EntityElement entity : reader.getEntities()) {
            indexer.writeEntity(index, entity);
        }
        try {
            index.save();
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (Throwable)e);
        }
    }

    protected URI getIndexLocation() {
        return URI.create("metadata:/html");
    }

    protected IndexManager getIndexManager() {
        return IndexPlugin.getDefault().getIndexManager();
    }

    protected Index getIndex() {
        return this.getIndexManager().getIndex(this.getIndexLocation());
    }

    protected void loadIndexCacher() {
    }
}

