/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html;

import com.aptana.core.util.URLEncoder;
import com.aptana.editor.common.IEditorLinkedResources;
import com.aptana.index.core.Index;
import com.aptana.index.core.IndexManager;
import com.aptana.index.core.IndexPlugin;
import com.aptana.index.core.QueryResult;
import java.net.URI;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;

public class HTMLEditorLinkedResources
implements IEditorLinkedResources {
    private final IEditorPart editorPart;

    public HTMLEditorLinkedResources(IEditorPart editorPart) {
        this.editorPart = editorPart;
    }

    public boolean hasReference(URI uri) {
        IEditorInput targetEditorInput = this.editorPart.getEditorInput();
        if (targetEditorInput instanceof IFileEditorInput) {
            IFile htmlFile = ((IFileEditorInput)targetEditorInput).getFile();
            Index index = this.getIndexManager().getIndex(htmlFile.getProject().getLocationURI());
            List queryResults = index.query(new String[]{"html.resource.css", "html.resource.js"}, null, 0);
            if (queryResults != null) {
                String includedFileToCheck = uri.toString();
                String htmlFileToCheck = URLEncoder.encode((String)htmlFile.getLocation().toPortableString(), null, null);
                for (QueryResult result : queryResults) {
                    String includedFile = result.getWord();
                    if (!includedFileToCheck.equals(includedFile)) continue;
                    Set documents = result.getDocuments();
                    for (String document : documents) {
                        if (!document.endsWith(htmlFileToCheck)) continue;
                        return true;
                    }
                    return false;
                }
            }
        }
        return false;
    }

    protected IndexManager getIndexManager() {
        return IndexPlugin.getDefault().getIndexManager();
    }
}

