/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.IEditorLinkedResources;
import com.aptana.editor.common.outline.CommonOutlinePage;
import com.aptana.editor.common.text.reconciler.IFoldingComputer;
import com.aptana.editor.html.HTMLEditorLinkedResources;
import com.aptana.editor.html.HTMLFoldingComputer;
import com.aptana.editor.html.HTMLOpenDeclarationAction;
import com.aptana.editor.html.HTMLOpenTagCloser;
import com.aptana.editor.html.HTMLPlugin;
import com.aptana.editor.html.HTMLSourceViewerConfiguration;
import com.aptana.editor.html.HTMLTagScanner;
import com.aptana.editor.html.Messages;
import com.aptana.editor.html.contentassist.HTMLContentAssistProcessor;
import com.aptana.editor.html.contentassist.LocationType;
import com.aptana.editor.html.outline.HTMLOutlineContentProvider;
import com.aptana.editor.html.outline.HTMLOutlineLabelProvider;
import com.aptana.editor.html.parsing.HTMLParseRootNode;
import com.aptana.editor.html.parsing.ast.HTMLCommentNode;
import com.aptana.editor.html.parsing.ast.HTMLElementNode;
import com.aptana.editor.html.parsing.ast.HTMLSpecialNode;
import com.aptana.editor.html.parsing.ast.HTMLTextNode;
import com.aptana.editor.html.parsing.lexer.HTMLLexemeProvider;
import com.aptana.editor.html.parsing.lexer.HTMLTokenType;
import com.aptana.editor.xml.TagUtil;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.parsing.lexer.Lexeme;
import com.aptana.ui.util.UIUtils;
import com.pandora.view.browser.views.BrowserComposite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.osgi.internal.profile.Profile;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class HTMLEditor
extends AbstractThemeableEditor {
    public static final char[] HTML_PAIR_MATCHING_CHARS = new char[]{'(', ')', '{', '}', '[', ']', '`', '`', '\'', '\'', '\"', '\"', '<', '>', '\u201c', '\u201d', '\u2018', '\u2019'};
    private boolean profile = Profile.STARTUP;
    private Map<Annotation, Position> fTagPairOccurrences;
    private Job hightLightJob;
    private Job highlightSelectNodeJob;
    public static Collection<String> tagPartitions = new ArrayList<String>();
    private IEclipsePreferences.IPreferenceChangeListener fPreferenceListener = new IEclipsePreferences.IPreferenceChangeListener(){

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if ("HTML_OUTLINE_TAG_ATTRIBUTES".equals(event.getKey())) {
                HTMLEditor.this.getOutlinePage().refresh();
            }
        }
    };

    static {
        tagPartitions.add("__html_tag");
        tagPartitions.add("__html_tag_close");
        tagPartitions.add("__html_script");
        tagPartitions.add("__html_style");
    }

    public Map<Annotation, Position> getfTagPairOccurrences() {
        return this.fTagPairOccurrences;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (this.profile) {
            Profile.logEnter((String)"hbuilder.HTMLEditor.init");
        }
        super.init(site, input);
        if (this.profile) {
            Profile.logTime((String)"hbuilder.HTMLEditor.init", (String)"super");
        }
        if (this.profile) {
            Profile.logExit((String)"hbuilder.HTMLEditor.init");
        }
    }

    protected void initializeEditor() {
        if (this.profile) {
            Profile.logEnter((String)"hbuilder.HTMLEditor.initializeEditor");
        }
        super.initializeEditor();
        this.setPreferenceStore(HTMLEditor.getChainedPreferenceStore());
        this.initializeSourceViewer();
        if (this.profile) {
            Profile.logExit((String)"hbuilder.HTMLEditor.initializeEditor");
        }
    }

    protected void initializeSourceViewer() {
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new HTMLSourceViewerConfiguration(this.getPreferenceStore(), this));
        this.setDocumentProvider(HTMLPlugin.getDefault().getHTMLDocumentProvider());
    }

    public void dispose() {
        try {
            EclipseUtil.instanceScope().getNode("com.aptana.editor.html").removePreferenceChangeListener(this.fPreferenceListener);
            this.fPreferenceListener = null;
            if (this.hightLightJob != null) {
                this.hightLightJob.cancel();
                this.hightLightJob = null;
            }
        }
        finally {
            super.dispose();
        }
    }

    public void doSave(IProgressMonitor progressMonitor) {
        super.doSave(progressMonitor);
    }

    public static IPreferenceStore getChainedPreferenceStore() {
        return new ChainedPreferenceStore(new IPreferenceStore[]{HTMLPlugin.getDefault().getPreferenceStore(), CommonEditorPlugin.getDefault().getPreferenceStore(), EditorsPlugin.getDefault().getPreferenceStore()});
    }

    protected CommonOutlinePage createOutlinePage() {
        if (this.profile) {
            Profile.logEnter((String)"hbuilder.HTMLEditor.createOutlinePage");
        }
        CommonOutlinePage outlinePage = super.createOutlinePage();
        EclipseUtil.instanceScope().getNode("com.aptana.editor.html").addPreferenceChangeListener(this.fPreferenceListener);
        if (this.profile) {
            Profile.logExit((String)"hbuilder.HTMLEditor.createOutlinePage");
        }
        return outlinePage;
    }

    public String getContentType() {
        return "com.aptana.contenttype.html";
    }

    public char[] getPairMatchingCharacters() {
        return HTML_PAIR_MATCHING_CHARS;
    }

    public ITreeContentProvider getOutlineContentProvider() {
        return new HTMLOutlineContentProvider(this);
    }

    public ILabelProvider getOutlineLabelProvider() {
        return new HTMLOutlineLabelProvider();
    }

    public void createPartControl(Composite parent) {
        if (this.profile) {
            Profile.logEnter((String)"hbuilder.HTMLEditor.createPartControl");
        }
        super.createPartControl(parent);
        this.installOpenTagCloser();
        if (this.profile) {
            Profile.logExit((String)"hbuilder.HTMLEditor.createPartControl");
        }
    }

    protected void installOpenTagCloser() {
        new HTMLOpenTagCloser((ITextViewer)this.getSourceViewer()).install();
    }

    protected IPreferenceStore getOutlinePreferenceStore() {
        return HTMLPlugin.getDefault().getPreferenceStore();
    }

    protected void selectionChanged() {
        super.selectionChanged();
        if (this.hightLightJob != null) {
            this.hightLightJob.cancel();
        }
        this.hightLightJob = new Job("Computing highlight node to select..."){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    UIUtils.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ISelectionProvider selectionProvider = HTMLEditor.this.getSelectionProvider();
                            if (selectionProvider == null) {
                                return;
                            }
                            ISelection selection = selectionProvider.getSelection();
                            if (selection.isEmpty()) {
                                return;
                            }
                            ITextSelection textSelection = (ITextSelection)selection;
                            int offset = textSelection.getOffset();
                            HTMLEditor.this.highlightTagPair(offset);
                        }
                    });
                }
                catch (Throwable e) {
                    IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        EclipseUtil.setSystemForJob((Job)this.hightLightJob);
        this.hightLightJob.schedule();
    }

    protected IPreferenceStore getPluginPreferenceStore() {
        return HTMLPlugin.getDefault().getPreferenceStore();
    }

    private void highlightTagPair(int offset) {
        IDocumentProvider documentProvider = this.getDocumentProvider();
        if (documentProvider == null) {
            return;
        }
        IAnnotationModel annotationModel = documentProvider.getAnnotationModel((Object)this.getEditorInput());
        if (annotationModel == null) {
            return;
        }
        if (this.fTagPairOccurrences != null) {
            for (Position pos : this.fTagPairOccurrences.values()) {
                if (!pos.includes(offset)) continue;
                return;
            }
            for (Annotation a : this.fTagPairOccurrences.keySet()) {
                annotationModel.removeAnnotation(a);
            }
            this.fTagPairOccurrences = null;
        }
        HashMap<Annotation, Position> occurrences = new HashMap<Annotation, Position>();
        IDocument document = this.getSourceViewer().getDocument();
        IRegion match = TagUtil.findMatchingTag((IDocument)document, (int)offset, tagPartitions);
        if (match != null) {
            occurrences.put(new Annotation("com.aptana.html.tagPair.occurrences", false, null), new Position(match.getOffset(), match.getLength()));
            try {
                ITypedRegion partition = document.getPartition(offset);
                occurrences.put(new Annotation("com.aptana.html.tagPair.occurrences", false, null), new Position(partition.getOffset(), partition.getLength()));
            }
            catch (BadLocationException e) {
                IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (Throwable)e);
            }
            this.fTagPairOccurrences = occurrences;
            for (Map.Entry entry : occurrences.entrySet()) {
                annotationModel.addAnnotation((Annotation)entry.getKey(), (Position)entry.getValue());
            }
        } else {
            this.fTagPairOccurrences = null;
        }
    }

    public IFoldingComputer createFoldingComputer(IDocument document) {
        if (this.profile) {
            Profile.logEnter((String)"hbuilder.HTMLEditor.createFoldingComputer");
        }
        HTMLFoldingComputer r = new HTMLFoldingComputer(this, document);
        if (this.profile) {
            Profile.logExit((String)"hbuilder.HTMLEditor.createFoldingComputer");
        }
        return r;
    }

    public Object getAdapter(Class adapter) {
        if (IEditorLinkedResources.class == adapter) {
            return new HTMLEditorLinkedResources((IEditorPart)this);
        }
        return super.getAdapter(adapter);
    }

    protected void createActions() {
        if (this.profile) {
            Profile.logEnter((String)"hbuilder.HTMLEditor.createActions");
        }
        super.createActions();
        if (this.profile) {
            Profile.logTime((String)"hbuilder.HTMLEditor.createActions", (String)"super");
        }
        HTMLOpenDeclarationAction action = new HTMLOpenDeclarationAction(Messages.getResourceBundle(), (ITextEditor)this);
        action.setActionDefinitionId("com.aptana.editor.js.openDeclaration");
        this.setAction("com.aptana.editor.js.openDeclaration", (IAction)action);
        if (this.profile) {
            Profile.logExit((String)"hbuilder.HTMLEditor.createActions");
        }
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        IAction action = this.getAction("com.aptana.editor.js.openDeclaration");
        if (action != null) {
            menu.appendToGroup("group.open", action);
        }
    }

    public void highlightSelectNode(final BrowserComposite browserComposite) {
        if (browserComposite == null || !browserComposite.isDevToolsDialogOpened()) {
            return;
        }
        if (this.highlightSelectNodeJob != null) {
            this.highlightSelectNodeJob.cancel();
        }
        this.highlightSelectNodeJob = new Job("highlight select node in browser..."){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    IParseRootNode parseRootNode = HTMLEditor.this.getAST();
                    final int[] offset = new int[]{-1};
                    UIUtils.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            offset[0] = HTMLEditor.this.getCaretOffset();
                        }
                    });
                    if (offset[0] < 0) {
                        return Status.CANCEL_STATUS;
                    }
                    IParseNode node = parseRootNode.getNodeAtOffset(offset[0]);
                    if (node instanceof HTMLTextNode || node instanceof HTMLCommentNode) {
                        node = node.getParent();
                    }
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    if (node instanceof HTMLElementNode && !(node instanceof HTMLSpecialNode)) {
                        IParseNode parent = node.getParent();
                        StringBuilder sb = new StringBuilder(((HTMLElementNode)node).getName());
                        int count = this.getCount(node);
                        if (count > 0) {
                            sb.append(":nth-of-type(").append(count).append(")");
                        }
                        while (parent != null && !(parent instanceof HTMLParseRootNode)) {
                            if (monitor.isCanceled()) {
                                return Status.CANCEL_STATUS;
                            }
                            if (parent instanceof HTMLElementNode) {
                                int num = this.getCount(parent);
                                sb.insert(0, ">");
                                if (num > 0) {
                                    sb.insert(0, ")").insert(0, num).insert(0, ":nth-of-type(");
                                }
                            } else {
                                if (parent instanceof HTMLParseRootNode) break;
                                sb.setLength(0);
                                break;
                            }
                            sb.insert(0, ((HTMLElementNode)parent).getName());
                            parent = parent.getParent();
                        }
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        if (sb.length() > 0) {
                            browserComposite.highlight(sb.toString());
                        }
                    }
                }
                catch (Throwable e) {
                    IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (Throwable)e);
                }
                return Status.OK_STATUS;
            }

            private int getCount(IParseNode node) {
                IParseNode[] brothers;
                if (node.getParent().getChildCount() <= 1 || node.getParent() instanceof HTMLParseRootNode || !(node.getParent() instanceof HTMLElementNode)) {
                    return 0;
                }
                int num = 1;
                IParseNode[] iParseNodeArray = brothers = node.getParent().getChildren();
                int n = brothers.length;
                int n2 = 0;
                while (n2 < n) {
                    IParseNode brother = iParseNodeArray[n2];
                    if (brother == node) break;
                    if (brother.getClass() == node.getClass() && brother.getElementName().equalsIgnoreCase(node.getElementName())) {
                        ++num;
                    }
                    ++n2;
                }
                return num <= 1 ? 0 : num;
            }
        };
        EclipseUtil.setSystemForJob((Job)this.highlightSelectNodeJob);
        this.highlightSelectNodeJob.schedule();
    }

    public boolean isEnableTransformChinesePunctuation(int offset, char character) {
        block11: {
            String type;
            block9: {
                LocationType result;
                ITypedRegion region;
                IDocument document;
                block10: {
                    block8: {
                        block7: {
                            if (this.getPreferenceStore().getBoolean("CHINESE_PUNCTUATION_AUTO_TRANSFER")) break block7;
                            return false;
                        }
                        document = this.getDocument();
                        region = document.getPartition(offset);
                        type = region.getType();
                        if (!"__html_comment".equals(type) && !"__html_php".equals(type) && !"__html_sp".equals(type) && !"__html_template".equals(type) && !"__js_sdoc_comment".equals(type) && !"__js_multiline_comment".equals(type) && !"__js_singleline_comment".equals(type) && !"__js_string_double".equals(type) && !"__js_string_single".equals(type) && !"__js_regexp".equals(type) && !"__css_multiline_comment".equals(type) && !"__css_string_double".equals(type) && !"__css_string_single".equals(type)) break block8;
                        return false;
                    }
                    if (!"__html_tag".equals(type) && !"__html_script".equals(type) && !"__html_style".equals(type) && !"__html_doctype".equals(type)) break block9;
                    result = this.getLocationType(offset, document, region, true);
                    if (result != LocationType.IN_ATTRIBUTE_VALUE) break block10;
                    return false;
                }
                result = this.getLocationType(offset, document, region, false);
                if (character == '\u300a' || result != LocationType.IN_TEXT) break block9;
                return false;
            }
            try {
                if (!"__html__dftl_partition_content_type".equals(type) && !"__html_tag_close".equals(type)) break block11;
                if (character == '\u300a') {
                    HTMLContentAssistProcessor.IS_CHINESE_CHARACTER = true;
                    break block11;
                }
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public LocationType getLocationType(int offset, IDocument document, ITypedRegion partition, boolean isTag) {
        LocationType result;
        block19: {
            block21: {
                HTMLLexemeProvider lexemeProvider;
                block20: {
                    int documentLength = document.getLength();
                    int lexemeProviderOffset = offset >= documentLength ? documentLength - 1 : offset;
                    lexemeProvider = new HTMLLexemeProvider(document, lexemeProviderOffset, (ITokenScanner)new HTMLTagScanner(false));
                    result = LocationType.ERROR;
                    if (!isTag) break block20;
                    int index = lexemeProvider.getLexemeIndex(offset);
                    if (index < 0) {
                        int candidateIndex = lexemeProvider.getLexemeFloorIndex(offset);
                        Lexeme lexeme = lexemeProvider.getLexeme(candidateIndex);
                        if (lexeme != null && lexeme.getEndingOffset() == offset - 1) {
                            index = candidateIndex;
                        } else {
                            result = LocationType.IN_ATTRIBUTE_NAME;
                        }
                    }
                    while (index >= 0) {
                        Lexeme lexeme = lexemeProvider.getLexeme(index);
                        switch ((HTMLTokenType)((Object)lexeme.getType())) {
                            case DOUBLE_QUOTED_STRING: 
                            case SINGLE_QUOTED_STRING: {
                                if (lexeme.getEndingOffset() < offset && lexeme.getLength() > 1) {
                                    int lastChar;
                                    String text = lexeme.getText();
                                    int n = lastChar = StringUtil.isEmpty((String)text) ? 0 : (int)text.charAt(text.length() - 1);
                                    if (lastChar == 34 || lastChar == 39) {
                                        result = LocationType.IN_ATTRIBUTE_NAME;
                                        break;
                                    }
                                    result = LocationType.IN_ATTRIBUTE_VALUE;
                                    break;
                                }
                                result = LocationType.IN_ATTRIBUTE_VALUE;
                                break;
                            }
                        }
                        if (result == LocationType.ERROR) {
                            --index;
                            continue;
                        }
                        break block19;
                    }
                    break block19;
                }
                String type = partition.getType();
                result = HTMLContentAssistProcessor.locationMap.get(type);
                if (("__html_script".equals(type) || "__html_style".equals(type)) && partition.getOffset() + partition.getLength() == offset) {
                    LocationType locationType = result = "__html_script".equals(type) ? LocationType.IN_SCRIPT : LocationType.IN_STYLE;
                }
                if (result.equals((Object)LocationType.IN_STYLE) || result.equals((Object)LocationType.IN_SCRIPT)) {
                    return result;
                }
                Lexeme firstLexeme = lexemeProvider.getFirstLexeme();
                if (firstLexeme == null) break block21;
                Lexeme lastLexeme = lexemeProvider.getLastLexeme();
                HTMLTokenType lastLexemeType = (HTMLTokenType)((Object)lastLexeme.getType());
                switch (result) {
                    case IN_OPEN_TAG: 
                    case IN_CLOSE_TAG: {
                        if (offset <= firstLexeme.getStartingOffset()) {
                            result = LocationType.IN_TEXT;
                            break;
                        }
                        if (lastLexeme.getEndingOffset() < offset && (lastLexemeType == HTMLTokenType.TAG_END || lastLexemeType == HTMLTokenType.TAG_SELF_CLOSE)) {
                            result = LocationType.IN_TEXT;
                            break;
                        }
                        break block19;
                    }
                    case IN_TEXT: {
                        if (firstLexeme.getType() == HTMLTokenType.TAG_START && lastLexemeType == HTMLTokenType.META && lastLexeme.getText().equalsIgnoreCase("DOCTYPE")) {
                            result = LocationType.IN_DOCTYPE;
                            break;
                        }
                        break block19;
                    }
                }
                break block19;
            }
            result = LocationType.IN_TEXT;
        }
        return result;
    }

    public char[] getChinesePunctuationCharacters() {
        return super.getChinesePunctuationCharacters();
    }
}

