/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html;

import com.aptana.core.CorePlugin;
import com.aptana.core.IFilter;
import com.aptana.core.logging.IdeLog;
import com.aptana.editor.html.contentassist.HTMLIndexQueryHelper;
import com.aptana.editor.html.contentassist.model.AttributeElement;
import com.aptana.editor.html.parsing.HTMLParseRootNode;
import com.aptana.editor.html.parsing.ast.HTMLElementNode;
import com.aptana.editor.html.parsing.ast.HTMLSpecialNode;
import com.aptana.editor.html.parsing.ast.HTMLTextNode;
import com.aptana.parsing.ParseResult;
import com.aptana.parsing.ParserPoolFactory;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseNodeAttribute;
import com.aptana.parsing.util.ParseUtil;
import com.pandora.core.appstream.ASTParseManager;
import com.pandora.core.appstream.AbstractNestedASTParser;
import com.pandora.core.appstream.HTMLElementValue;
import com.pandora.core.appstream.IASTParser;
import com.pandora.core.appstream.IValue;
import com.pandora.core.appstream.RelationTree;
import com.pandora.core.appstream.StringValue;
import com.pandora.core.utils.CollectionsUtil;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.swt.graphics.Point;

public class HTMLASTParser
extends AbstractNestedASTParser
implements IASTParser {
    HTMLIndexQueryHelper queryHelper = new HTMLIndexQueryHelper();

    public boolean processAST(final IFile file, final RelationTree tree, final IProject project, Set<URI> visitedUris) {
        try {
            ParseResult pResult = ParserPoolFactory.parse((String)"com.aptana.contenttype.html", (String)IOUtils.toString((InputStream)file.getContents(true), (String)file.getCharset()));
            if (pResult != null && pResult.getRootNode() != null) {
                HTMLParseRootNode rootNode = (HTMLParseRootNode)pResult.getRootNode();
                ParseUtil.treeApply((IParseNode)rootNode, (IFilter)new IFilter<IParseNode>(){

                    public boolean include(IParseNode item) {
                        IParseNode child;
                        if (item instanceof HTMLSpecialNode && (child = item.getChild(0)) != null) {
                            IASTParser nestedParser = ASTParseManager.getParser((String)child.getLanguage());
                            if (nestedParser != null && nestedParser instanceof AbstractNestedASTParser) {
                                AbstractNestedASTParser nParser = (AbstractNestedASTParser)nestedParser;
                                nParser.processNestedAST(file, (Object)child, tree, project);
                            }
                            return true;
                        }
                        if (item instanceof HTMLElementNode) {
                            IParseNodeAttribute[] attributes;
                            HTMLElementNode htmlNode = (HTMLElementNode)item;
                            String tagName = htmlNode.getElementName();
                            IParseNodeAttribute[] iParseNodeAttributeArray = attributes = htmlNode.getAttributes();
                            int n = attributes.length;
                            int n2 = 0;
                            while (n2 < n) {
                                StringValue value;
                                IParseNodeAttribute attr = iParseNodeAttributeArray[n2];
                                String attrName = attr.getName();
                                if (HTMLASTParser.this.isURIString(HTMLASTParser.this.queryHelper.getAttribute(tagName, attrName))) {
                                    value = new HTMLElementValue(tagName, attrName, attr.getValue());
                                    value.setRange(new Point(attr.getValueRange().getStartingOffset() + 1, attr.getValueRange().getEndingOffset() - 1));
                                    tree.addValue((IValue)value);
                                } else {
                                    value = new StringValue(attr.getValue());
                                    value.setRange(new Point(attr.getValueRange().getStartingOffset() + 1, attr.getValueRange().getEndingOffset() - 1));
                                    tree.addValue((IValue)value);
                                }
                                ++n2;
                            }
                        }
                        return true;
                    }
                }, (boolean)false);
            }
            return true;
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)CorePlugin.getDefault(), (Throwable)e);
            return false;
        }
    }

    protected boolean isURIString(AttributeElement attr) {
        if (attr == null) {
            return false;
        }
        String uriType = "MultimediaString";
        List<String> types = attr.getTypes();
        if (CollectionsUtil.isNotEmpty(types)) {
            if (types.contains(uriType)) {
                return true;
            }
            for (String type : types) {
                if (type == null || !type.endsWith("URIString")) continue;
                return true;
            }
        }
        return false;
    }

    public boolean processNestedAST(IFile file, Object astRoot, final RelationTree tree, IProject project) {
        if (astRoot instanceof HTMLTextNode) {
            HTMLTextNode textNode = (HTMLTextNode)((Object)astRoot);
            try {
                ParseResult result = ParserPoolFactory.parse((String)textNode.getLanguage(), (String)textNode.getText(), (int)textNode.getStartingOffset());
                if (result != null && result.getRootNode() != null) {
                    final HTMLParseRootNode rootNode = (HTMLParseRootNode)result.getRootNode();
                    ParseUtil.treeApply((IParseNode)rootNode, (IFilter)new IFilter<IParseNode>(){

                        public boolean include(IParseNode item) {
                            if (item instanceof HTMLElementNode) {
                                IParseNodeAttribute[] attributes;
                                HTMLElementNode htmlNode = (HTMLElementNode)item;
                                String tagName = htmlNode.getElementName();
                                IParseNodeAttribute[] iParseNodeAttributeArray = attributes = htmlNode.getAttributes();
                                int n = attributes.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    StringValue value;
                                    IParseNodeAttribute attr = iParseNodeAttributeArray[n2];
                                    String attrName = attr.getName();
                                    if (HTMLASTParser.this.isURIString(HTMLASTParser.this.queryHelper.getAttribute(tagName, attrName))) {
                                        value = new HTMLElementValue(tagName, attrName, attr.getValue());
                                        value.setRange(new Point(rootNode.getStartingOffset() + attr.getValueRange().getStartingOffset() + 1, rootNode.getStartingOffset() + attr.getValueRange().getEndingOffset() - 1));
                                        tree.addValue((IValue)value);
                                    } else {
                                        value = new StringValue(attr.getValue());
                                        value.setRange(new Point(rootNode.getStartingOffset() + attr.getValueRange().getStartingOffset() + 1, rootNode.getStartingOffset() + attr.getValueRange().getEndingOffset() - 1));
                                        tree.addValue((IValue)value);
                                    }
                                    ++n2;
                                }
                            }
                            return true;
                        }
                    }, (boolean)false);
                }
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)CorePlugin.getDefault(), (Throwable)e);
            }
        }
        return false;
    }
}

