/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.index.service;

import com.pandora.index.service.ILinkedBlockingQueueService;
import com.pandora.index.service.ILocalBuildService;
import com.pandora.index.service.ILocalIndexService;
import com.pandora.index.service.IRemoteBuildService;
import com.pandora.index.service.IRemoteIndexService;
import java.rmi.Naming;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class IndexServicePlugin
implements BundleActivator {
    private static BundleContext context;
    private static IndexServicePlugin plugin;
    ILocalIndexService localService;
    ILocalBuildService localBuildService;
    IRemoteIndexService remoteService;
    IRemoteBuildService remoteBuildService;
    ILinkedBlockingQueueService linkedBlockingQueueService;

    static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        plugin = this;
    }

    public void stop(BundleContext bundleContext) throws Exception {
        context = null;
    }

    public static IndexServicePlugin getDefault() {
        return plugin;
    }

    public ILocalIndexService getLocalIndexService(BundleActivator bundle) throws Exception {
        if (bundle != null) {
            Thread.currentThread().setContextClassLoader(bundle.getClass().getClassLoader());
        }
        if (this.localService == null) {
            this.localService = (ILocalIndexService)Naming.lookup("rmi://127.0.0.1:56789/index");
        }
        return this.localService;
    }

    public ILocalBuildService getLocalBuildService(BundleActivator bundle) throws Exception {
        if (bundle != null) {
            Thread.currentThread().setContextClassLoader(bundle.getClass().getClassLoader());
        }
        if (this.localBuildService == null) {
            this.localBuildService = (ILocalBuildService)Naming.lookup("rmi://127.0.0.1:56789/build");
        }
        return this.localBuildService;
    }

    public IRemoteIndexService getRemoteIndexService(BundleActivator bundle) throws Exception {
        if (bundle != null) {
            Thread.currentThread().setContextClassLoader(bundle.getClass().getClassLoader());
        }
        if (this.remoteService == null) {
            this.remoteService = (IRemoteIndexService)Naming.lookup("rmi://127.0.0.1:45678/index");
        }
        return this.remoteService;
    }

    public IRemoteBuildService getRemoteBuildService(BundleActivator bundle) throws Exception {
        if (bundle != null) {
            Thread.currentThread().setContextClassLoader(bundle.getClass().getClassLoader());
        }
        if (this.remoteBuildService == null) {
            this.remoteBuildService = (IRemoteBuildService)Naming.lookup("rmi://127.0.0.1:45678/build");
        }
        return this.remoteBuildService;
    }

    public ILinkedBlockingQueueService getLinkedBlockingQueueService() {
        return this.linkedBlockingQueueService;
    }

    public void setLinkedBlockingQueueService(ILinkedBlockingQueueService linkedBlockingQueueService) {
        this.linkedBlockingQueueService = linkedBlockingQueueService;
    }

    public void restartLocalService() {
        this.localBuildService = null;
        this.localService = null;
    }

    public void restartRemoteService() {
        this.remoteService = null;
        this.remoteBuildService = null;
    }
}

