/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.index.service;

import com.pandora.core.utils.IOUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class IndexRequest
implements Serializable {
    private static final long serialVersionUID = -285890583263763001L;
    private URI indexURI;
    private URI projectURI;
    private String charset;
    private boolean needSleep;
    private boolean reconcile;
    private boolean highPriority;
    private String contents;
    private long requestTime;
    private boolean isHBuilder;

    public boolean isHBuilder() {
        return this.isHBuilder;
    }

    public void setHBuilder(boolean isHBuilder) {
        this.isHBuilder = isHBuilder;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setIndexURI(URI indexURI) {
        this.indexURI = indexURI;
    }

    public void setProjectURI(URI projectURI) {
        this.projectURI = projectURI;
    }

    public void setNeedSleep(boolean needSleep) {
        this.needSleep = needSleep;
    }

    public void setContents(String contents) {
        this.contents = contents;
    }

    public void setReconcile(boolean reconcile) {
        this.reconcile = reconcile;
    }

    public void setRequestTime(long requestTime) {
        this.requestTime = requestTime;
    }

    public URI getIndexURI() {
        return this.indexURI;
    }

    public URI getProjectURI() {
        return this.projectURI;
    }

    public boolean isNeedSleep() {
        return this.needSleep;
    }

    public boolean isReconcile() {
        return this.reconcile;
    }

    public long getRequestTime() {
        return this.requestTime;
    }

    public String readContents() {
        if (this.contents != null) {
            return this.contents;
        }
        try {
            this.contents = IOUtil.read((InputStream)this.openInputStream((IProgressMonitor)new NullProgressMonitor()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.contents == null) {
            this.contents = "";
        }
        return this.contents;
    }

    public InputStream openInputStream(IProgressMonitor monitor) {
        try {
            if (this.isReconcile()) {
                if (this.contents == null || this.contents.isEmpty()) {
                    return new ByteArrayInputStream(new byte[0]);
                }
                return new ByteArrayInputStream(this.contents.getBytes(this.charset));
            }
            File file = new File(this.indexURI);
            if (!file.exists()) {
                return new ByteArrayInputStream(new byte[0]);
            }
            return new FileInputStream(file);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ByteArrayInputStream(new byte[0]);
        }
    }

    public boolean isHighPriority() {
        return this.highPriority;
    }

    public void setHighPriority(boolean highPriority) {
        this.highPriority = highPriority;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.charset == null ? 0 : this.charset.hashCode());
        result = 31 * result + (this.indexURI == null ? 0 : this.indexURI.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IndexRequest other = (IndexRequest)obj;
        if (this.charset == null ? other.charset != null : !this.charset.equals(other.charset)) {
            return false;
        }
        return !(this.indexURI == null ? other.indexURI != null : !this.indexURI.equals(other.indexURI));
    }
}

