/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.webserver.ui.internal.views;

import com.aptana.core.Identifiable;
import com.aptana.theme.ThemePlugin;
import com.aptana.ui.ImageAssociations;
import com.aptana.ui.util.UIUtils;
import com.aptana.webserver.core.IServer;
import com.aptana.webserver.core.IServerChangeListener;
import com.aptana.webserver.core.ServerChangeEvent;
import com.aptana.webserver.core.WebServerCorePlugin;
import com.aptana.webserver.ui.WebServerUIPlugin;
import com.aptana.webserver.ui.internal.views.Messages;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.services.IEvaluationService;

public class ServersView
extends ViewPart
implements IServerChangeListener {
    private TableViewer serverTableViewer;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        this.serverTableViewer = this.createServerTable(parent);
        this.getSite().setSelectionProvider((ISelectionProvider)this.serverTableViewer);
    }

    private TableViewer createServerTable(Composite parent) {
        TableViewer tableViewer = new TableViewer(parent, 65540);
        Table serverTable = tableViewer.getTable();
        serverTable.setHeaderVisible(true);
        serverTable.setLinesVisible(true);
        serverTable.setLayoutData((Object)new GridData(1808));
        TableColumn nameCol = new TableColumn(serverTable, 16384);
        nameCol.setText(Messages.ServersView_NAME);
        nameCol.setWidth(150);
        TableColumn statusCol = new TableColumn(serverTable, 16384);
        statusCol.setText(Messages.ServersView_STATUS);
        statusCol.setWidth(75);
        TableColumn typeColumn = new TableColumn(serverTable, 16384);
        typeColumn.setText(Messages.ServersView_TYPE);
        typeColumn.setWidth(125);
        TableColumn hostColumn = new TableColumn(serverTable, 16384);
        hostColumn.setText(Messages.GenericServersView_HOST);
        hostColumn.setWidth(150);
        TableColumn portColumn = new TableColumn(serverTable, 16384);
        portColumn.setText(Messages.GenericServersView_PORT);
        portColumn.setWidth(50);
        WebServerCorePlugin.getDefault().getServerManager().addServerChangeListener((IServerChangeListener)this);
        tableViewer.setLabelProvider((IBaseLabelProvider)new ServerLabelProvider());
        tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        tableViewer.setInput((Object)WebServerCorePlugin.getDefault().getServerManager().getServers());
        ThemePlugin.getDefault().getControlThemerFactory().apply((Viewer)tableViewer);
        return tableViewer;
    }

    public void dispose() {
        super.dispose();
        ThemePlugin.getDefault().getControlThemerFactory().dispose((Viewer)this.serverTableViewer);
    }

    public ISelection getSelection() {
        return this.serverTableViewer.getSelection();
    }

    public void setFocus() {
        this.serverTableViewer.getTable().setFocus();
    }

    public void configurationChanged(final ServerChangeEvent event) {
        Display display = UIUtils.getDisplay();
        if (!display.isDisposed()) {
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    switch (event.getKind()) {
                        case ADDED: {
                            ServersView.this.serverTableViewer.add((Object)event.getServer());
                            break;
                        }
                        case REMOVED: {
                            ServersView.this.serverTableViewer.remove((Object)event.getServer());
                        }
                        case UPDATED: {
                            ServersView.this.serverTableViewer.update((Object)event.getServer(), null);
                            IEvaluationService service = (IEvaluationService)ServersView.this.getViewSite().getService(IEvaluationService.class);
                            if (service == null) break;
                            service.requestEvaluation("selection");
                        }
                    }
                }
            });
        }
    }

    class ServerLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ServerLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                if (element instanceof Identifiable) {
                    Identifiable identifiable = (Identifiable)element;
                    String id = identifiable.getId();
                    Image img = WebServerUIPlugin.getDefault().getImageRegistry().get(id);
                    if (img != null) {
                        return img;
                    }
                    ImageDescriptor desc = ImageAssociations.getInstance().getImageDescriptor(id);
                    if (desc != null) {
                        WebServerUIPlugin.getDefault().getImageRegistry().put(id, desc);
                        return WebServerUIPlugin.getDefault().getImageRegistry().get(id);
                    }
                }
                return WebServerUIPlugin.getImage("icons/obj16/server.png");
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            IServer server = (IServer)element;
            switch (columnIndex) {
                case 0: {
                    return server.getName();
                }
                case 1: {
                    switch (server.getState()) {
                        case STARTED: {
                            return Messages.ServersView_STATUS_STARTED;
                        }
                        case STARTING: {
                            return Messages.ServersView_STATUS_STARTING;
                        }
                        case STOPPING: {
                            return Messages.ServersView_STATUS_STOPPING;
                        }
                        case STOPPED: {
                            return Messages.ServersView_STATUS_STOPPED;
                        }
                        case UNKNOWN: {
                            return Messages.ServersView_STATUS_UNKNOWN;
                        }
                        case NOT_APPLICABLE: {
                            return Messages.ServersView_STATUS_NOT_APPLICABLE;
                        }
                    }
                    return "";
                }
                case 2: {
                    return server.getType().getName();
                }
                case 3: {
                    return server.getHostname();
                }
                case 4: {
                    int port = server.getPort();
                    return port == -1 ? "?" : Integer.toString(port);
                }
            }
            return "";
        }
    }
}

