/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.webserver.ui.internal.actions;

import com.aptana.ui.IPropertyDialog;
import com.aptana.ui.PropertyDialogsRegistry;
import com.aptana.ui.util.UIUtils;
import com.aptana.webserver.core.IServer;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.handlers.HandlerUtil;

public class EditServerHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return null;
        }
        IServer server = (IServer)((IStructuredSelection)selection).getFirstElement();
        if (server != null) {
            EditServerHandler.editServerConfiguration(server);
        }
        return null;
    }

    static boolean editServerConfiguration(IServer server) {
        try {
            Dialog dlg = PropertyDialogsRegistry.getInstance().createPropertyDialog((Object)server, (IShellProvider)new SameShellProvider((Control)UIUtils.getActiveShell()));
            if (dlg != null) {
                if (dlg instanceof IPropertyDialog) {
                    ((IPropertyDialog)dlg).setPropertySource((Object)server);
                }
                return dlg.open() == 0;
            }
        }
        catch (CoreException e) {
            UIUtils.showErrorMessage((String)"Failed to open server preferences dialog", (Throwable)e);
        }
        return false;
    }
}

