/*
 * Decompiled with CFR 0.152.
 */
package net.contentobjects.jnotify.win32;

import java.util.Hashtable;
import net.contentobjects.jnotify.IJNotify;
import net.contentobjects.jnotify.JNotifyException;
import net.contentobjects.jnotify.JNotifyListener;
import net.contentobjects.jnotify.Util;
import net.contentobjects.jnotify.win32.IWin32NotifyListener;
import net.contentobjects.jnotify.win32.JNotify_win32;

public class JNotifyAdapterWin32
implements IJNotify {
    private Hashtable<Integer, WatchData> _id2Data;

    public JNotifyAdapterWin32() {
        JNotify_win32.setNotifyListener(new IWin32NotifyListener(){

            @Override
            public void notifyChange(int wd, int action, String rootPath, String filePath) {
                JNotifyAdapterWin32.this.notifyChangeEvent(wd, action, rootPath, filePath);
            }
        });
        this._id2Data = new Hashtable();
    }

    @Override
    public int addWatch(String path, int mask, boolean watchSubtree, JNotifyListener listener) throws JNotifyException {
        int wd = JNotify_win32.addWatch(path, 383L, watchSubtree);
        this._id2Data.put(wd, new WatchData(wd, mask, listener));
        return wd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeWatch(int wd) throws JNotifyException {
        Hashtable<Integer, WatchData> hashtable = this._id2Data;
        synchronized (hashtable) {
            block4: {
                if (!this._id2Data.containsKey(wd)) break block4;
                this._id2Data.remove(wd);
                JNotify_win32.removeWatch(wd);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyChangeEvent(int wd, int action, String rootPath, String filePath) {
        Hashtable<Integer, WatchData> hashtable = this._id2Data;
        synchronized (hashtable) {
            WatchData watchData = this._id2Data.get(wd);
            if (watchData != null) {
                int mask = watchData._mask;
                int mapped = this.mapAction(action);
                if (action == 1 && (mask & mapped) != 0) {
                    watchData._notifyListener.fileCreated(wd, rootPath, filePath);
                } else if (action == 3 && (mask & mapped) != 0) {
                    watchData._notifyListener.fileModified(wd, rootPath, filePath);
                } else if (action == 2 && (mask & mapped) != 0) {
                    watchData._notifyListener.fileDeleted(wd, rootPath, filePath);
                } else if (action == 4 && (mask & mapped) != 0) {
                    watchData.renameOldName = filePath;
                } else if (action == 5 && (mask & mapped) != 0) {
                    watchData._notifyListener.fileRenamed(wd, rootPath, watchData.renameOldName, filePath);
                    watchData.renameOldName = null;
                }
            }
        }
    }

    private int mapAction(int action) {
        switch (action) {
            case 1: {
                return 1;
            }
            case 3: {
                return 4;
            }
            case 2: {
                return 2;
            }
            case 5: {
                return 8;
            }
            case 4: {
                return 8;
            }
        }
        return -1;
    }

    private static class WatchData {
        int _wd;
        int _mask;
        JNotifyListener _notifyListener;
        public String renameOldName;

        WatchData(int wd, int mask, JNotifyListener listener) {
            this._wd = wd;
            this._mask = mask;
            this._notifyListener = listener;
        }

        public String toString() {
            return "wd=" + this._wd + ", action " + Util.getMaskDesc(this._mask);
        }
    }
}

