/*
 * Decompiled with CFR 0.152.
 */
package net.contentobjects.jnotify.macosx;

import net.contentobjects.jnotify.JNotifyException;
import net.contentobjects.jnotify.macosx.FSEventListener;

public class JNotify_macosx {
    private static Object initCondition = new Object();
    private static Object countLock = new Object();
    private static int watches = 0;
    private static FSEventListener _eventListener;

    static {
        System.loadLibrary("jnotify");
        Thread thread = new Thread("FSEvent thread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                JNotify_macosx.nativeInit();
                Object object = initCondition;
                synchronized (object) {
                    initCondition.notifyAll();
                    initCondition = null;
                }
                while (true) {
                    object = countLock;
                    synchronized (object) {
                        while (watches == 0) {
                            try {
                                countLock.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                    JNotify_macosx.nativeNotifyLoop();
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    private static native void nativeInit();

    private static native int nativeAddWatch(String var0) throws JNotifyException;

    private static native boolean nativeRemoveWatch(int var0);

    private static native void nativeNotifyLoop();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int addWatch(String path) throws JNotifyException {
        Object myCondition = initCondition;
        if (myCondition != null) {
            Object object = myCondition;
            synchronized (object) {
                while (initCondition != null) {
                    try {
                        initCondition.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        int wd = JNotify_macosx.nativeAddWatch(path);
        Object object = countLock;
        synchronized (object) {
            ++watches;
            countLock.notifyAll();
            return wd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeWatch(int wd) {
        boolean removed = JNotify_macosx.nativeRemoveWatch(wd);
        if (removed) {
            Object object = countLock;
            synchronized (object) {
                --watches;
            }
        }
        return removed;
    }

    public static void callbackProcessEvent(int wd, String rootPath, String filePath, boolean recurse) {
        if (_eventListener != null) {
            _eventListener.notifyChange(wd, rootPath, filePath, recurse);
        }
    }

    public static void callbackInBatch(int wd, boolean state) {
        if (_eventListener != null) {
            if (state) {
                _eventListener.batchStart(wd);
            } else {
                _eventListener.batchEnd(wd);
            }
        }
    }

    public static void setNotifyListener(FSEventListener eventListener) {
        if (_eventListener != null) {
            throw new RuntimeException("Notify listener is already set. multiple notify listeners are not supported.");
        }
        _eventListener = eventListener;
    }
}

