/*
 * Decompiled with CFR 0.152.
 */
package net.contentobjects.jnotify.linux;

import net.contentobjects.jnotify.JNotifyException;
import net.contentobjects.jnotify.linux.INotifyListener;
import net.contentobjects.jnotify.linux.JNotifyException_linux;

public class JNotify_linux {
    static final boolean DEBUG = false;
    public static boolean WARN = true;
    public static final int IN_ACCESS = 1;
    public static final int IN_MODIFY = 2;
    public static final int IN_ATTRIB = 4;
    public static final int IN_CLOSE_WRITE = 8;
    public static final int IN_CLOSE_NOWRITE = 16;
    public static final int IN_OPEN = 32;
    public static final int IN_MOVED_FROM = 64;
    public static final int IN_MOVED_TO = 128;
    public static final int IN_CREATE = 256;
    public static final int IN_DELETE = 512;
    public static final int IN_DELETE_SELF = 1024;
    public static final int IN_MOVE_SELF = 2048;
    public static final int IN_UNMOUNT = 8192;
    public static final int IN_Q_OVERFLOW = 16384;
    public static final int IN_IGNORED = 32768;
    public static final int IN_CLOSE = 24;
    public static final int IN_MOVE = 192;
    public static final int IN_ISDIR = 0x40000000;
    public static final int IN_ONESHOT = Integer.MIN_VALUE;
    public static final int IN_ALL_EVENT = 2047;
    private static INotifyListener _notifyListener;

    static {
        System.loadLibrary("jnotify");
        int res = JNotify_linux.nativeInit();
        if (res != 0) {
            throw new RuntimeException("Error initializing fshook_inotify library. linux error code #" + res + ", man errno for more info");
        }
        JNotify_linux.init();
    }

    private static native int nativeInit();

    private static native int nativeAddWatch(String var0, int var1);

    private static native int nativeRemoveWatch(int var0);

    private static native int nativeNotifyLoop();

    private static native String getErrorDesc(long var0);

    public static int addWatch(String path, int mask) throws JNotifyException {
        int wd = JNotify_linux.nativeAddWatch(path, mask);
        if (wd < 0) {
            throw new JNotifyException_linux("Error watching " + path + " : " + JNotify_linux.getErrorDesc(-wd), -wd);
        }
        JNotify_linux.debug(String.valueOf(wd) + " = JNotify_linux.addWatch(" + path + "," + JNotify_linux.getMaskDesc(mask) + ")");
        return wd;
    }

    public static void removeWatch(int wd) throws JNotifyException {
        int ret = JNotify_linux.nativeRemoveWatch(wd);
        JNotify_linux.debug(String.valueOf(ret) + " = JNotify_linux.removeWatch(" + wd + ")");
        if (ret != 0) {
            throw new JNotifyException_linux("Error removing watch " + wd, ret);
        }
    }

    private static void init() {
        Thread thread = new Thread("INotify thread"){

            @Override
            public void run() {
                JNotify_linux.nativeNotifyLoop();
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    static void callbackProcessEvent(String name, int wd, int mask, int cookie) {
        JNotify_linux.debug("JNotify.event(name=" + name + ", wd=" + wd + ", " + JNotify_linux.getMaskDesc(mask) + (cookie != 0 ? ", cookie=" + cookie : "") + ")");
        if (_notifyListener != null) {
            _notifyListener.notify(name, wd, mask, cookie);
        }
    }

    public static void setNotifyListener(INotifyListener notifyListener) {
        if (_notifyListener != null) {
            throw new RuntimeException("Notify listener is already set. multiple notify listeners are not supported.");
        }
        _notifyListener = notifyListener;
    }

    private static String getMaskDesc(int linuxMask) {
        boolean lIN_ACCESS = (linuxMask & 1) != 0;
        boolean lIN_MODIFY = (linuxMask & 2) != 0;
        boolean lIN_ATTRIB = (linuxMask & 4) != 0;
        boolean lIN_CLOSE_WRITE = (linuxMask & 8) != 0;
        boolean lIN_CLOSE_NOWRITE = (linuxMask & 0x10) != 0;
        boolean lIN_OPEN = (linuxMask & 0x20) != 0;
        boolean lIN_MOVED_FROM = (linuxMask & 0x40) != 0;
        boolean lIN_MOVED_TO = (linuxMask & 0x80) != 0;
        boolean lIN_CREATE = (linuxMask & 0x100) != 0;
        boolean lIN_DELETE = (linuxMask & 0x200) != 0;
        boolean lIN_DELETE_SELF = (linuxMask & 0x400) != 0;
        boolean lIN_MOVE_SELF = (linuxMask & 0x800) != 0;
        boolean lIN_UNMOUNT = (linuxMask & 0x2000) != 0;
        boolean lIN_Q_OVERFLOW = (linuxMask & 0x4000) != 0;
        boolean lIN_IGNORED = (linuxMask & 0x8000) != 0;
        String s = "";
        if (lIN_ACCESS) {
            s = String.valueOf(s) + "IN_ACCESS|";
        }
        if (lIN_MODIFY) {
            s = String.valueOf(s) + "IN_MODIFY|";
        }
        if (lIN_ATTRIB) {
            s = String.valueOf(s) + "IN_ATTRIB|";
        }
        if (lIN_CLOSE_WRITE) {
            s = String.valueOf(s) + "IN_CLOSE_WRITE|";
        }
        if (lIN_CLOSE_NOWRITE) {
            s = String.valueOf(s) + "IN_CLOSE_NOWRITE|";
        }
        if (lIN_OPEN) {
            s = String.valueOf(s) + "IN_OPEN|";
        }
        if (lIN_MOVED_FROM) {
            s = String.valueOf(s) + "IN_MOVED_FROM|";
        }
        if (lIN_MOVED_TO) {
            s = String.valueOf(s) + "IN_MOVED_TO|";
        }
        if (lIN_CREATE) {
            s = String.valueOf(s) + "IN_CREATE|";
        }
        if (lIN_DELETE) {
            s = String.valueOf(s) + "IN_DELETE|";
        }
        if (lIN_DELETE_SELF) {
            s = String.valueOf(s) + "IN_DELETE_SELF|";
        }
        if (lIN_MOVE_SELF) {
            s = String.valueOf(s) + "IN_MOVE_SELF|";
        }
        if (lIN_UNMOUNT) {
            s = String.valueOf(s) + "IN_UNMOUNT|";
        }
        if (lIN_Q_OVERFLOW) {
            s = String.valueOf(s) + "IN_Q_OVERFLOW|";
        }
        if (lIN_IGNORED) {
            s = String.valueOf(s) + "IN_IGNORED|";
        }
        return s;
    }

    static void debug(String msg) {
    }

    public static void warn(String warning) {
        if (WARN) {
            System.err.println(warning);
        }
    }
}

