/*
 * Decompiled with CFR 0.152.
 */
package net.contentobjects.jnotify.linux;

import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import net.contentobjects.jnotify.IJNotify;
import net.contentobjects.jnotify.JNotifyException;
import net.contentobjects.jnotify.JNotifyListener;
import net.contentobjects.jnotify.Util;
import net.contentobjects.jnotify.linux.INotifyListener;
import net.contentobjects.jnotify.linux.JNotify_linux;

public class JNotifyAdapterLinux
implements IJNotify {
    private Hashtable<Integer, Integer> _linuxWd2Wd;
    private Hashtable<Integer, WatchData> _id2Data;
    private Hashtable<String, String> _autoWatchesPaths;
    private static int _watchIDCounter = 0;

    public JNotifyAdapterLinux() {
        JNotify_linux.setNotifyListener(new INotifyListener(){

            @Override
            public void notify(String name, int wd, int mask, int cookie) {
                try {
                    JNotifyAdapterLinux.this.notifyChangeEvent(name, wd, mask, cookie);
                }
                catch (RuntimeException e) {
                    e.printStackTrace(System.out);
                }
            }
        });
        this._id2Data = new Hashtable();
        this._linuxWd2Wd = new Hashtable();
        this._autoWatchesPaths = new Hashtable();
    }

    @Override
    public int addWatch(String path, int mask, boolean watchSubtree, JNotifyListener listener) throws JNotifyException {
        JNotify_linux.debug("JNotifyAdapterLinux.addWatch(path=" + path + ",mask=" + Util.getMaskDesc(mask) + ", watchSubtree=" + watchSubtree + ")");
        int linuxMask = 0;
        if ((mask & 1) != 0) {
            linuxMask |= 0x100;
        }
        if ((mask & 2) != 0) {
            linuxMask |= 0x200;
            linuxMask |= 0x400;
        }
        if ((mask & 4) != 0) {
            linuxMask |= 4;
            linuxMask |= 2;
        }
        if ((mask & 8) != 0) {
            linuxMask |= 0x40;
            linuxMask |= 0x80;
        }
        if (watchSubtree) {
            linuxMask |= 0x100;
        }
        WatchData watchData = this.createWatch(null, true, new File(path), mask, linuxMask, watchSubtree, listener);
        if (watchSubtree) {
            try {
                File file = new File(path);
                this.registerToSubTree(true, watchData, file, false);
            }
            catch (JNotifyException e) {
                this.removeWatch(watchData._wd);
                throw e;
            }
        }
        return watchData._wd;
    }

    private WatchData createWatch(WatchData parentWatchData, boolean user, File path, int mask, int linuxMask, boolean watchSubtree, JNotifyListener listener) throws JNotifyException {
        String absPath = path.getPath();
        int wd = _watchIDCounter++;
        int linuxWd = JNotify_linux.addWatch(absPath, linuxMask);
        WatchData watchData = new WatchData(parentWatchData, user, absPath, wd, linuxWd, mask, linuxMask, watchSubtree, listener);
        this._linuxWd2Wd.put(linuxWd, wd);
        this._id2Data.put(wd, watchData);
        if (!user) {
            this._autoWatchesPaths.put(absPath, absPath);
        }
        return watchData;
    }

    private void registerToSubTree(boolean isRoot, WatchData parentWatch, File root, boolean fireCreatedEvents) throws JNotifyException {
        if (!parentWatch._user) {
            throw new RuntimeException("!parentWatch._user");
        }
        if (fireCreatedEvents && (parentWatch._mask & 1) != 0) {
            String name = root.toString().substring(parentWatch._path.length() + 1);
            parentWatch.notifyFileCreated(name);
        }
        if (root.isDirectory()) {
            String[] files;
            if (!isRoot) {
                try {
                    this.createWatch(parentWatch, false, root, parentWatch._mask, parentWatch._linuxMask, parentWatch._watchSubtree, parentWatch._listener);
                }
                catch (JNotifyException e) {
                    if (e.getErrorCode() == 2) {
                        JNotify_linux.warn("JNotifyAdapterLinux.registerToSubTree : warning, failed to register " + root + " :" + e.getMessage());
                    }
                    throw e;
                }
            }
            if ((files = root.list()) != null) {
                int i = 0;
                while (i < files.length) {
                    String file = files[i];
                    this.registerToSubTree(false, parentWatch, new File(root, file), fireCreatedEvents);
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeWatch(int wd) throws JNotifyException {
        JNotify_linux.debug("JNotifyAdapterLinux.removeWatch(" + wd + ")");
        Hashtable<Integer, WatchData> hashtable = this._id2Data;
        synchronized (hashtable) {
            block4: {
                if (!this._id2Data.containsKey(wd)) break block4;
                WatchData watchData = this._id2Data.get(wd);
                this.unwatch(watchData);
                return true;
            }
            return false;
        }
    }

    private void unwatch(WatchData data) throws JNotifyException {
        JNotifyException ex = null;
        boolean ok = true;
        try {
            JNotify_linux.removeWatch(data._linuxWd);
        }
        catch (JNotifyException e) {
            e.printStackTrace();
            ex = e;
            ok = false;
        }
        if (data._user) {
            int i = 0;
            while (i < data._subWd.size()) {
                int wd = (Integer)data._subWd.get(i);
                try {
                    JNotify_linux.removeWatch(wd);
                }
                catch (JNotifyException e) {
                    e.printStackTrace();
                    ex = e;
                    ok = false;
                }
                ++i;
            }
        }
        if (!ok) {
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyChangeEvent(String name, int linuxWd, int linuxMask, int cookie) {
        Hashtable<Integer, WatchData> hashtable = this._id2Data;
        synchronized (hashtable) {
            Integer iwd = this._linuxWd2Wd.get(linuxWd);
            if (iwd == null) {
                System.out.println("JNotifyAdapterLinux: warning, recieved event for an unregisted LinuxWD " + linuxWd + " ignoring...");
                return;
            }
            WatchData watchData = this._id2Data.get(iwd);
            if (watchData != null) {
                if ((linuxMask & 0x100) != 0) {
                    File newRootFile = new File(watchData._path, name);
                    if (watchData._watchSubtree) {
                        try {
                            this.createWatch(watchData.getParentWatch(), false, newRootFile, watchData._mask, watchData._linuxMask, watchData._watchSubtree, watchData._listener);
                            WatchData parent = watchData.getParentWatch();
                            this.registerToSubTree(true, parent, newRootFile, true);
                        }
                        catch (JNotifyException jNotifyException) {}
                    }
                    if ((watchData._mask & 1) != 0) {
                        if (!this._autoWatchesPaths.contains(newRootFile.getPath())) {
                            watchData.notifyFileCreated(name);
                        } else {
                            JNotify_linux.debug("Assuming already sent event for " + newRootFile.getPath());
                        }
                    }
                } else if ((linuxMask & 0x400) != 0) {
                    watchData.notifyFileDeleted(name);
                } else if ((linuxMask & 0x200) != 0) {
                    watchData.notifyFileDeleted(name);
                } else if ((linuxMask & 4) != 0 || (linuxMask & 2) != 0) {
                    watchData.notifyFileModified(name);
                } else if ((linuxMask & 0x40) != 0) {
                    watchData.renaming(cookie, name);
                } else if ((linuxMask & 0x80) != 0) {
                    watchData.notifyFileRenamed(name, cookie);
                } else if ((linuxMask & 0x8000) != 0) {
                    this._linuxWd2Wd.remove(watchData._linuxWd);
                    this._id2Data.remove(watchData._wd);
                    if (!watchData._user) {
                        this._autoWatchesPaths.remove(watchData._path);
                        watchData.removeFromParent();
                    }
                }
            } else {
                System.out.println("JNotifyAdapterLinux: warning, recieved event for an unregisted WD " + iwd + ". ignoring...");
            }
        }
    }

    private void debugLinux(String name, int linuxWd, int linuxMask, int cookie) {
        String path;
        int wd;
        WatchData wdata;
        boolean IN_ACCESS = (linuxMask & 1) != 0;
        boolean IN_MODIFY = (linuxMask & 2) != 0;
        boolean IN_ATTRIB = (linuxMask & 4) != 0;
        boolean IN_CLOSE_WRITE = (linuxMask & 8) != 0;
        boolean IN_CLOSE_NOWRITE = (linuxMask & 0x10) != 0;
        boolean IN_OPEN = (linuxMask & 0x20) != 0;
        boolean IN_MOVED_FROM = (linuxMask & 0x40) != 0;
        boolean IN_MOVED_TO = (linuxMask & 0x80) != 0;
        boolean IN_CREATE = (linuxMask & 0x100) != 0;
        boolean IN_DELETE = (linuxMask & 0x200) != 0;
        boolean IN_DELETE_SELF = (linuxMask & 0x400) != 0;
        boolean IN_MOVE_SELF = (linuxMask & 0x800) != 0;
        boolean IN_UNMOUNT = (linuxMask & 0x2000) != 0;
        boolean IN_Q_OVERFLOW = (linuxMask & 0x4000) != 0;
        boolean IN_IGNORED = (linuxMask & 0x8000) != 0;
        String s = "";
        if (IN_ACCESS) {
            s = String.valueOf(s) + "IN_ACCESS, ";
        }
        if (IN_MODIFY) {
            s = String.valueOf(s) + "IN_MODIFY, ";
        }
        if (IN_ATTRIB) {
            s = String.valueOf(s) + "IN_ATTRIB, ";
        }
        if (IN_CLOSE_WRITE) {
            s = String.valueOf(s) + "IN_CLOSE_WRITE, ";
        }
        if (IN_CLOSE_NOWRITE) {
            s = String.valueOf(s) + "IN_CLOSE_NOWRITE, ";
        }
        if (IN_OPEN) {
            s = String.valueOf(s) + "IN_OPEN, ";
        }
        if (IN_MOVED_FROM) {
            s = String.valueOf(s) + "IN_MOVED_FROM, ";
        }
        if (IN_MOVED_TO) {
            s = String.valueOf(s) + "IN_MOVED_TO, ";
        }
        if (IN_CREATE) {
            s = String.valueOf(s) + "IN_CREATE, ";
        }
        if (IN_DELETE) {
            s = String.valueOf(s) + "IN_DELETE, ";
        }
        if (IN_DELETE_SELF) {
            s = String.valueOf(s) + "IN_DELETE_SELF, ";
        }
        if (IN_MOVE_SELF) {
            s = String.valueOf(s) + "IN_MOVE_SELF, ";
        }
        if (IN_UNMOUNT) {
            s = String.valueOf(s) + "IN_UNMOUNT, ";
        }
        if (IN_Q_OVERFLOW) {
            s = String.valueOf(s) + "IN_Q_OVERFLOW, ";
        }
        if (IN_IGNORED) {
            s = String.valueOf(s) + "IN_IGNORED, ";
        }
        if ((wdata = this._id2Data.get(wd = this._linuxWd2Wd.get(linuxWd).intValue())) != null) {
            path = wdata._path;
            if (path != null && name != "") {
                path = String.valueOf(path) + File.separator + name;
            }
        } else {
            path = name;
        }
        JNotify_linux.debug("Linux event : wd=" + linuxWd + " | " + s + " path: " + path + (cookie != 0 ? ", cookie=" + cookie : ""));
    }

    public int unitTest_getNumWatches() {
        return this._id2Data.size();
    }

    private static class WatchData {
        boolean _user;
        int _wd;
        private int _linuxWd;
        private ArrayList<Integer> _subWd;
        int _mask;
        int _linuxMask;
        boolean _watchSubtree;
        JNotifyListener _listener;
        static Hashtable<Integer, String> _cookieToOldName = new Hashtable();
        String _path;
        WatchData _parentWatchData;

        WatchData(WatchData parentWatchData, boolean user, String path, int wd, int linuxWd, int mask, int linuxMask, boolean watchSubtree, JNotifyListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException("Null listener");
            }
            this._parentWatchData = parentWatchData;
            this._user = user;
            this._subWd = new ArrayList();
            this._path = path;
            this._wd = wd;
            this._linuxMask = linuxMask;
            this._linuxWd = linuxWd;
            this._mask = mask;
            this._watchSubtree = watchSubtree;
            this._listener = listener;
            if (parentWatchData != null) {
                parentWatchData.addSubwatch(this._linuxWd);
            }
        }

        public WatchData getParentWatch() {
            return this._user ? this : this._parentWatchData;
        }

        public void removeFromParent() {
            if (this._parentWatchData == null) {
                throw new RuntimeException("no parent");
            }
            this._parentWatchData.remveSubwatch(this._linuxWd);
        }

        public void renaming(int cookie, String name) {
            _cookieToOldName.put(cookie, this.getOutName(name));
        }

        public void notifyFileRenamed(String name, int cookie) {
            String oldName = _cookieToOldName.remove(cookie);
            String outRoot = this.getOutRoot();
            String outNewName = this.getOutName(name);
            this._listener.fileRenamed(this.getParentWatchID(), outRoot, oldName, outNewName);
        }

        public void notifyFileModified(String name) {
            String outRoot = this.getOutRoot();
            String outName = this.getOutName(name);
            this._listener.fileModified(this.getParentWatchID(), outRoot, outName);
        }

        public void notifyFileDeleted(String name) {
            String outRoot = this.getOutRoot();
            String outName = this.getOutName(name);
            this._listener.fileDeleted(this.getParentWatchID(), outRoot, outName);
        }

        public void notifyFileCreated(String name) {
            String outRoot = this.getOutRoot();
            String outName = this.getOutName(name);
            this._listener.fileCreated(this.getParentWatchID(), outRoot, outName);
        }

        void remveSubwatch(int linuxWd) {
            if (!this._subWd.remove((Object)linuxWd)) {
                throw new RuntimeException("Error removing " + linuxWd + " from list");
            }
        }

        void addSubwatch(int linuxWd) {
            this._subWd.add(linuxWd);
        }

        public String toString() {
            return "WatchData " + this._path + ", wd=" + this._wd + ", linuxWd=" + this._linuxWd + (this._watchSubtree ? ", recursive" : "") + (this._user ? ", user" : ", auto");
        }

        private String getOutRoot() {
            String outRoot = this._user ? this._path : this.getParentWatch()._path;
            return outRoot;
        }

        private String getOutName(String name) {
            String outName;
            if (this._user) {
                outName = name;
            } else {
                outName = this._path.substring(this.getParentWatch()._path.length() + 1);
                if (name != "") {
                    outName = String.valueOf(outName) + File.separatorChar + name;
                }
            }
            return outName;
        }

        public int getParentWatchID() {
            return this._parentWatchData == null ? this._wd : this._parentWatchData._wd;
        }
    }
}

