/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ui.widgets;

import com.aptana.ui.util.SWTUtils;
import com.aptana.ui.util.UIUtils;
import java.text.MessageFormat;
import java.util.Arrays;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class StepIndicatorComposite
extends Composite {
    private String[] stepNames;
    private static Color selectedColor = new Color((Device)UIUtils.getDisplay(), 41, 55, 64);
    private static Color normalColor = new Color((Device)UIUtils.getDisplay(), 132, 156, 180);
    private static Color borderColor = UIUtils.getDisplay().getSystemColor(15);
    private static Color selectedTextColor = UIUtils.getDisplay().getSystemColor(1);
    private Font selectedTextFont;
    private StepComposite[] steps;

    public StepIndicatorComposite(Composite parent, String[] stepNames) {
        super(parent, 0);
        this.setBackground(normalColor);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.marginBottom = 1;
        this.setLayout((Layout)layout);
        this.setLayoutData(GridDataFactory.swtDefaults().grab(true, false).align(4, 0x1000000).create());
        if (stepNames != null) {
            this.createSteps(stepNames);
        } else {
            this.setVisible(false);
        }
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                GC gc = e.gc;
                gc.setForeground(borderColor);
                Composite stepComposite = (Composite)e.widget;
                Rectangle bounds = stepComposite.getClientArea();
                --bounds.width;
                --bounds.height;
                gc.drawRectangle(bounds);
            }
        });
    }

    public void createSteps(String[] stepNames) {
        this.stepNames = stepNames;
        GridLayout layout = new GridLayout(stepNames.length, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        this.setLayout((Layout)layout);
        if (this.steps != null) {
            StepComposite[] stepCompositeArray = this.steps;
            int n = this.steps.length;
            int n2 = 0;
            while (n2 < n) {
                StepComposite composite = stepCompositeArray[n2];
                composite.dispose();
                ++n2;
            }
        }
        this.steps = new StepComposite[stepNames.length];
        int i = 0;
        while (i < stepNames.length) {
            this.steps[i] = new StepComposite(this, stepNames[i], i == 0);
            ++i;
        }
        if (this.steps.length > 0) {
            this.steps[0].setSelection(true);
        }
    }

    public void setSelection(int index) {
        if (this.steps != null) {
            int i = 0;
            while (i < this.steps.length) {
                this.steps[i].setSiblingSelected(i + 1 == index);
                this.steps[i].setSelection(i == index);
                ++i;
            }
        }
    }

    public void setSelection(String stepName) {
        if (this.steps != null) {
            int selectedIndex = Arrays.asList(this.stepNames).indexOf(stepName);
            this.setSelection(selectedIndex);
        }
    }

    public void dispose() {
        super.dispose();
        if (selectedColor != null) {
            selectedColor.dispose();
        }
        if (this.selectedTextFont != null) {
            this.selectedTextFont.dispose();
        }
        if (normalColor != null) {
            normalColor.dispose();
        }
    }

    private class StepComposite
    extends Composite {
        String stepName;
        Label stepLabel;
        Composite stepComposite;
        Composite stepDecorator;
        boolean selection;
        boolean siblingSelected;
        boolean drawBorder;

        public StepComposite(Composite parent, String step, boolean drawBorder) {
            super(parent, 0);
            this.selection = false;
            this.siblingSelected = false;
            this.drawBorder = false;
            this.stepName = step;
            this.drawBorder = drawBorder;
            GridLayout layout = new GridLayout(2, false);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.horizontalSpacing = 0;
            this.setLayout((Layout)layout);
            this.createElements();
        }

        private void createElements() {
            this.stepComposite = new Composite((Composite)this, 0);
            this.stepComposite.setLayout((Layout)new GridLayout());
            this.stepComposite.setLayoutData((Object)GridDataFactory.swtDefaults().align(0x1000000, 0x1000000).create());
            this.stepComposite.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    GC gc = e.gc;
                    Rectangle bounds = StepComposite.this.stepComposite.getClientArea();
                    gc.setForeground(borderColor);
                    gc.drawLine(bounds.x - 1, bounds.y, bounds.x + bounds.width, bounds.y);
                    gc.drawLine(bounds.x - 1, bounds.y + bounds.height - 1, bounds.x + bounds.width, bounds.y + bounds.height - 1);
                    if (StepComposite.this.drawBorder) {
                        gc.drawLine(bounds.x, bounds.y, bounds.x, bounds.y + bounds.height);
                    }
                }
            });
            this.stepLabel = new Label(this.stepComposite, 0);
            this.stepLabel.setText(MessageFormat.format(" {0} ", this.stepName));
            this.stepLabel.setLayoutData((Object)GridDataFactory.swtDefaults().grab(false, false).align(0x1000000, 0x1000000).create());
            ((GridData)this.stepLabel.getLayoutData()).widthHint = this.stepLabel.computeSize((int)-1, (int)-1).x;
            this.stepDecorator = new Composite((Composite)this, 0);
            GridData gridData = GridDataFactory.swtDefaults().align(0x1000000, 0x1000000).create();
            gridData.heightHint = this.stepComposite.computeSize((int)-1, (int)-1).y;
            if (gridData.heightHint % 2 == 0) {
                ++gridData.heightHint;
            }
            gridData.widthHint = (gridData.heightHint - 1) / 2 + 1;
            ((GridData)this.stepComposite.getLayoutData()).heightHint = gridData.heightHint;
            if (StepIndicatorComposite.this.selectedTextFont == null) {
                Font font2 = this.stepLabel.getFont();
                FontData[] fontData = SWTUtils.boldFont(font2);
                StepIndicatorComposite.this.selectedTextFont = new Font((Device)this.getDisplay(), fontData);
            }
            this.stepDecorator.setLayoutData((Object)gridData);
            this.stepDecorator.setBackground(normalColor);
            this.stepDecorator.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    GC gc = e.gc;
                    Composite decorator = (Composite)e.widget;
                    Rectangle bounds = decorator.getClientArea();
                    if (StepComposite.this.selection) {
                        gc.setForeground(selectedColor);
                        gc.setBackground(selectedColor);
                        int[] polygonPath = new int[]{bounds.x, bounds.y, bounds.x + bounds.width - 1, bounds.y + (bounds.height - 1) / 2, bounds.x, bounds.y + bounds.height - 1};
                        gc.fillPolygon(polygonPath);
                    } else if (StepComposite.this.siblingSelected) {
                        gc.setForeground(selectedColor);
                        gc.setBackground(selectedColor);
                        int[] polygonPath = new int[]{bounds.x + 1, bounds.y + 1, bounds.x + bounds.width, bounds.y + (bounds.height - 1) / 2 + 1, bounds.x + bounds.width, bounds.y + 1};
                        gc.fillPolygon(polygonPath);
                        polygonPath = new int[]{bounds.x + 1, bounds.y + bounds.height - 1, bounds.x + bounds.width, bounds.y + (bounds.height - 1) / 2 + 1, bounds.x + bounds.width, bounds.y + bounds.height - 1};
                        gc.fillPolygon(polygonPath);
                    }
                    gc.setForeground(borderColor);
                    gc.drawLine(bounds.x, bounds.y, bounds.x + bounds.width - 1, bounds.y + (bounds.height - 1) / 2);
                    gc.drawLine(bounds.x + bounds.width - 1, bounds.y + (bounds.height - 1) / 2, bounds.x, bounds.y + bounds.height - 1);
                    gc.drawLine(bounds.x - 1, bounds.y, bounds.x + bounds.width + 1, bounds.y);
                    gc.drawLine(bounds.x - 1, bounds.y + bounds.height - 1, bounds.x + bounds.width + 1, bounds.y + bounds.height - 1);
                }
            });
        }

        void setSelection(boolean selection) {
            this.selection = selection;
            this.stepComposite.setBackground(this.selection ? selectedColor : normalColor);
            this.stepLabel.setBackground(this.selection ? selectedColor : normalColor);
            this.stepLabel.setForeground((Color)(this.selection ? selectedTextColor : null));
            this.stepLabel.setFont(this.selection ? StepIndicatorComposite.this.selectedTextFont : null);
            this.stepDecorator.redraw();
        }

        void setSiblingSelected(boolean selection) {
            this.siblingSelected = selection;
        }
    }
}

