/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ui.widgets;

import com.aptana.core.projects.templates.IProjectTemplate;
import com.aptana.ui.widgets.Messages;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;

public class SelectedTemplateComposite
extends Composite {
    private IProjectTemplate projectTemplate;
    private Group group;
    private Image templateIcon;
    private boolean displayingMore = false;

    public SelectedTemplateComposite(Composite parent, IProjectTemplate projectTemplate) {
        super(parent, 0);
        this.projectTemplate = projectTemplate;
        this.createContents();
    }

    protected void createContents() {
        this.setLayoutData(GridDataFactory.fillDefaults().grab(true, true).create());
        this.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        this.group = new Group((Composite)this, 0);
        this.group.setText(Messages.SelectedTemplateGroup_Label);
        GridData gd_group = GridDataFactory.fillDefaults().grab(true, false).create();
        this.group.setLayoutData((Object)gd_group);
        this.group.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).create());
        if (this.projectTemplate.getIconURL() != null) {
            Label templateLabel = new Label((Composite)this.group, 0);
            this.templateIcon = ImageDescriptor.createFromURL((URL)this.projectTemplate.getIconURL()).createImage();
            templateLabel.setImage(this.templateIcon);
            templateLabel.setLayoutData((Object)GridDataFactory.swtDefaults().align(16384, 1).create());
        }
        Composite labelComp = new Composite((Composite)this.group, 0);
        labelComp.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        labelComp.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        Label templateValue = new Label(labelComp, 64);
        templateValue.setText(this.projectTemplate.getDisplayName());
        templateValue.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 1).grab(true, false).create());
        String description = this.projectTemplate.getDescription();
        final Link descriptionValue = new Link(labelComp, 64);
        if (description.length() > 150) {
            this.displayingMore = true;
            int cutoffIndex = description.indexOf(".") + 1;
            if (cutoffIndex > 150) {
                cutoffIndex = 150;
            }
            final int cutoff = cutoffIndex;
            description = MessageFormat.format(Messages.SelectedTemplateDesc_More_Label, this.projectTemplate.getDescription().substring(0, cutoff));
            descriptionValue.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    Rectangle bounds = descriptionValue.getBounds();
                    int width = bounds.width;
                    if (!SelectedTemplateComposite.this.displayingMore) {
                        descriptionValue.setText(MessageFormat.format(Messages.SelectedTemplateDesc_More_Label, SelectedTemplateComposite.this.projectTemplate.getDescription().substring(0, cutoff)));
                    } else {
                        descriptionValue.setText(MessageFormat.format(Messages.SelectedTemplateDesc_Less_Label, SelectedTemplateComposite.this.projectTemplate.getDescription()));
                    }
                    SelectedTemplateComposite.this.displayingMore = !SelectedTemplateComposite.this.displayingMore;
                    Point computeSize = descriptionValue.computeSize(width, -1);
                    int diff = computeSize.y - bounds.height + 2;
                    descriptionValue.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).hint(computeSize).create());
                    SelectedTemplateComposite.this.layout(true, true);
                    Point size = SelectedTemplateComposite.this.getShell().getSize();
                    size.y += diff;
                    SelectedTemplateComposite.this.getShell().setSize(size);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        GridData layoutData = new GridData(4, 1, true, true, 1, 1);
        descriptionValue.setText(description);
        Point computeSize = templateValue.computeSize(-1, -1);
        layoutData.widthHint = 1;
        layoutData.heightHint = computeSize.y * 2;
        descriptionValue.setLayoutData((Object)layoutData);
    }

    public void dispose() {
        if (this.templateIcon != null) {
            this.templateIcon.dispose();
        }
        super.dispose();
    }
}

