/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ui.widgets;

import com.aptana.core.CoreStrings;
import com.aptana.core.util.StringUtil;
import com.aptana.ui.UIPlugin;
import com.aptana.ui.util.SWTUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class CListTable
extends Composite {
    private Button addButton;
    private Button editButton;
    private Button removeButton;
    private Label descriptionLabel;
    private TableViewer tableViewer;
    private List<Object> items = new ArrayList<Object>();
    private List<Listener> listeners = new ArrayList<Listener>();

    public CListTable(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        this.descriptionLabel = new Label((Composite)this, 64);
        this.descriptionLabel.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        Composite buttons = new Composite((Composite)this, 0);
        buttons.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(3).create());
        buttons.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.addButton = new Button(buttons, 8);
        this.addButton.setToolTipText(StringUtil.ellipsify((String)CoreStrings.ADD));
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean itemAdded = false;
                Object newItem = null;
                for (Listener listener : CListTable.this.listeners) {
                    newItem = listener.addItem();
                    if (newItem == null) continue;
                    CListTable.this.items.add(newItem);
                    itemAdded = true;
                }
                if (itemAdded) {
                    CListTable.this.tableViewer.refresh();
                    CListTable.this.tableViewer.setSelection((ISelection)new StructuredSelection(newItem));
                    for (Listener listener : CListTable.this.listeners) {
                        listener.itemsChanged(CListTable.this.getItems());
                    }
                }
            }
        });
        this.addButton.setImage(SWTUtils.getImage(UIPlugin.getDefault(), "/icons/add.gif"));
        this.editButton = new Button(buttons, 8);
        this.editButton.setToolTipText(StringUtil.ellipsify((String)CoreStrings.EDIT));
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)CListTable.this.tableViewer.getSelection();
                if (!selection.isEmpty()) {
                    Object element = selection.getFirstElement();
                    CListTable.this.items.remove(element);
                    Object newElement = null;
                    boolean changed = false;
                    for (Listener listener : CListTable.this.listeners) {
                        newElement = listener.editItem(element);
                        if (newElement == null) continue;
                        CListTable.this.items.add(newElement);
                        changed = true;
                    }
                    if (changed) {
                        CListTable.this.tableViewer.refresh();
                        CListTable.this.tableViewer.setSelection((ISelection)new StructuredSelection(newElement));
                        for (Listener listener : CListTable.this.listeners) {
                            listener.itemsChanged(CListTable.this.getItems());
                        }
                    }
                }
            }
        });
        this.editButton.setImage(SWTUtils.getImage(UIPlugin.getDefault(), "/icons/edit.png"));
        this.removeButton = new Button(buttons, 8);
        this.removeButton.setToolTipText(CoreStrings.REMOVE);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] elements;
                IStructuredSelection selection = (IStructuredSelection)CListTable.this.tableViewer.getSelection();
                Object[] objectArray = elements = selection.toArray();
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    CListTable.this.items.remove(element);
                    ++n2;
                }
                CListTable.this.tableViewer.refresh();
                CListTable.this.updateStates();
                for (Listener listener : CListTable.this.listeners) {
                    listener.itemsChanged(CListTable.this.getItems());
                }
            }
        });
        this.removeButton.setImage(SWTUtils.getImage(UIPlugin.getDefault(), "/icons/delete.gif"));
        this.createTable(this);
    }

    public void addListener(Listener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public List<Object> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    public void setDescription(String description) {
        this.descriptionLabel.setText(description);
    }

    public void setItems(Object[] items) {
        this.items.clear();
        Object[] objectArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            this.items.add(item);
            ++n2;
        }
        this.tableViewer.refresh();
    }

    private void createTable(Composite parent) {
        this.tableViewer = new TableViewer(parent, 67586);
        this.tableViewer.getControl().setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.tableViewer.setComparator(new ViewerComparator());
        this.tableViewer.setInput(this.items);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CListTable.this.updateStates();
            }
        });
        this.updateStates();
    }

    private void updateStates() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        boolean hasSelection = !selection.isEmpty();
        boolean hasMultiSelections = selection.size() > 1;
        this.editButton.setEnabled(hasSelection && !hasMultiSelections);
        this.removeButton.setEnabled(hasSelection);
        this.addButton.setEnabled(true);
    }

    public void setEnabled(boolean enabled) {
        if (!enabled) {
            this.addButton.setEnabled(false);
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        } else {
            this.updateStates();
        }
        this.tableViewer.getTable().setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public static interface Listener {
        public Object addItem();

        public Object editItem(Object var1);

        public void itemsChanged(List<Object> var1);
    }
}

