/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ui.util;

import com.aptana.core.logging.IdeLog;
import com.aptana.ui.UIPlugin;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public final class WorkbenchBrowserUtil {
    private WorkbenchBrowserUtil() {
    }

    public static void launchExternalBrowser(String url) {
        try {
            WorkbenchBrowserUtil.launchExternalBrowser(new URL(url));
        }
        catch (MalformedURLException e) {
            IdeLog.logError((Plugin)UIPlugin.getDefault(), (Throwable)e);
        }
    }

    public static void launchExternalBrowser(URL url) {
        WorkbenchBrowserUtil.launchExternalBrowser(url, null);
    }

    public static IWebBrowser launchExternalBrowser(String url, String browserId) {
        try {
            return WorkbenchBrowserUtil.launchExternalBrowser(new URL(url), browserId);
        }
        catch (MalformedURLException e) {
            IdeLog.logError((Plugin)UIPlugin.getDefault(), (Throwable)e);
            return null;
        }
    }

    public static IWebBrowser launchExternalBrowser(URL url, String browserId) {
        IWebBrowser webBrowser;
        IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
        if (browserId != null) {
            try {
                webBrowser = support.createBrowser(128, browserId, null, null);
                if (webBrowser != null) {
                    webBrowser.openURL(url);
                    return webBrowser;
                }
            }
            catch (PartInitException e) {
                IdeLog.logError((Plugin)UIPlugin.getDefault(), (Throwable)e);
            }
        }
        try {
            webBrowser = support.getExternalBrowser();
            webBrowser.openURL(url);
            return webBrowser;
        }
        catch (PartInitException e) {
            IdeLog.logError((Plugin)UIPlugin.getDefault(), (Throwable)e);
            return null;
        }
    }

    public static IWebBrowser openURL(String url) {
        try {
            IWorkbenchBrowserSupport workbenchBrowserSupport = PlatformUI.getWorkbench().getBrowserSupport();
            IWebBrowser webBrowser = workbenchBrowserSupport.createBrowser(null);
            if (webBrowser != null) {
                webBrowser.openURL(new URL(url));
            }
            return webBrowser;
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)UIPlugin.getDefault(), (Throwable)e);
            return null;
        }
    }
}

