/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ui.util;

import com.aptana.ui.UIPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WWinActionBars;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.progress.UIJob;

public class StatusLineUtils {
    private static final Image INFO_IMG = UIPlugin.getImage("/icons/full/toc_obj.gif");
    private static final Image ERROR_IMG = UIPlugin.getImage("/icons/full/quickfix_error.png");

    public static void showStatusMessage(final String message, final long timeout) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (Display.getDefault().getActiveShell() == null || Display.getDefault().getActiveShell().isDisposed()) {
                    return;
                }
                WorkbenchWindow workbenchWindow = (WorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (workbenchWindow != null) {
                    workbenchWindow.setStatusLineVisible(true);
                    WWinActionBars bars = workbenchWindow.getActionBars();
                    IStatusLineManager lineManager = bars.getStatusLineManager();
                    lineManager.setMessage(INFO_IMG, message);
                    lineManager.update(true);
                    new ClearMessageJob(lineManager).schedule(timeout);
                }
            }
        });
    }

    public static void showErrorMessage(final String message, final long timeout) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (Display.getDefault().getActiveShell() == null || Display.getDefault().getActiveShell().isDisposed()) {
                    return;
                }
                WorkbenchWindow workbenchWindow = (WorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (workbenchWindow != null) {
                    workbenchWindow.setStatusLineVisible(true);
                    WWinActionBars bars = workbenchWindow.getActionBars();
                    IStatusLineManager lineManager = bars.getStatusLineManager();
                    lineManager.setErrorMessage(ERROR_IMG, message);
                    lineManager.update(true);
                    new ClearMessageJob(lineManager).schedule(timeout);
                }
            }
        });
    }

    static class ClearMessageJob
    extends UIJob {
        private IStatusLineManager lineManager = null;

        public ClearMessageJob(IStatusLineManager lineManager) {
            super("\u81ea\u52a8\u6e05\u9664\u72b6\u6001\u680f\u4fe1\u606f");
            this.lineManager = lineManager;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (this.lineManager != null) {
                this.lineManager.setMessage(null, null);
                this.lineManager.setErrorMessage(null, null);
                this.lineManager.update(true);
            }
            return Status.OK_STATUS;
        }
    }
}

