/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ui.commands;

import com.aptana.core.logging.IdeLog;
import com.aptana.ui.UIPlugin;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public class BrowserCommandHandler
extends AbstractHandler {
    private URL browserURL;
    private String browserId;

    public BrowserCommandHandler(String url, String browserId) {
        this.setURL(url);
        this.browserId = browserId;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (this.browserURL == null) {
            return null;
        }
        try {
            IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
            if (support.isInternalWebBrowserAvailable()) {
                support.createBrowser(46, this.browserId, null, null).openURL(this.browserURL);
            } else {
                support.getExternalBrowser().openURL(this.browserURL);
            }
        }
        catch (PartInitException e) {
            IdeLog.logError((Plugin)UIPlugin.getDefault(), (Throwable)e);
        }
        return null;
    }

    protected void setURL(String url) {
        try {
            this.browserURL = new URL(url);
        }
        catch (MalformedURLException e) {
            IdeLog.logError((Plugin)UIPlugin.getDefault(), (Throwable)e);
        }
    }
}

