/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ui.actions;

import com.aptana.ui.actions.DefaultNavigatorContributionItem;
import com.aptana.ui.util.UIUtils;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.menus.MenuUtil;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;

public abstract class DefaultNavigatorActionProvider
extends CommonActionProvider {
    private IWorkbenchPartSite partSite;
    private DefaultNavigatorContributionItem toolbarItem;
    private boolean isToolbarFilled;
    protected Image disabledImage;

    public void init(ICommonActionExtensionSite aSite) {
        super.init(aSite);
        this.partSite = ((ICommonViewerWorkbenchSite)aSite.getViewSite()).getSite();
    }

    public void fillActionBars(IActionBars actionBars) {
        if (!this.isToolbarFilled) {
            this.toolbarItem = this.fillToolbar(actionBars.getToolBarManager());
            actionBars.updateActionBars();
            this.isToolbarFilled = true;
        }
        this.toolbarItem.setEnabled(this.isEnabled());
    }

    public abstract String getActionId();

    protected abstract Image getImage();

    protected Image getHotImage() {
        return null;
    }

    protected Image getDisabledImage() {
        if (this.getImage() != null && this.disabledImage == null) {
            this.disabledImage = new Image((Device)UIUtils.getDisplay(), this.getImage(), 1);
        }
        return this.disabledImage;
    }

    protected abstract String getMenuId();

    protected IWorkbenchPartSite getPartSite() {
        return this.partSite;
    }

    protected String getToolTip() {
        return null;
    }

    protected boolean isEnabled() {
        return false;
    }

    protected void run(ToolBar parent) {
        if (!this.isEnabled()) {
            return;
        }
        Point toolbarLocation = parent.getLocation();
        toolbarLocation = parent.getParent().toDisplay(toolbarLocation.x, toolbarLocation.y);
        Point toolbarSize = parent.getSize();
        MenuManager menuManager = new MenuManager(null, this.getMenuId());
        IMenuService menuService = (IMenuService)this.partSite.getService(IMenuService.class);
        menuService.populateContributionManager((ContributionManager)menuManager, MenuUtil.menuUri((String)menuManager.getId()));
        this.fillMenu(menuManager);
        Menu menu = menuManager.createContextMenu((Control)parent);
        menu.setLocation(toolbarLocation.x, toolbarLocation.y + toolbarSize.y + 2);
        menu.setVisible(true);
    }

    protected void fillMenu(MenuManager menuManager) {
    }

    protected DefaultNavigatorContributionItem fillToolbar(IToolBarManager toolBarManager) {
        DefaultNavigatorContributionItem item = new DefaultNavigatorContributionItem(this);
        toolBarManager.add((IContributionItem)item);
        return item;
    }

    public void dispose() {
        super.dispose();
        if (this.disabledImage != null) {
            this.disabledImage.dispose();
        }
    }
}

