/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ui;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.ui.Messages;
import com.aptana.ui.PerspectiveChangeResetListener;
import com.aptana.ui.browser.BrowserManager;
import com.aptana.ui.util.UIUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ide.actions.ToggleAutoBuildAction;
import org.eclipse.ui.internal.ide.dialogs.IDEWorkspacePreferencePage;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;

public class UIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.aptana.ui";
    private static UIPlugin plugin;
    private IEclipsePreferences.IPreferenceChangeListener autoBuildListener;
    private final IPerspectiveListener perspectiveListener = new PerspectiveChangeResetListener("com.aptana.ui.WebPerspective", "com.aptana.ui", "PerspectiveVersion", 114);
    private boolean hasMainWindowActivated = false;
    private final IWindowListener windowListener = new IWindowListener(){

        public void windowActivated(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
            window.removePerspectiveListener(UIPlugin.this.perspectiveListener);
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowOpened(IWorkbenchWindow window) {
            window.addPerspectiveListener(UIPlugin.this.perspectiveListener);
            if (!UIPlugin.this.hasMainWindowActivated) {
                UIPlugin.this.hasMainWindowActivated = true;
                IWorkbenchPage page = window.getActivePage();
                if (page != null) {
                    UIPlugin.this.perspectiveListener.perspectiveActivated(page, page.getPerspective());
                }
            }
        }
    };

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.updateInitialPerspectiveVersion();
        this.addPerspectiveListener();
        plugin = this;
        Job job = new Job("Initializing UI Plugin"){

            protected IStatus run(IProgressMonitor monitor) {
                UIPlugin.this.addAutoBuildListener();
                BrowserManager.getInstance().searchMoreBrowsers();
                return Status.OK_STATUS;
            }
        };
        EclipseUtil.setSystemForJob((Job)job);
        job.schedule();
    }

    public void stop(BundleContext context) throws Exception {
        try {
            this.removePerspectiveListener();
            this.removeAutoBuildListener();
        }
        finally {
            plugin = null;
            super.stop(context);
        }
    }

    public static UIPlugin getDefault() {
        return plugin;
    }

    public static Image getImage(String string) {
        ImageDescriptor id;
        if (UIPlugin.getDefault().getImageRegistry().get(string) == null && (id = UIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)string)) != null) {
            UIPlugin.getDefault().getImageRegistry().put(string, id);
        }
        return UIPlugin.getDefault().getImageRegistry().get(string);
    }

    public static ImageDescriptor getImageDescriptor(String string) {
        ImageDescriptor id;
        if (UIPlugin.getDefault().getImageRegistry().getDescriptor(string) == null && (id = UIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)string)) != null) {
            UIPlugin.getDefault().getImageRegistry().put(string, id);
        }
        return UIPlugin.getDefault().getImageRegistry().getDescriptor(string);
    }

    private void addAutoBuildListener() {
        IEclipsePreferences node = EclipseUtil.instanceScope().getNode("org.eclipse.core.resources");
        this.autoBuildListener = new AutoBuildListener();
        node.addPreferenceChangeListener(this.autoBuildListener);
    }

    private void removeAutoBuildListener() {
        if (this.autoBuildListener != null) {
            IEclipsePreferences node = EclipseUtil.instanceScope().getNode("org.eclipse.core.resources");
            node.removePreferenceChangeListener(this.autoBuildListener);
            this.autoBuildListener = null;
        }
    }

    private void addPerspectiveListener() {
        try {
            IWorkbench workbench = PlatformUI.getWorkbench();
            if (workbench != null) {
                IWorkbenchWindow[] windows;
                IWorkbenchWindow[] iWorkbenchWindowArray = windows = workbench.getWorkbenchWindows();
                int n = windows.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                    window.addPerspectiveListener(this.perspectiveListener);
                    ++n2;
                }
                PlatformUI.getWorkbench().addWindowListener(this.windowListener);
            }
        }
        catch (Exception exception) {}
    }

    private void removePerspectiveListener() {
        IWorkbench workbench = null;
        try {
            workbench = PlatformUI.getWorkbench();
        }
        catch (Exception exception) {}
        if (workbench != null) {
            IWorkbenchWindow[] windows;
            IWorkbenchWindow[] iWorkbenchWindowArray = windows = workbench.getWorkbenchWindows();
            int n = windows.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                window.removePerspectiveListener(this.perspectiveListener);
                ++n2;
            }
            PlatformUI.getWorkbench().removeWindowListener(this.windowListener);
        }
    }

    private void updateInitialPerspectiveVersion() {
        boolean hasStartedBefore = Platform.getPreferencesService().getBoolean(PLUGIN_ID, "IDEHasLaunchedBefore", false, null);
        if (!hasStartedBefore) {
            IEclipsePreferences prefs = EclipseUtil.instanceScope().getNode(PLUGIN_ID);
            prefs.putInt("PerspectiveVersion", 114);
            prefs.putBoolean("IDEHasLaunchedBefore", true);
            try {
                prefs.flush();
            }
            catch (BackingStoreException e) {
                IdeLog.logError((Plugin)UIPlugin.getDefault(), (String)Messages.UIPlugin_ERR_FailToSetPref, (Throwable)e);
            }
        }
    }

    public class AutoBuildListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if ("description.autobuilding".equals(event.getKey()) && Boolean.FALSE.toString().equals(event.getNewValue())) {
                StackTraceElement[] stackTrace;
                String buildToggleActionClassName = ToggleAutoBuildAction.class.getCanonicalName();
                String workspacePreferencePage = IDEWorkspacePreferencePage.class.getCanonicalName();
                StackTraceElement[] stackTraceElementArray = stackTrace = new Exception().getStackTrace();
                int n = stackTrace.length;
                int n2 = 0;
                while (n2 < n) {
                    StackTraceElement element = stackTraceElementArray[n2];
                    String className = element.getClassName();
                    if (className.equals(buildToggleActionClassName) || className.equals(workspacePreferencePage)) {
                        MessageDialog.openWarning((Shell)UIUtils.getActiveShell(), (String)Messages.UIPlugin_automaticBuildsWarningTitle, (String)Messages.UIPlugin_automaticBuildsWarningMessage);
                    }
                    ++n2;
                }
            }
        }
    }
}

