/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ui;

import com.aptana.core.ShellExecutable;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ProcessUtil;
import com.aptana.core.util.SudoProcessRunnable;
import com.aptana.ui.Messages;
import com.aptana.ui.UIPlugin;
import com.aptana.ui.dialogs.SudoPasswordPromptDialog;
import com.aptana.ui.util.UIUtils;
import java.io.IOException;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.window.IShellProvider;

public class SudoManager {
    private char[] validPassword = new char[0];
    private String SUDO = "sudo";
    private String ECHO = "echo";
    private String SUDO_INPUT_PWD = "-S";
    private String ECHO_MESSAGE = "SUCCESS";

    public boolean authenticate(char[] password) throws CoreException {
        try {
            Map environment = ShellExecutable.getEnvironment();
            environment.put(ProcessUtil.REDIRECT_ERROR_STREAM, "");
            Process p = ProcessUtil.run((String)this.SUDO, null, (Map)environment, (String[])new String[]{this.SUDO_INPUT_PWD, this.ECHO, this.ECHO_MESSAGE});
            SudoProcessRunnable runnable = new SudoProcessRunnable(p, password, this.ECHO_MESSAGE);
            Thread t = new Thread((Runnable)runnable);
            t.start();
            t.join();
            IStatus status = runnable.getResult();
            if (status.isOK()) {
                this.validPassword = password;
                return true;
            }
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)UIPlugin.getDefault(), (String)e.getMessage());
        }
        catch (InterruptedException e) {
            IdeLog.logError((Plugin)UIPlugin.getDefault(), (String)e.getMessage());
        }
        return false;
    }

    public char[] getPassword() throws CoreException {
        final IStatus[] status = new IStatus[]{Status.OK_STATUS};
        if (this.validPassword.length == 0) {
            UIUtils.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        boolean retry;
                        String promptMessage = Messages.SudoManager_MessagePrompt;
                        do {
                            retry = false;
                            SudoPasswordPromptDialog sudoDialog = new SudoPasswordPromptDialog((IShellProvider)UIUtils.getActiveWorkbenchWindow(), promptMessage);
                            if (sudoDialog.open() == 0 && !SudoManager.this.authenticate(sudoDialog.getPassword())) {
                                retry = true;
                            }
                            promptMessage = Messages.Sudo_Invalid_Password_Prompt;
                        } while (retry);
                    }
                    catch (CoreException e) {
                        status[0] = e.getStatus();
                    }
                }
            });
        }
        if (status[0] != Status.OK_STATUS) {
            throw new CoreException(status[0]);
        }
        return this.validPassword;
    }
}

